Ext.define('Academia.controller.sponsorship.SponsorshipReceiptController', {
    
	extend: 'Academia.controller.base.BaseController',
   
    views: ['Academia.view.sponsorship.SponsorshipReceipt','sponsorship.SponsorshipReceiptsViewRefundedAmountWindow',
            'sponsorship.SponsorshipReceiptsTransactionsDetailsGrid',
            'sponsorship.SponsorshipReceiptsTransactionFeesAndPaymentDetailsGrid',
            'sponsorship.SponsorshipReceiptsTransactionDetails',
            'sponsorship.SponsorshipReceiptsTransactionStudentDetailsForm', 
            'Academia.view.sponsorship.SponsorshipReceiptSearchForm','sponsorship.SponsorshipReceiptGrid'],
    
    stores:['sponsorship.SponsorshipTransactionDetailsStore',
            'scholarships.TransactionTypes','feeandpayment.payment.BillHeaderAdjustmentDetails',
            'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch','sponsorship.SponsorshipReceiptFeePlanStore',
            'sponsorship.SponsoredReceiptStudentSearchStore'],
    
    refs: [{
	    	ref: 'contentPanel',
	        selector: 'contentPanel'
   		}, {
	   		ref : 'sponsorshipreceipt',
	   		selector : 'sponsorshipreceipt'
	   	},{
	   		ref : 'sponsorshipReceiptForm',
	   		selector : 'sponsorshipreceiptsearchform form[itemId=sponsorshipReceipt]'
	   	}, {
	   		ref : 'studentdetailsform',
	   		selector : 'studentdetailsform[itemId=studentSponsorshipDetailsForm]'
	   	}, {
	   		ref : 'sponsorshipFeesAndPaymentDetailsGrid',
	   		selector:'feesandpaymentdetailsgrid[itemId=sponsorshipFeesAndPaymentDetailsGrid]'
	   	}, {
	   		ref : 'sponsorshipTransactionsDetailsGrid',
	   		selector:'transactionsdetailsgrid[itemId=sponsorshipTransactionsDetailsGrid]'
	   	}, {
	   		ref : 'searchResultGrid',
	   		selector:'sponsorshipreceiptscreen grid[itemId=sponsorshipReceiptGrid]'
		},{
			ref : 'sponsorshipreceiptgrid',
	   		selector:'sponsorshipreceiptgrid'
		}],
		config: {
			SPONSORSHIP_RECEIPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SPONSORSHIP_RECEIPT_PRIVILEGES'),
			//SPONSOR_RECEIPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SPONSOR_RECEIPT_PRIVILEGES')
	    },
    init: function(application) {
       this.control({
    	   'sponsorshipreceipt' : {
    		   tabchange: function(view,newTab,oldtab){
    			   var master=this.getSponsorshipreceipt();
    			   var advancesearch = master.down('advancedsearchquerybuilder');
    			   var combo1 = advancesearch.down('#loadSavedSearchComboId');
    			   combo1.setVisible(false);
    		   }
    	   },
    	   'sponsorshipreceiptgrid':{
 				 render : function(grid) {
	                	this.doAccessControlValidation(grid, this.getSPONSORSHIP_RECEIPT_PERMISSIONS());
	                	var store =  grid.getStore();
	                	store.load({
	                		callback: function(record, operation, success) {
	            				if(record[0].data.isMultiCurrency==true){
	            	    			var gridColumns=grid.columns;
	            		 				 var length = gridColumns.length;
	            		 				 if(length!=null && length!=""){
	            		 					 for(var i=0; i<length; i++){
	            		 						 if(gridColumns[i].dataIndex=='alExchangeRate' || gridColumns[i].dataIndex=='acadLocCurrCovertedbalanceAmount'){
	            		 							 gridColumns[i].setVisible(true);
	            		 						 }
	            		 					 }
	            		 				 }	
	            				}
	            			}
	                	});
	                	
	                	
 				 },
 				afterrender: function(grid)
 				 {
 					var me = this;
    				me.addDataGridConfigButton(grid,me.getSPONSORSHIP_RECEIPT_PERMISSIONS());
    				setTimeout(function(){
    					me.addDataGridConfigButton(grid,me.getSPONSORSHIP_RECEIPT_PERMISSIONS());
    				},1500);
 				 }
    	   
 				
 				 
    	   },
    	   
	    	'sponsorshipreceiptsearchform form[itemId=sponsorshipReceipt] button[itemId=sponsorshipReceiptSearchBtn]' : {
				click : this.loadSponsorReceiptSearchGridUsers
			},
			'sponsorshipreceiptsearchform form[itemId=sponsorshipReceipt] button[itemId=resetButtonId]' : {
				 click: function(button, eOpts) {
	                	var form = this.getSponsorshipReceiptForm();
	                	form.getForm().reset();
	                	var academyLocation = form.down('#academyLocationId');
						academyLocation.onTrigger1Click();
						var studentId = form.down('combo[name=STUDENT_ID]');
						studentId.setDisabled(true);
	                	
	                }
			},
    	   'searchresultgrid[itemId=sponsorshipReceiptGrid]':{
			render:this.gridRenderFunction
    	   },
    	   'sponsorshipreceiptscreen grid[itemId=sponsorshipReceiptGrid]': {
    		   afterrender: function(grid){
          			//this.genericCBGridAccessControlValidation(grid, this.getSPONSORSHIP_RECEIPT_PERMISSIONS());
          			//var addButton = grid.down("#searchResultGridBtnAdd");//itemId of split button
          			//addButton.setVisible(false);
          		},
          		cellclick: function(view, cell, cellIndex, record, row, rowIndex, e){
          			var cellDataIndex = view.getGridColumns()[cellIndex].dataIndex;
          			if (cellDataIndex == "settlementDetails") {
          				this.openBillHeaderAdjustmentDetails('billheaderadjustmentdetailsgridwindow', SERVERURL.BILL_HEADER_ADJUSTMENT_DETAILS);
             		}
          		}
    	   },
    	   'sponsorshipreceiptgrid button[itemId=btnView]':{
    		   click:function(button){
    			   var grid = button.up('grid');
    				if(grid.getSelectionModel().getCount()>0){
    			   var contentpanel = this.getContentPanel();
    			   var transactionDetailsFormLayout = Ext.widget('transactiondetails',{
    				   itemId: 'sponsorshipTransactionDetails'
    			   });
   		           var tabName = getCommonTranslation('VIEW_TRANSACTION_DETAILS');
					
 		        	for(var i = 0; i<contentpanel.items.items.length; i++){
						if(contentpanel.items.items[i].title== getCommonTranslation('VIEW_TRANSACTION_DETAILS')){
							contentpanel.items.items[i].close();
						}
						
}
				openTab(contentpanel, tabName, transactionDetailsFormLayout, CONSTANTS.MENU_COLOR_TEN);
				
//    			   var viewRefundedAmountDetailsWindow=Ext.widget('viewrefundedamountdetails');
//    			   viewRefundedAmountDetailsWindow.show();
    				}
    				else {
    					showWarningMessage(getCommonTranslation('SPONSORSHIP_RECEIPT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    				}
    		   }
    	   },
    	   'studentdetailsform[itemId=studentSponsorshipDetailsForm]':{
    		 afterrender: function(){
    			 this.setValueToStudentSponsorshipReceiptForm();
    		 }  
    	   },
    	   'feesandpaymentdetailsgrid[itemId=sponsorshipFeesAndPaymentDetailsGrid]':{
      		 render: function(grid){
      			 this.loadFeePlanSponsorshipReceiptGrid(grid);
      		 }  
      	   },
      	   'transactionsdetailsgrid[itemId=sponsorshipTransactionsDetailsGrid]':{
      		 render: function(grid){
      			 this.loadTransactionSponsorshipReceiptGrid(grid);
      		 }  
      	   },
    	   /*'sponsorshipreceiptscreen button[itemId=searchResultGridBtnAdd]':{
    		   click:function(){
    			   var contentpanel = this.getContentPanel();
    			   var transactionDetailsFormLayout = Ext.widget('transactiondetails');
   		           var tabName = getCommonTranslation('VIEW_TRANSACTION_DETAILS'); 		        
   		           openTab(contentpanel, tabName, transactionDetailsFormLayout, CONSTANTS.MENU_COLOR_THREE);
    		   }
    	   },*/
    	   /***** Export Buttons************/
           'searchresultgrid[itemId=sponsorshipReceiptGrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
   	            click: function() {
   	                this.exportSponsorshipReceipt(SERVERURL.PDFEXPORT,'pdf',false);
   	            }
   	        },
   	        'searchresultgrid[itemId=sponsorshipReceiptGrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
   	            click: function() {
   	                this.exportSponsorshipReceipt(SERVERURL.PDFEXPORT,'pdf',true);
   	            }
   	        },
   	        'searchresultgrid[itemId=sponsorshipReceiptGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
   	            click: function() {
   	                this.exportSponsorshipReceipt(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
   	            }
   	        },
   	        'searchresultgrid[itemId=sponsorshipReceiptGrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
   	            click: function() {
   	                this.exportSponsorshipReceipt(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
   	            }
   	        },
			'sponsorshipreceiptsearchform form[itemId=sponsorshipReceipt]  multiselectcombofield[itemId=academyLocationId]' : {
				change:function(obj,rec){
					var $this = this;
					var form = $this.getSponsorshipReceiptForm().getForm();
					var studentId = form.findField('STUDENT_ID');
					if(rec.length>0){
						 if(rec[0]==""){
								studentId.reset();
								studentId.setDisabled(true);
							}
						 else if(!isNullOrEmpty(rec) && typeof rec[0] !='object') {
							studentId.setDisabled(false);
							var academyLocations=[];
							if(rec.length > 0){
								academyLocations.push(rec);
							}
							studentId.getStore().getProxy().extraParams = {
								academyLocationIds:academyLocations.join()
							};
							studentId.getStore().load();
						}
					}else{
						studentId.reset();
						studentId.setDisabled(true);}
				}
				//select : this.loadLocationComboStore
			},
   	        
       });
    },
    
    
    /**** Export function *******/
    
    exportSponsorshipReceipt : function(exportUrl,filetype,whetherAll) {
    	var quickSearchForm=this.getSponsorshipReceiptForm();	
    	var searchResultGrid = this.getSearchResultGrid();
    	var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
        var reportTitle=getCommonTranslation('SPONSORSHIP_RECEIPT');
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
	createSearchCriteriaString: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },/*
    loadGridAndSearchUsers : function(model, records) {
    	var receiptForm =this.getSponsorshipReceiptForm();	
		var jsonFormatFormData =this.createJsonFormat(receiptForm,records);
		var resultGrid = this.getSearchResultGrid();
		var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.SPONSORSHIP_RECEIPT_BASIC_CONFIGCODE);
		resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH,resultViewUrl, jsonFormatFormData);
    }*/
    loadSponsorReceiptSearchGridUsers: function(model, records) {
    	var $this=this;
    	var form = $this.getSponsorshipReceiptForm();
    	var studentId = form.down("#sponReceipt_studId").getValue();
    	var sponsorId = form.down("#sponMaster_sponId").getValue();
    	var academyLocationId = form.down("#academyLocationId").getValue();
    	var fromDateFormat = form.down("#fromDate").getValue();
    	if(fromDateFormat){
    	var fromDate = Ext.Date.format(new Date(fromDateFormat), 'Y-m-d');
    	}
    	var toDateFormat = form.down("#toDate").getValue();
    	if(toDateFormat){
    	var toDate = Ext.Date.format(new Date(toDateFormat), 'Y-m-d');
    	}
    	var searchJson=[];
    	for(var i in academyLocationId){
    		if(Ext.isObject(academyLocationId[i])){
    			searchJson.push(academyLocationId[i].data.id);
    		}else{
    			searchJson.push(academyLocationId[i]);
    		}
    	}
    	academyLocationIds=searchJson.join();
    	var grid = $this.getSponsorshipreceiptgrid();
    	var store =  grid.getStore();
    	store.getProxy().extraParams = {
    		sponsorId: sponsorId,
    		academyLocationIds: academyLocationIds,
    		studentId: studentId,
    		fromDate:fromDate,
    		toDate:toDate

    	};
    	//$this.resetPageSetting(store);
    	// store.load();
    	store.load({
    		callback: function(record, operation, success) {
				if(record[0].data.isMultiCurrency==true){
					var grid = $this.getSponsorshipreceiptgrid();
	    			var gridColumns=grid.columns;
		 				 var length = gridColumns.length;
		 				 if(length!=null && length!=""){
		 					 for(var i=0; i<length; i++){
		 						 if(gridColumns[i].dataIndex=='alExchangeRate' || gridColumns[i].dataIndex=='acadLocCurrCovertedbalanceAmount'){
		 							 gridColumns[i].setVisible(true);
		 						 }
		 					 }
		 				 }	
				}
			}
    	});
    },
    
  
    createJsonFormat:function(receiptForm) {
    	

    	var this$=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.SPONSORSHIP_RECEIPT_BASIC_CONFIGCODE;

        formValues = receiptForm.getValues(); 
        
       /* var TRANSACTION_DATE_FROM = this.getJsonObject('TRANSACTION_DATE_FROM',formValues.FROM_DATE);
		this.pushJsonObjectInArray(TRANSACTION_DATE_FROM, searchcriteria);
		
		var TRANSACTION_DATE_TO = this.getJsonObject('TRANSACTION_DATE_TO',formValues.TO_DATE);
		this.pushJsonObjectInArray(TRANSACTION_DATE_TO, searchcriteria);*/
        
        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key != 'ACADEMY_ID' && key != 'LOCATION_ID'){
                var keyValueJsonObject = this$.getJsonObject( key , value);
                this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }
        
        var academyArray = formValues.ACADEMY_ID;
        if(!isEmpty(academyArray)){
			var academyIds = '';
			for(var i = 0; i < academyArray.length; i++){
				academyIds +=academyArray[i].data.id+',';
			}
			academyIds = academyIds.substring(0, academyIds.lastIndexOf(","));
			var ACADEMY_ID = this.getJsonObject('ACADEMY_ID',academyIds);
			this.pushJsonObjectInArray(ACADEMY_ID, searchcriteria);
		}
        var locationArray = formValues.LOCATION_ID;
        if(!isEmpty(locationArray)){
			var locationIds = '';
			for(var i = 0; i < locationArray.length; i++){
				locationIds +=locationArray[i].data.id+',';
			}
			locationIds = locationIds.substring(0, locationIds.lastIndexOf(","));
			var LOCATION_ID = this.getJsonObject('LOCATION_ID',locationIds);
			this.pushJsonObjectInArray(LOCATION_ID, searchcriteria);
		}

        values.searchCriterias = searchcriteria;
        return values;
	   	
	}, 
	
	getJsonObject:function(key,value, additionalValue){
		if(value!='' && additionalValue == undefined){
			return {
				"paramCode":key,
				"paramValues":[value]
			};
		} else if (value!= '' && additionalValue != undefined) {
			return {
				"paramCode":key,
				"paramValues":[value, additionalValue]
			};
		}
	},
	
	pushJsonObjectInArray:function(object,array){
		if(object){
			array.push(object);
		}
	},
	
    gridRenderFunction:function(grid){
		grid.addDocked(
				{
			xtype: 'toolbar',
			itemId: 'functionButtonsToolbar',
			dock:'top',
			items:[{
	        xtype: 'button',
	        itemId: 'searchResultGridBtnAdd',
	        tooltip : getCommonTranslation('ADD'),
	        glyph: ICONGLYPH.ADDGLYPH
	    }, {
	        xtype: 'button',
	        itemId: 'searchResultGridBtnView',
	        tooltip : getCommonTranslation('VIEW'),
	        iconCls: 'view-icon'	
	    },'->', {
	        xtype: 'button',
	        itemId: 'exportToPdfBtn',
	        text: getCommonTranslation('PRINT_EXPORT_BTN'),
	        //iconCls: 'export-combo-icon', // Optional icon
	        cls: 'print_export_btn_cls',
	        menu: [{
	            text: 'Export to PDF',
	            //itemId: 'btnExportToPDF',
	            menu: [{
	                text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'),
	                itemId: 'exportCurrentPagePdf'
	            }, {
	                text: getCommonTranslation('EXPORT_ALL_COMMON'),
	                itemId: 'exportPdfAll'
	            }]
	        }, {
	            text: 'Export to Excel',
	            itemId: 'exportToPdfBtn',
	            menu: [{
	                text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'),
	                itemId: 'exportCurrentExcelPage'
	            }, {
	                text: getCommonTranslation('EXPORT_ALL_COMMON'),
	                itemId: 'exportExcelAll'
	            }]
	        }]
	    }/*{
	        xtype: 'splitbutton',
	        itemId: 'exportToPdfBtn',
	        cls: 'CustomToolbarBtnExport export-cls',
	        iconCls:'export-pdf-icon',
	        //text: 'Export To Pdf',      
	        menu: [{
	            text: 'Export Current Page',
	            itemId: 'exportCurrentPagePdf'
	        }, {
	            text: 'Export All',
	            itemId: 'exportPdfAll'
	        } ],
	        listeners: { click: function() { this.showMenu(); } }
	    },{
	        xtype: 'splitbutton',
	        itemId: 'exportToPdfBtn',
	        cls: 'CustomToolbarBtnExport export-cls',
	        iconCls:'export-excel-icon',
	        //text: 'Export To Xcel',      
	        menu: [{
	            text: 'Export Current Page',
	            itemId: 'exportCurrentExcelPage'
	        }, {
	            text: 'Export All',
	            itemId: 'exportExcelAll'
	        } ],
	        listeners: { click: function() { this.showMenu(); } }
	    }*/]});
	},
	/**
	 * Set value to student sponsorship receipt form
	 */
	setValueToStudentSponsorshipReceiptForm: function(){
		var searchResultGrid = this.getSponsorshipreceiptgrid();
	 	
		 if (searchResultGrid.getSelectionModel().getCount() > 0) {
			 var record = searchResultGrid.getSelectionModel().getSelection()[0];
			 var formData = new Object();
			 formData = {
						'studentId': record.get('studentCode'),	
						'programName': record.get('programPrintName'),
						'studentName': record.get('studentPrintName'),
						'sponsorship': record.get('sponsorCode'),
						'sponsorName': record.get('sponsorName'),
						'batch': record.get('batchName'),
						'period': record.get('programPeriodName'),
						'currency': record.get('currencyName')
				 };
			 var studentdetailsform = this.getStudentdetailsform();
			 studentdetailsform.getForm().setValues(formData);
		 }
	},
	
	/**
	 * load fee plan sponsorship receipt
	 * @param feePlanGrid
	 */
	loadFeePlanSponsorshipReceiptGrid: function(feePlanGrid){
		$this = this;
		var searchResultGrid = this.getSponsorshipreceiptgrid();

		if (searchResultGrid.getSelectionModel().getCount() > 0) {
			var record = searchResultGrid.getSelectionModel().getSelection()[0];
			var studentId = record.get('studentId');
			var receiptHeaderId = record.get('receiptId');
			var billHeaderId = record.get('billId');

			var store = feePlanGrid.getStore();


			store.getProxy().extraParams = {
				studentId: studentId,
				receiptHeaderId: receiptHeaderId,
				billHeaderId:billHeaderId

			};

			store.load({
				callback: function(record, operation, success) {
					if (record.length > 0) {
						$this.toggleGridSummaryRow(feePlanGrid,true);
					}else{
						$this.toggleGridSummaryRow(feePlanGrid,false);
					}
				}
			});


			/* store.on('beforeload', function(store, operation) {
	                store.proxy.extraParams = {
	                		studentId: studentId,
		                	receiptHeaderId: receiptHeaderId,
		                	billHeaderId:billHeaderId
	                };
	            });
			 */

		}
	},
	/**
	 * Load transaction sponsorship receipt grid
	 * @param transactionGrid
	 */
	loadTransactionSponsorshipReceiptGrid: function(transactionGrid){
		var $this=this;
		var searchResultGrid = $this.getSponsorshipreceiptgrid();

		if (searchResultGrid.getSelectionModel().getCount() > 0) {
			var record = searchResultGrid.getSelectionModel().getSelection()[0];
			var studentId = record.get('studentId');
			var receiptHeaderId = record.get('receiptId');
			var billHeaderId = record.get('billId');

			var store = transactionGrid.getStore();

			store.getProxy().extraParams = {
				studentId: studentId,
				receiptHeaderId: receiptHeaderId,
				billHeaderId:billHeaderId

			};

			store.load({
				callback: function(record, operation, success) {
					if (record.length > 0) {
						if(record[0].data.isMultiCurrency==true){ 
        	    			var gridColumns=transactionGrid.columns;
        		 				 var length = gridColumns.length;
        		 				 if(length!=null && length!=""){
        		 					 for(var i=0; i<length; i++){
        		 						 if(gridColumns[i].dataIndex=='alExchangeRate' || gridColumns[i].dataIndex=='balanceAmountInALBaseCurrency'){
        		 							 gridColumns[i].setVisible(true);
        		 						 }
        		 					 }
        		 				 }	
        				}
						$this.toggleGridSummaryRow(transactionGrid,true);
					}else{
						$this.toggleGridSummaryRow(transactionGrid,false);
					}
				}
			});

			/*    store.on('beforeload', function(store, operation) {
	                store.proxy.extraParams = {
	                		studentId: studentId,
		                	receiptHeaderId: receiptHeaderId,
		                	billHeaderId:billHeaderId
	                };
	            });*/
		}
	},
	/**
	 * Open bill header adjustment details
	 * @param windowXType
	 * @param url
	 */
	openBillHeaderAdjustmentDetails: function(windowXType, url){
		var searchResultGrid = this.getSponsorshipreceiptgrid();
		var record = searchResultGrid.getSelectionModel().getSelection()[0];
		if(!isEmpty(record)){
			var formWindow = Ext.widget(windowXType);
			formWindow.show();
			var params = {
					receiptHeaderId : record.get('receiptId'),
					billHeaderId : record.get('billId')
			};
			//formWindow.down('#sponsorName').setValue(record.get('sponsorName'));
			//formWindow.down('#sponsorCode').setValue(record.get('sponsorCode'));
			var billHeaderGrid = formWindow.down('#billHeaderGrid');
			var store = billHeaderGrid.getStore();
			store.getProxy().api.read = url;
			store.load({
				params:params
			});

		}

	}


});
