/**
 * @author Amit G
 */
Ext.define('Academia.controller.student.studentDeletedReport.StudentDeletedReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	         'Academia.store.program.programbatchdetail.BatchStore','admission.applicationFormSale.ProgramGroupComboStore',
	         'coursetransaction.studentenrollment.studentenrollmentdetail.StudentIdByAdmissionCodeBySmartSearch','common.CurrentBatchStore','common.AssignedProgramStore',
	         'common.IntakeYearStore','common.AcademicTermStore','student.report.StudentDeletedReportStore','student.report.InactiveAdmissionStudentIdStore','student.report.ProgramGroupWithAcademicTermStore'
	         ,'student.report.ProgramWithAcademicTermStore','student.report.DeletedStudentNameStore','student.report.DeletedStudentFiltersCommonStore'],
	         views: ['student.studentDeletedReport.StudentDeletedReportTabStructure',
	                 'student.studentDeletedReport.StudentDeletedReportStructure','student.studentDeletedReport.StudentDeletedReportGrid',
	                 'student.studentDeletedReport.StudentDeletedReportFilter'],
	                 config : {
	                	 STUDENT_DELETED_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_DELETED_REPORT_PRIVILEGES')
	                 },
	                 refs: [{
	                	 ref: 'studentdeletedreportfilter',
	                	 selector: 'studentdeletedreportfilter'
	                 },{
	                	 ref: 'studentdeletedreportgrid',
	                	 selector: 'studentdeletedreportgrid'
	                 }],
	            	
	                 init: function(application) {
	                	 this.control({
	                		 
	                		 'studentdeletedreporttabstructure':{
	                			 render:function(studentdeletedreporttabstructure){
	                				 this.enableTabforstudentdeletedPanel(studentdeletedreporttabstructure);
	                			 }
	                		 },
	                		 
	                		'studentdeletedreportfilter combo#programId': {
	                			 select: function(obj, record){
	                				 this.deletedReportProgSelect(obj, record)
	                			 },
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId,
	                					 dropDownType:'program'
	                				 };
	                				 store.load();
	                				 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				 var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				 if(wheatherSchool){
	                					 var form = obj.up('form');
	            	                	 var period = form.down('#periodId');
	            	                	 period.setVisible(false);
	            	                	 var academicTerm = form.down('#academicTerm');
	            	                	 academicTerm.setVisible(false);
	                				 }
	                			 }
	                		 },
	                		 'studentdeletedreportfilter combo#studentId': {
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId
	                				 };
	                				 store.load();
	                			 }
	                		 },
	                		 'studentdeletedreportfilter combo#batchId':{
	                			 select: function(obj, record){
	                				 this.deletedReportBatchSelect(obj, record)
	                			 }
	                		 },
	                		 'studentdeletedreportfilter button[itemId=searchBtn]' : {
	                			 click : function(form) {
	                				 var grid = this.getStudentdeletedreportgrid();
	                				 var store = grid.getStore();
	                				 var form =  this.getStudentdeletedreportfilter();
	                				 form.down('#searchBtn').setDisabled(true);
	                				 var values = form.getForm().getValues();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 deleteStudentId  : values.studentId,
	                					 programGroupId : values.programGroupCombo,
	                					 intakeYearId : values.intakeYear,
	                					 academicTermId : values.academicTerm,
	                					 programId : values.PROGRAM_NAME,
	                					 batchId : values.BATCH_NAME,
	                					 periodId : values.PERIOD_NAME,
	                					 studentStatus:values.studentStatus,
	                					 academyLocationId:academyLocationId
	                				 }
	                				 this.resetPageSetting(store);
	                				 store.load({
	  								   callback: function(records, operation, success) {
	  									 form.down('#searchBtn').setDisabled(false);   
	  								   }
								    });
	                				 grid.config.searchFilterForm = this.getStudentdeletedreportfilter();
	                			 }
	                		 },
	                		 'studentdeletedreportfilter button[itemId=resetBtn]' : {
	                			 click : function(obj) {
	                				 var form = obj.up('form');
	                				 form.getForm().reset();
	                				 var batch = form.down('#batchId');
	                				 var period = form.down('#periodId');
            	                	 var programGroupCombo = form.down('#programGroupCombo');
	                				 programGroupCombo.setReadOnly(false);
            	                	 
	                				 batch.setDisabled(true);
	                				 period.setDisabled(true);
	                				 
	                				 var program = form.down('#programId');
	                				 var programStore = program.getStore();
	                				 var programGroupComboStore = programGroupCombo.getStore();
	                				 
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 programStore.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId,
	                					 programGroupId: "",
	                					 dropDownType:'program'
	                				 };
	                				 
	                				 programGroupComboStore.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId,
	                					 academicTermId: "",
	                					 dropDownType:'program_group'
	                				 };
	                				 
	                				 programStore.load();
	                				 programGroupComboStore.load();
	                			 }
	                		  },
	                		  'studentdeletedreportgrid ': {
	                  			   render: function(grid){
	                  				 var alinfomodel = Academia.model.authentication.ALInfoModel;
	        	                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
	        	                	 if(wheatherSchool){
	        	                		 var records = grid.getSelectionModel().getSelection();
		       							  for(var i=0;i<grid.columns.length;i++){
		       								  if(grid.columns[i].dataIndex == 'period'){
		       									  grid.columns[i].hide();
		       									  grid.columns[i].hidden = true;
		       								  }
		       							  }
	        	                	 }
	                  				 this.doAccessControlValidation(grid, this.getSTUDENT_DELETED_REPORT_PERMISSIONS());
	                  			   }
	                		  },
	                		  'studentdeletedreportfilter combo#programGroupCombo': {
	                			  select: function(obj, record){
	                				  this.deletedReportProgGropSelect(obj, record)
	                			  },
	                			  render : function(obj) {
		                				 var store = obj.getStore();
		                				 var academyLocationId=this.getCurrentAcademyLocation();
		                				 store.getProxy().extraParams = {
		                					 academyLocationId: academyLocationId,
		                					 dropDownType:'program_group'
		                				 };
		                				 store.load();
		                			 }
	                		  },
	                		  'studentdeletedreportfilter combo#academicTerm': {
	                			  select: function(obj, record){
	                				  this.deletedReportAcademicTermSelect(obj, record)
	                			  },
	                			  render : function(obj) {
		                				 var store = obj.getStore();
		                				 var academyLocationId=this.getCurrentAcademyLocation();
		                				 store.getProxy().extraParams = {
		                					 academyLocationId: academyLocationId,
		                					 dropDownType:'academic_term'
		                				 };
		                				 store.load();
		                			 }
	                		  },
	                		  'studentdeletedreportfilter combo#intakeYear': {
	                			  select: function(obj, record){
	                				  this.deletedReportIntakeYearSelect(obj, record)
	                			  },
	                			  render : function(obj) {
		                				 var store = obj.getStore();
		                				 var academyLocationId=this.getCurrentAcademyLocation();
		                				 store.getProxy().extraParams = {
		                					 academyLocationId: academyLocationId,
		                					 dropDownType:'intake_year'
		                				 };
		                				 store.load();
		                			 }
	                		  }
	                	 });
	                 },
	                 
	                 
	                 enableTabforstudentdeletedPanel:function(studentdeletedreporttabstructure)
	                 {
	                	 this.showTabforStudentdeletedPanel(studentdeletedreporttabstructure);
	                 },
	                 
	                 showTabforStudentdeletedPanel : function(studentdeletedreporttabstructure) {
					  	   var panelItem = new Array();
					  	   var $this = this;
					  	   var newcont=studentdeletedreporttabstructure.items.items.length;
					  	   var insertPosition=newcont+1;
					  		   panelItem.push({
					  			   xtype:'tabpanel',
					  			   itemId:'allVisibleTP',
					  			   plain: true,
					  			   style:{overflow:'hidden !important',margin:'0!important'},
					  			   
					  			   frame: false,
					  			   border:false,
					  			   defaults: {
					  				   labelAlign: 'top'
					  			   },
					  			   items:[{
					  					xtype : 'studentdeletedreportstructure',
					  					itemId : 'studentdeletedreportstructure',
					  					title : getCommonTranslation('SEARCH'),
					  					tabCls : 'right-tab'
					  				}]
					  		   });

					  		 studentdeletedreporttabstructure.insert(insertPosition,panelItem);
					     },
	                 
	                 
	                 deletedReportProgGropSelect : function(obj, record) {
	                	 var programgroupId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var formValues = form.getValues();
	                	 var academyLocationId=this.getCurrentAcademyLocation();
	                	 var program = form.down('#programId');
	                	 var batch = form.down('#batchId');
	                	 var academicTermId = form.down('#academicTerm');
	                	 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
	                	 var academyLocationId = this.getCurrentAcademyLocation();
	                	 if(!wheatherSchool){
	                		 var period = form.down('#periodId');
	                		 period.reset();
	                		 period.setDisabled(true);
	                	 }
	                	 program.reset();
	                	 batch.reset();
	                	 batch.setDisabled(true);
	                	 if(programgroupId > 0){
	                		 var store = program.getStore();
	                		 store.getProxy().extraParams = {
	                			 programGroupId: programgroupId,
	                			 academyLocationId: academyLocationId,
	                			 dropDownType:'program'
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 deletedReportProgSelect : function(obj, record) {
	                	 var programId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var batch = form.down('#batchId');
	                	 batch.reset();
	                	 batch.setDisabled(false);
	                	 var academyLocationId=this.getCurrentAcademyLocation();
	                	 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
        				 if(!wheatherSchool){
        					 var period = form.down('#periodId');
        					 period.reset();
        					 period.setDisabled(true); 
        				 }
	                	 if(programId > 0){
	                		 var store = batch.getStore();
	                		 store.getProxy().extraParams = {
	                			 programId:programId,
	                			 dropDownType:'batch',
	                			 academyLocationId:academyLocationId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 deletedReportBatchSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var period = form.down('#periodId');
	                	 period.reset();
	                	 period.setDisabled(false);
	                	 var academyLocationId=this.getCurrentAcademyLocation();
	                	 var batchId = record[0].get("id");
	                	 if(batchId > 0){	    	        					  
	                		 var store = period.getStore();
	                		 store.getProxy().extraParams = {
	                			 batchId     : batchId,
	                			 dropDownType:'period',
	                			 academyLocationId:academyLocationId
	                		 };
	                		 //store.load();
	                		 store.load({
								   callback: function(records, operation, success) {
									   if (success) {
										   if(records.length > 0){
											   if(wheatherSchool){
												   period.setValue(records[0].data.id);
											   }
										   }
									   }
								   }
							    });
	                	 }
	                 },
	                 deletedReportAcademicTermSelect : function(obj, record) {
	                	 var academicTermId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var programGroupCombo = form.down('#programGroupCombo');
	                	 var programCombo = form.down('#programId');
	                	 var academyLocationId=this.getCurrentAcademyLocation();
	                	 if(academicTermId > 0){
	                		 var programGroupComboStore = programGroupCombo.getStore();
	                		 programGroupComboStore.getProxy().extraParams = {
	                			 academicTermId: academicTermId,
	                			 dropDownType:'program_group',
	                			 academyLocationId:academyLocationId
	                		 };
	                		 programGroupComboStore.load();
	                		 
	                		/* var programComboStore = programCombo.getStore();
	                		 programComboStore.getProxy().extraParams = {
	                			 academicTermId: ""
	                		 };
	                		 programComboStore.load();*/
	                	 }
	                 },
	                 deletedReportIntakeYearSelect : function(obj, record) {
	                	 var intakeYearId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var academicTermCombo = form.down('#academicTerm');
	                	 var academyLocationId=this.getCurrentAcademyLocation();
	                	 if(intakeYearId > 0){
	                		 var academicTermComboStore = academicTermCombo.getStore();
	                		 academicTermComboStore.getProxy().extraParams = {
	                			 academyLocationId: academyLocationId,
	                			 intakeYearId:intakeYearId,
	                			 dropDownType:'academic_term'
	                		 };
	                		 academicTermComboStore.load();
	                	 }
	                 }
	                 
});
