/**
 * @author Amit G
 */
Ext.define('Academia.controller.student.studentLeaversReport.StudentLeaversReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	         'Academia.store.program.programbatchdetail.BatchStore','admission.applicationFormSale.ProgramGroupComboStore',
	         'coursetransaction.studentenrollment.studentenrollmentdetail.StudentIdByAdmissionCodeBySmartSearch','common.CurrentBatchStore','common.AssignedProgramStore',
	         'common.IntakeYearStore','common.AcademicTermStore','student.report.StudentLeaversReportStore','student.report.InactiveAdmissionStudentIdStore','student.report.ProgramGroupWithAcademicTermStore'
	         ,'student.report.ProgramWithAcademicTermStore','common.AcademyLocationNameSeparated','personinfo.common.personalinfo.MappedProgramGroupByALStore'],
	         views: ['student.studentLeaversReport.StudentLeaversReportTabStructure',
	                 'student.studentLeaversReport.StudentLeaversReportStructure','student.studentLeaversReport.StudentLeaversReportGrid',
	                 'student.studentLeaversReport.StudentLeaversReportFilter'],
	                 config : {
	                	 STUDENT_LEAVERS_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_LEAVERS_REPORT_PRIVILEGES')
	                 },
	                 refs: [{
	                	 ref: 'studentleaversreportfilter',
	                	 selector: 'studentleaversreportfilter'
	                 },{
	                	 ref: 'studentleaversreportgrid',
	                	 selector: 'studentleaversreportgrid'
	                 }],
	            	
	                 init: function(application) {
	                	 this.control({
	                		 
	                		 'studentleaversreporttabstructure':{
	                			 render:function(studentleaversreporttabstructure){
	                				 this.enableTabforstudentleaversPanel(studentleaversreporttabstructure);
	                			 }/*,
	                			 afterrender:function(structure)
	                			 {
	                				 var grid=structure.down('studentleaversreportgrid');
	                				 this.getGridHeaderFreeze(grid,structure,true);
	                			 }*/
	                		 },
	                		 
	                		 'studentleaversreportfilter combo#academyLocationId': {
	                			 change: function(obj, record){
	                				 this.leaversReportAcdmLocSelect(obj, record)
	                			 },
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.load({
	                					 callback: function(records, operation, success) {
	                						   for(var i in records){
	                							   if(records[i].data.id==academyLocationId){
	                								   obj.setValue(records[i].data.id);
	                							   }
	                						   }
	                					   }	
	                				 });
	                			 }
	                		 },
	                		'studentleaversreportfilter combo#programId': {
	                			 select: function(obj, record){
	                				 this.leaversReportProgSelect(obj, record)
	                			 },
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId,
	                					 isAllProgram:true,
	                					 isStudentLeaversReportScreen:true
	                				 };
	                				 store.load();
	                				 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				 var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				 if(wheatherSchool){
	                					 var form = obj.up('form');
	            	                	 var period = form.down('#periodId');
	            	                	 period.setVisible(false);
	            	                	 var academicTerm = form.down('#academicTerm');
	            	                	 academicTerm.setVisible(false);
	                				 }
	                			 }
	                		 },
	                		 'studentleaversreportfilter combo#studentId': {
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId
	                				 };
	                				 store.load();
	                			 },
	                			 select: function(combo, newValue, oldValue, eOpts) {/*
	                				 $this = this;
	         				        var studentLeaversReport = $this.getStudentleaversreportfilter();
	        				            var studentId = combo.getValue();
	        				            Ext.Ajax.request({
	        				                method: "GET",
	        				                type: 'rest',
	        				                url: SERVERURL.PATH_FIND_PROGRAM_BATCH_SECTION_PERIOD_BY_STUDENT_ID,
	        				                headers: {
	        				                    'Content-Type': 'application/json'
	        				                },
	        				                params: {
	        				                    studentId: studentId
	        				                },
	        				                success: function(response, action) {
	        				                    var data = Ext.decode(response.responseText);
	        				                    var programGroupCombo = studentLeaversReport.down('#programGroupCombo');
	        				                    
	        				                    //var programCombo = studentIncidentsReport.down('#programId');
	        				                    //programCombo.setReadOnly(true);
	        				                    var academyLocationId=$this.getCurrentAcademyLocation();
	        				                    var programGroupComboStore = programGroupCombo.getStore();
	        				                    programGroupComboStore.load({
	        				                    	callback: function(records, operation, success) {
	        				                    		if (!isNullOrEmpty(data[0].programGroupId)) {
	        				                    			programGroupCombo.setValue(data[0].programGroupId);
	        				                    			programGroupCombo.setReadOnly(true);
	        				                    			var programCombo = studentLeaversReport.down('#programId');
	        				                    			// batchCombo.setReadOnly(true);
	        				                    			programCombo.setDisabled(false);
	        				                    			// batchCombo.allowBlank = false;
	        				                    			var programComboStore = programCombo.getStore();
	        				                    			programComboStore.getProxy().extraParams = {
	        				                    				studentId:studentId,
	        				                    				programGroupId:data[0].programGroupId
	        				                    			};

	        				                    			programComboStore.load({
	        				                    				callback: function(records, operation, success) {
	        				                    					if (!isNullOrEmpty(data[0].programId)) {

	        				                    						programCombo.setValue(data[0].programId);
	        				                    						var batchCombo = studentLeaversReport.down('#batchId');
	        				                    						// batchCombo.setReadOnly(true);
	        				                    						batchCombo.setDisabled(false);
	        				                    						// batchCombo.allowBlank = false;
	        				                    						var batchComboStore = batchCombo.getStore();
	        				                    						batchComboStore.getProxy().extraParams = {
	        				                    							studentId:studentId
	        				                    						};

	        				                    						batchComboStore.load({
	        				                    							callback: function(records, operation, success) {
	        				                    								if (!isNullOrEmpty(data[0].batchId)) {
	        				                    									batchCombo.setValue(data[0].batchId);
	        				                    									var periodCombo = studentLeaversReport.down('#periodId');
	        				                    									//periodCombo.setReadOnly(true);
	        				                    									periodCombo.setDisabled(false);
	        				                    									var periodComboStore = periodCombo.getStore();
	        				                    									periodComboStore.getProxy().extraParams = {
	        				                    										studentId:studentId
	        				                    									};
	        				                    								}
	        				                    							}
	        				                    						});
	        				                    					}
	        				                    				}
	        				                    			}); 
	        				                    		}
	        				                    	}
	        				                    });
	        				                }
	        				            });
	        				       // }
	        				    */}
	                		 },
	                		 'studentleaversreportfilter combo#batchId':{
	                			 select: function(obj, record){
	                				 this.leaversReportBatchSelect(obj, record)
	                			 }
	                		 },
	                		 'studentleaversreportfilter button[itemId=searchBtn]' : {
	                			 click : function(form) {
	                				 var grid =this.getStudentleaversreportgrid();
	                				 var store = grid.getStore();
	                				 var form = this.getStudentleaversreportfilter();
	                				 form.down('#searchBtn').setDisabled(true);
	                				 var values = form.getForm().getValues();
	                				 var academyLocationData=[];
	                		         if(values.academyLocation !="" && values.academyLocation !=null){
	                		        	 for(var i in values.academyLocation){
	                		    		 	if(Ext.isObject(values.academyLocation[i])&& !isNullOrEmpty(values.academyLocation[i])){
	                		    		 		al = values.academyLocation[i].data.id;
	                		    		 		academyLocationData.push(al);
	                		    		 	}else{
	                		    		 		if(!isNullOrEmpty(values.academyLocation[i])){
	                		    		 		al = values.academyLocation[i].data.id;
	                		    		 		academyLocationData.push(al);
	                		    		 		}
	                		    	  		}
	                		    	 	}
	                		    	 }	
	                		         if(academyLocationData.join().length==0 && !isNullOrEmpty(values.academyLocation)){
		                		    	 	academyLocationData.push(values.academyLocation);
		                		     }
	                				 store.getProxy().extraParams = {
	                					 studentId : values.studentId,
	                					 programGroupId : values.programGroupCombo,
	                					 intakeYear : values.intakeYear,
	                					 term : values.academicTerm,
	                					 programId : values.PROGRAM_NAME,
	                					 batchId : values.BATCH_NAME,
	                					 periodId : values.PERIOD_NAME,
	                					 studentStatus:values.studentStatus,
	                					 academyLocationIds : academyLocationData.join(),
	                					 fromDate : values.FROM_DATE,
	                					 toDate : values.TO_DATE
	                				 }
	                				 this.resetPageSetting(store);
	                				 store.load({
	                					 callback: function(records, operation, success) {
	                						 form.down('#searchBtn').setDisabled(false);
	                					   }	
	                				 });
	                				 grid.config.searchFilterForm = this.getStudentleaversreportfilter();
	                			 }
	                		 },
	                		 'studentleaversreportfilter button[itemId=resetBtn]' : {
	                			 click : function(obj) {
	                				 var form = obj.up('form');
	                				 var getForm = form.getForm();
	                				 var batch = getForm.findField('BATCH_NAME');
	                				 var period = getForm.findField('PERIOD_NAME');
            	                	 var programGroupCombo = getForm.findField('programGroupCombo');
            	                	 var academyLocationIds = getForm.findField('academyLocation');
            	                	 var intakeYear = getForm.findField('intakeYear');
            	                	 var studentId =  getForm.findField('studentId');
            	                	 var fromDate = getForm.findField('FROM_DATE');;
            	                	 var toDate = getForm.findField('TO_DATE');
            	                	 var academicTerm = getForm.findField('academicTerm');
            	                	 var studentStatus = getForm.findField('studentStatus');
            	                	 var program =getForm.findField('PROGRAM_NAME');
	                				
            	                	 program.reset();
            	                	 batch.reset();
            	                	 period.reset();
            	                	 programGroupCombo.reset();
            	                	 academyLocationIds.reset();
            	                	 studentId.reset();
            	                	 fromDate.reset();
            	                	 toDate.reset();
            	                	 intakeYear.reset();
            	                	 academicTerm.reset();
            	                	 studentStatus.reset();
            	                	 
	                				 programGroupCombo.setReadOnly(false);
	                				 studentId.clearValue();
            	                	 
	                				 batch.setDisabled(true);
	                				 period.setDisabled(true);
	                				 
	                				 fromDate.setMinValue(null);
	                				 toDate.setMinValue(null);
	                				 fromDate.setMaxValue(new Date());
	                				 toDate.setMaxValue(new Date());
	                				 
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 var academyLocationIdStore = academyLocationIds.getStore();
	                				 
	                				 academyLocationIdStore.load({
	                					 callback: function(records, operation, success) {
	                						   for(var i in records){
	                							   if(records[i].data.id==academyLocationId){
	                								   academyLocationIds.setValue(records[i].data.id);
	                							   }
	                						   }
	                					   }	
	                				 });
	                				 
	                				 var studentStore = studentId.getStore();
	                				 studentStore.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId
	                				 };
	                				 studentStore.load();
	                				 
	                				 var programStore = program.getStore();
	                				 var programGroupComboStore = programGroupCombo.getStore();
	                				 
	                				 programStore.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId,
	                					 programGroupId: "",
	                					 isStudentLeaversReportScreen:true
	                				 };
	                				 
	                				 programGroupComboStore.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId
	                				 };
	                				 
	                				 programStore.load();
	                				 programGroupComboStore.load();
	                			 }
	                		  },
	                		  'studentleaversreportgrid ': {
	                  			   render: function(grid){
	                  				 var alinfomodel = Academia.model.authentication.ALInfoModel;
	        	                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
	        	                	 if(wheatherSchool){
	        	                		 var records = grid.getSelectionModel().getSelection();
		       							  for(var i=0;i<grid.columns.length;i++){
		       								  if(grid.columns[i].dataIndex == 'periodName'){
		       									  grid.columns[i].hide();
		       									  grid.columns[i].hidden = true;
		       								  }
		       							  }
	        	                	 }
	                  				 this.doAccessControlValidation(grid, this.getSTUDENT_LEAVERS_REPORT_PERMISSIONS());
	                  			   },
	                		       afterrender:function(grid){
	          	   				     var me = this;
	          	   				     setTimeout(function(){
	          	   					      me.addDataGridConfigButton(grid, me.getSTUDENT_LEAVERS_REPORT_PERMISSIONS());
	          	   				     },1500);
	          			           }
	                		  },
	                		  'studentleaversreportfilter combo#programGroupCombo': {
	                			  select: function(obj, record){
	                				  this.leaversReportProgGropSelect(obj, record)
	                			  },
	                			  render : function(obj) {
		                				 var store = obj.getStore();
		                				 var academyLocationId=this.getCurrentAcademyLocation();
		                				 store.getProxy().extraParams = {
		                					 academyLocationIds: academyLocationId
		                				 };
		                				 store.load();
		                			 }
	                		  },
	                		  'studentleaversreportfilter combo#academicTerm': {
	                			  select: function(obj, record){
	                				  this.leaversReportAcademicTermSelect(obj, record)
	                			  }
	                		  }
	                	 });
	                 },
	                 
	                 
	                 enableTabforstudentleaversPanel:function(studentleaversreporttabstructure)
	                 {
	                	 this.showTabforStudentLeaversPanel(studentleaversreporttabstructure);
	                 },
	                 
	                 showTabforStudentLeaversPanel : function(studentleaversreporttabstructure) {
					  	   var panelItem = new Array();
					  	   var $this = this;
					  	   var newcont=studentleaversreporttabstructure.items.items.length;
					  	   var insertPosition=newcont+1;
					  		   panelItem.push({
					  			   xtype:'tabpanel',
					  			   itemId:'allVisibleTP',
					  			   plain: true,
					  			   style:{overflow:'hidden !important',margin:'0!important'},
					  			   
					  			   frame: false,
					  			   border:false,
					  			   defaults: {
					  				   labelAlign: 'top'
					  			   },
					  			   items:[{
					  					xtype : 'studentleaversreportstructure',
					  					itemId : 'studentleaversreportstructure',
					  					title : getCommonTranslation('SEARCH'),
					  					tabCls : 'right-tab'
					  				}]
					  		   });

					  		 studentleaversreporttabstructure.insert(insertPosition,panelItem);
					     },
	                 
					 leaversReportAcdmLocSelect : function(obj, record) {
	                	 var form = obj.up('form');
	                	 var formValues = form.getValues();
	                	 var programGroupCombo = form.down('#programGroupCombo');
	                	 var program = form.down('#programId');
	                	 var batch = form.down('#batchId');
	                	 var studentId = form.down('#studentId');
	                	 var studentStore = studentId.getStore();
	                	 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
	                	 var academyLocationId = this.getCurrentAcademyLocation();
	                	 
	                	 var academyLocationData=[];
        		         if(formValues.academyLocation !="" && formValues.academyLocation !=null){
        		        	 for(var i in formValues.academyLocation){
        		    		 	if(Ext.isObject(formValues.academyLocation[i])&& !isNullOrEmpty(formValues.academyLocation[i])){
        		    		 		al = formValues.academyLocation[i];
        		    		 		academyLocationData.push(al);
        		    		 	}else{
        		    		 		if(!isNullOrEmpty(formValues.academyLocation[i])){
        		    		 		al = formValues.academyLocation[i];
        		    		 		academyLocationData.push(al);
        		    		 		}
        		    	  		}
        		    	 	}
        		    	 }	
        		         
	                	 if(!wheatherSchool){
	                		 var period = form.down('#periodId');
	                		 period.reset();
	                		 period.setDisabled(true);
	                	 }
	                	 programGroupCombo.reset();
	                	 program.reset();
	                	 batch.reset();
	                	 batch.setDisabled(true);
	                	 if(!isNullOrEmpty(academyLocationData.join()) && academyLocationData.join()!=""){
	                		 studentStore.getProxy().extraParams = {
            					 academyLocationIds: academyLocationData.join()
            				 };
	                		 studentStore.load();
	                		 var store = program.getStore();
	                		 var programGroupComboStore = programGroupCombo.getStore();
		                	 programGroupComboStore.getProxy().extraParams = {
		                		 academicTermId: formValues.academicTerm,
	                			 academyLocationIds: academyLocationData.join()
		                	 };
		                	 programGroupComboStore.load();
	                		 store.getProxy().extraParams = {
	                			 academyLocationIds: academyLocationData.join(),
	                			 isStudentLeaversReportScreen:true
	                		 };
	                		 store.load();
	                	 }
	                	 else{
	                		 studentStore.getProxy().extraParams = {
	                			 academyLocationId: academyLocationId
            				 };
	                		 studentStore.load();
	                		 var store = program.getStore();
	                		 var programGroupComboStore = programGroupCombo.getStore();
		                	 programGroupComboStore.getProxy().extraParams = {
		                		 academicTermId: formValues.academicTerm,
	                			 academyLocationIds: academyLocationId
		                	 };
		                	 programGroupComboStore.load();
	                		 store.getProxy().extraParams = {
	                			 academyLocationId: academyLocationId,
	                			 isStudentLeaversReportScreen:true
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 leaversReportProgGropSelect : function(obj, record) {
	                	 var programgroupId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var formValues = form.getValues();
	                	 var academyLocationId=this.getCurrentAcademyLocation();
	                	 var program = form.down('#programId');
	                	 var batch = form.down('#batchId');
	                	 var academicTermId = form.down('#academicTerm');
	                	 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
	                	 
	                	 var academyLocationData=[];
        		         if(formValues.academyLocation !="" && formValues.academyLocation !=null){
        		        	 for(var i in formValues.academyLocation){
        		    		 	if(Ext.isObject(formValues.academyLocation[i])&& !isNullOrEmpty(formValues.academyLocation[i])){
        		    		 		al = formValues.academyLocation[i].data.id;
        		    		 		academyLocationData.push(al);
        		    		 	}else{
        		    		 		if(!isNullOrEmpty(formValues.academyLocation[i])){
        		    		 		al = formValues.academyLocation[i].data.id;
        		    		 		academyLocationData.push(al);
        		    		 		}
        		    	  		}
        		    	 	}
        		    	 }	
		                			 
	                	 if(!wheatherSchool){
	                		 var period = form.down('#periodId');
	                		 period.reset();
	                		 period.setDisabled(true);
	                	 }
	                	 program.reset();
	                	 batch.reset();
	                	 batch.setDisabled(true);
	                	 if(programgroupId > 0){
	                		 var store = program.getStore();
	                		 if(!isNullOrEmpty(academyLocationData.join()) && academyLocationData.join()!=""){
	                			 store.getProxy().extraParams = {
		                			 programGroupId: programgroupId,
		                			 academyLocationIds: academyLocationData.join(),
		                			 isStudentLeaversReportScreen:true
		                		 };
	                			 store.load();
	                		 }else{
	                		 store.getProxy().extraParams = {
	                			 programGroupId: programgroupId,
	                			 academyLocationId: academyLocationId,
	                			 isStudentLeaversReportScreen:true
	                		 };
	                		 store.load();
	                		 }
	                	 }
	                 },
	                 leaversReportProgSelect : function(obj, record) {
	                	 var programId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var batch = form.down('#batchId');
	                	 batch.reset();
	                	 batch.setDisabled(false);
	                	 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
        				 if(!wheatherSchool){
        					 var period = form.down('#periodId');
        					 period.reset();
        					 period.setDisabled(true); 
        				 }
	                	 if(programId > 0){
	                		 var store = batch.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: programId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 leaversReportBatchSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var period = form.down('#periodId');
	                	 period.reset();
	                	 period.setDisabled(false);
	                	 var batchId = record[0].get("id");
	                	 if(batchId > 0){	    	        					  
	                		 var store = period.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: batchId
	                		 };
	                		 //store.load();
	                		 store.load({
								   callback: function(records, operation, success) {
									   if (success) {
										   if(records.length > 0){
											   if(wheatherSchool){
												   period.setValue(records[0].data.id);
											   }
										   }
									   }
								   }
							    });
	                	 }
	                 },
	                 leaversReportAcademicTermSelect : function(obj, record) {
	                	 var academicTermId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var programGroupCombo = form.down('#programGroupCombo');
	                	 var programCombo = form.down('#programId');
	                	 var academyLocationId=this.getCurrentAcademyLocation();
	                	 var values = this.getStudentleaversreportfilter().getForm().getValues();
	                	 var academyLocationData=[];
        		         if(values.academyLocation !="" && values.academyLocation !=null){
        		        	 for(var i in values.academyLocation){
        		    		 	if(Ext.isObject(values.academyLocation[i])&& !isNullOrEmpty(values.academyLocation[i])){
        		    		 		al = values.academyLocation[i].data.id;
        		    		 		academyLocationData.push(al);
        		    		 	}else{
        		    		 		if(!isNullOrEmpty(values.academyLocation[i])){
        		    		 		al = values.academyLocation[i].data.id;
        		    		 		academyLocationData.push(al);
        		    		 		}
        		    	  		}
        		    	 	}
        		    	 }	
            		         if(!isNullOrEmpty(academyLocationData.join()) && academyLocationData.join()!=""){
	                		 if(academicTermId > 0){
		                		 var programGroupComboStore = programGroupCombo.getStore();
		                		 programGroupComboStore.getProxy().extraParams = {
		                			 academicTermId: academicTermId,
	                				 academyLocationIds: academyLocationData.join()
		                		 };
		                		 programGroupComboStore.load();
		                		 
		                		 var programComboStore = programCombo.getStore();
		                		 programComboStore.getProxy().extraParams = {
		                			 academicTermId: "",
		                			 academyLocationIds: academyLocationData.join(),
		                			 isStudentLeaversReportScreen:true
		                		 };
		                		 programComboStore.load();
		                	 }
	                	 }
	                	 else {
	                	 if(academicTermId > 0){
	                		 var programGroupComboStore = programGroupCombo.getStore();
	                		 programGroupComboStore.getProxy().extraParams = {
	                			 academicTermId: academicTermId,
                				 academyLocationIds: academyLocationId
	                		 };
	                		 programGroupComboStore.load();
	                		 
	                		 var programComboStore = programCombo.getStore();
	                		 programComboStore.getProxy().extraParams = {
	                			 academicTermId: "",
	                			 academyLocationId: academyLocationId,
	                			 isStudentLeaversReportScreen:true
	                		 };
	                		 programComboStore.load();
	                	 }
	                	 }
	                 }
	                 
});
