/**
 * @author Amit G
 */
Ext.define('Academia.controller.student.studentServiceOptInReport.StudentServiceOptInReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['student.report.serviceOptInReport.ServiceOptInReportServiceNameStore','student.report.serviceOptInReport.ServiceOptInReportSeatTypeStore','feeandpayment.finance.FinanceBlokedStudFilterStudentByALStore',
	         'student.report.serviceOptInReport.ServiceOptInReportProgramStore','student.report.serviceOptInReport.ServiceOptInReportBatchStore',
	         'student.report.serviceOptInReport.StudentServiceOptInReportGridStore'],
	         views: ['student.studentServiceOptInReport.StudentServiceOptInReportTabStructure',
	                 'student.studentServiceOptInReport.StudentServiceOptInReportStructure','student.studentServiceOptInReport.StudentServiceOptInReportGrid',
	                 'student.studentServiceOptInReport.StudentServiceOptInReportFilter'],
	                 config : {
	                	 STUDENT_SERVICE_OPTIN_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_SERVICE_OPT_IN_REPORTS_PRIVILEGES')
	                 },
	                 refs: [{
	                	 ref: 'studentserviceoptinreportfilter',
	                	 selector: 'studentserviceoptinreportfilter'
	                 },{
	                	 ref: 'StudentServiceOptInReportGrid',
	                	 selector: 'contentpanel'
	                 },{
	                	 ref: 'studentserviceoptinreportgrid',
	                	 selector: 'studentserviceoptinreportgrid'
	                 }],
	            	
	                 init: function(application) {
	                	 this.control({
	                		 'studentserviceoptinreportfilter combo#serviceNameId': {
	                			 select: function(obj, record){
	                				 var serviceNameId = record[0].get("id");
	        	                	 var form = obj.up('form');
	        	                	 var programId = form.down('#programId');
	        	                	 var batchId = form.down('#batchId');
	        	                	 var seatTypeId = form.down('#seatTypeId');
	        	                	 var periodId = form.down('#periodId');
	        	                	 var sectionId = form.down('#sectionId');
	        	                	 programId.reset();
	        	                	 programId.setDisabled(false);
	        	                	 batchId.reset();
	        	                	 seatTypeId.reset();
	        	                	 periodId.reset();
	        	                	 sectionId.reset();
	        	                	 batchId.setDisabled(true);
	        	                	 seatTypeId.setDisabled(true);
	        	                	 sectionId.setDisabled(true);
	        	                	 periodId.setDisabled(true);
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	        	                	 programId.reset();
	        	                	 if(serviceNameId > 0){
	        	                		 var store = programId.getStore();
	        	                		 store.getProxy().extraParams = {
	        	                			 serviceId : serviceNameId,
	        	                			 academyLocationId : academyLocationId
	        	                		 };
	        	                		 store.load();
	        	                	 }
	                			 }
	                		 },
	                		 'studentserviceoptinreportfilter combo#programId': {
	                			 select: function(obj, record){
	                				 this.serviceOptInReportProgSelect(obj, record)
	                			 },
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId
	                				 };
	                				 store.load();
	                			 }
	                		 },
	                		 'studentserviceoptinreportfilter combo#batchId':{
	                			 select: function(obj, record){
	                				 this.serviceOptInReportBatchSelect(obj, record)
	                			 }
	                		 },
	                		 'studentserviceoptinreportfilter combo#periodId':{
	                			 select: function(obj, record){
	                				 this.serviceOptInReportPeriodSelect(obj, record)
	                			 }
	                		 },
	                		 'studentserviceoptinreportfilter combo#sectionId':{
	                			 select: function(obj, record){
	                				 this.serviceOptInReportSectionSelect(obj, record)
	                			 }
	                		 },
	                		 'studentserviceoptinreportfilter button[itemId=searchBtn]' : {
	                			 click : function(form) {
	                				 var grid = this.getStudentserviceoptinreportgrid();
	                				 var store = grid.getStore();
	                				 var form = this.getStudentserviceoptinreportfilter();
	                				 form.down('#searchBtn').setDisabled(true);
	                				 var values = form.getForm().getValues();
	                				 store.getProxy().extraParams = {
	                					 serviceId : values.serviceName,
	                					 studentId: values.STUDENT_ID,
	                					 programId : values.PROGRAM_NAME,
	                					 batchId : values.BATCH_NAME,
	                					 pbsId : values.seatType,
	                					 pbPeriodId : values.PERIOD_NAME,
	                					 sectionId : values.SECTION,
	                				 }
	                				 store.load({
		    		            			callback: function(records, operation, success) {
		    		            				 form.down('#searchBtn').setDisabled(false);
		    		            			}
		    	            			});
	                				 grid.config.searchFilterForm = this.getStudentserviceoptinreportfilter();
	                			 }
	                		 },
	                		 'studentserviceoptinreportfilter button[itemId=resetBtn]' : {
	                			 click : function(obj) {
	                				 var form = obj.up('form');
	                				 form.getForm().reset();
	                				 var program = form.down('#programId');
	                				 var batch = form.down('#batchId');
	                				 var period = form.down('#periodId');
	                				 var section = form.down('#sectionId');
	                				 var seatType = form.down('#seatTypeId');
	                				 program.clearValue();
	                				 batch.clearValue();
	                				 batch.setDisabled(true);
	                				 period.clearValue();
	                				 period.setDisabled(true);
	                				 section.clearValue();
	                				 section.setDisabled(true);
	                				 seatType.clearValue();
	                				 seatType.setDisabled(true);

	                				 var program = form.down('#programId');
	                				 var programStore = program.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 programStore.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId
	                				 };
	                				 programStore.load();
	                				 var alinfomodel = Academia.model.authentication.ALInfoModel;
		             		    		var wheatherSchool = alinfomodel.get('wheatherSchool');
		             		    		if(wheatherSchool){
		             		    			period.setVisible(false);
		             		    		}else
		             		    			{
		             		    			period.setVisible(true);
		             		    			}
	                			 }
	                			 },
	                         'studentserviceoptinreportgrid': {
	                        	 render : function(grid) {
	             					this.doAccessControlValidation(grid, this.getSTUDENT_SERVICE_OPTIN_PERMISSIONS());
	             					var alinfomodel = Academia.model.authentication.ALInfoModel;
	             		    		var wheatherSchool = alinfomodel.get('wheatherSchool');
	             		    		if(wheatherSchool){
	             		    			for (var j = 0; j < grid.columns.length; j++) {
	             		    				if (grid.columns[j].dataIndex == "periodName") {
	             		    					grid.columns[j].setVisible(false);

	             		    				}
	             		    			}
	             		    		}else{
	             		    			for (var j = 0; j < grid.columns.length; j++) {
	             		    				if (grid.columns[j].dataIndex == "periodName") {
	             		    					grid.columns[j].setVisible(true);

	             		    				}
	             		    			}
	             		    		}
	             				}
	                         },
	                         'studentserviceoptinreportfilter' : {
	                        	 render : function(form) {
	                        		 var serviceNameId = form.down('#serviceNameId');
	                        		 var store = serviceNameId.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationId: academyLocationId
	                				 };
	                				 store.load();
	                				 
	                				 var studentId = form.down('#studentId');
	                        		 var studentIdstore = studentId.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 studentIdstore.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId
	                				 };
	                				 studentIdstore.load();
	                				 
	                				 var periodId = form.down('#periodId');
	                				 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				 var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				 if(wheatherSchool){
	                					 periodId.setVisible(false);
	                				 }else{
	                					 periodId.setVisible(true);
	                				 }
	                				 
	                        	 }
	                         },
	                    	 
	                		  'studentserviceoptinreporttabstructure':{
	               			   render:function(studentserviceoptinreporttabstructure){
	               				   this.enableTabforserviceoptinPanel(studentserviceoptinreporttabstructure);
	               			   },
	               		   afterrender:function(structure)
	               		   {
	               			   var grid=structure.down('studentserviceoptinreportgrid');
	               			   this.getGridHeaderFreeze(grid,structure,true);
	               		   }
	               		   }
	                	 });
	                 },
	                 
	                 enableTabforserviceoptinPanel:function(studentserviceoptinreporttabstructure)
	                 {
	                	 this.showTabforserviceoptinPanel(studentserviceoptinreporttabstructure);
	                 },
	                 
	                 showTabforserviceoptinPanel : function(studentserviceoptinreporttabstructure) {
					  	   var panelItem = new Array();
					  	   var $this = this;
					  	   var newcont=studentserviceoptinreporttabstructure.items.items.length;
					  	   var insertPosition=newcont+1;
					  		   panelItem.push({
					  			   xtype:'tabpanel',
					  			   itemId:'allVisibleTP',
					  			   plain: true,
					  			   style:{overflow:'hidden !important',margin:'0!important'},
					  			   
					  			   frame: false,
					  			   border:false,
					  			   defaults: {
					  				   labelAlign: 'top'
					  			   },
					  			   items:[{
					  					xtype : 'studentserviceoptinreportstructure',
					  					itemId : 'studentserviceoptinreportstructure',
					  					title : getCommonTranslation('SEARCH'),
					  					tabCls : 'right-tab'
					  				}]
					  		   });

					  		 studentserviceoptinreporttabstructure.insert(insertPosition,panelItem);
					     },

	                 
	                 
	                 serviceOptInReportProgSelect : function(obj, record) {
	                	 var programId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var batch = form.down('#batchId');
	                	 serviceId = form.down("#serviceNameId").getValue();
	                	 batch.reset();
	                	 batch.setDisabled(false);
	                	 
        				 var period = form.down('#periodId');
        				 var section = form.down('#sectionId');
        				 var seatType = form.down('#seatTypeId');
        				 period.clearValue();
        				 period.setDisabled(true);
        				 
        				 var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							if(wheatherSchool) {
								period.setVisible(false);
		                	 }
        				 section.clearValue();
        				 section.setDisabled(true);
        				 seatType.clearValue();
        				 seatType.setDisabled(true);
	                	 
	                	 if(programId > 0){
	                		 var store = batch.getStore();
	                		 store.getProxy().extraParams = {
	                			 serviceId : serviceId,
	                			 programId: programId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 serviceOptInReportBatchSelect : function(obj, record){
	                	 $this = this;
	                	 var form = obj.up('form');
	                	 var period = form.down('#periodId');
	                	 period.reset();
	                	 period.setDisabled(false);
	                	 var seatTypeId = form.down('#seatTypeId');
	                	 seatTypeId.reset();
	                	 seatTypeId.setDisabled(false);
	                	 serviceId = form.down("#serviceNameId").getValue();
	                	 var batchId = record[0].get("id");
	                	 
	                	 var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							if(wheatherSchool) {
								period.setVisible(false);
		                	 }
	                	 
							if(batchId > 0){	    	        					  
								/*	 var store = period.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: batchId
	                		 };
	                		 store.load();*/
								var seatTypeStore = seatTypeId.getStore();
								seatTypeStore.getProxy().extraParams = {
									serviceId:serviceId,
									batchId: batchId
								};
								seatTypeStore.load();
								var periodStore = period.getStore();
								periodStore.getProxy().extraParams = {
									id: batchId
								};
								periodStore.load({
									callback: function(records, operation, success) {
										if (success) {
											var sectionComboBox = form.down('combo#sectionId');
											sectionComboBox.clearValue();
											sectionComboBox.setDisabled(false);
											if(records.length == 0){
												if(wheatherSchool){
													showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
													period.setVisible(false);
												}else {
													period.setDisabled(false);
												}
											}
											else if(records.length == 1){
												period.setValue(records[0].data.id);
												if(wheatherSchool) {
													period.setVisible(false);
												}else {
													period.setDisabled(false);
												}
												var store = sectionComboBox.getStore();
												store.getProxy().extraParams = {
													periodId: records[0].data.id
												};
												store.load();
											}else{
												period.setVisible(true);
												period.setDisabled(false);
											}		 
										}

									}	   
								});

							}
	                 },
	                 serviceOptInReportPeriodSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var section = form.down('#sectionId');
	                	 section.reset();
	                	 section.setDisabled(false);
	                	 var periodId = record[0].get("id");
	                	 if(periodId > 0){	    	        					  
	                		 var store = section.getStore();
	                		 store.getProxy().extraParams = {
	                			 periodId: periodId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 serviceOptInReportSectionSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var sectionId = record[0].get("id");
	                	 if(sectionId > 0){	    	        					  
	                		 var store = period.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: sectionId
	                		 };
	                		 store.load();
	                	 }
	                 }
});
