/**
 * Model for the Stage Statistic grid
 * used in the Admission Selection Stage.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.model.admission.selectionStage.StageStatistic', {
	extend : 'Ext.data.Model',
	fields : ['id','version',
	          { name: 'quota', mapping: 'programSelectionProcesStageQuota.quota.value' },
	          { name: 'quotaTypeId', mapping: 'programSelectionProcesStageQuota.programSelectionProcesQuotaType.id' },
	          { name: 'quotaTypeName', mapping: 'programSelectionProcesStageQuota.programSelectionProcesQuotaType.value' },
  	          { name: 'minSeat', mapping: 'programSelectionProcesStageQuota.minSeat'},
	          { name: 'maxSeat', mapping: 'programSelectionProcesStageQuota.maxSeat' },
	          { name: 'overriddenMinSeat', mapping: 'programSelectionProcesStageQuota.overriddenMinSeat'},
	          { name: 'overriddenMaxSeat', mapping: 'programSelectionProcesStageQuota.overriddenMaxSeat' },
	          
	          'numberOfApplication',
	          'numberOfSelectedStudents',
	          { name: 'violation',
	        	  convert : function (v, rec) {
	        		  var selectedStudents = parseInt(rec.get('numberOfSelectedStudents'));
	        		  var minSeat=rec.get('overriddenMinSeat');
	        		  var maxSeat=rec.get('overriddenMaxSeat');
	        		  var violation = 0;
	        		  
	        		  if(isNullOrEmpty(minSeat))
	        			  minSeat= rec.get('minSeat');
	        		  if(isNullOrEmpty(maxSeat))
	        			  maxSeat= rec.get('maxSeat');
	        		  
	        		  minSeat=parseInt(minSeat);
	        		  maxSeat=parseInt(maxSeat);
	        		  
	        		  if(selectedStudents > maxSeat)
	        			  violation=selectedStudents - maxSeat;
	        		  else if(selectedStudents < minSeat)
	        			  violation= selectedStudents - minSeat;
	        			  
	                  if(violation != 0) {
	                	  if(violation > 0) {
	                		  return '<div style="color:red;">+'+violation+'</div>';	                		  
	                	  } else {
	                		  return '<div style="color:red;">'+violation+'</div>';  
	                	  }
	                  }
	                  return violation;
	               }
	          },
	          'numberOfStudentsInWaitList',
	          'numberOfStudentsRejected',
	          'numberOfStudentsWithdrawn',
	      	  'numberOfStudentsReplaced',
	      	  {name: 'seatTypeId', mapping: 'seatType.id'},
	      	  {name: 'seatTypeName', mapping: 'seatType.value'}     	  
      ],
      set: function(fieldName, value) {
		    this.callParent(arguments);
		    if (fieldName==='minSeat' || fieldName==='maxSeat') {
		      this.set('violation');
		    }
	  }
});