/**
*@author Raghavendra.Soni
*/
Ext.define('Academia.model.examinationcenters.studentResultReport.StudentResultReportGridModel',{
	extend: 'Ext.data.TreeModel',
	fields: [
        {name: 'treeNode',				type: 'string'},
        {name: 'studentCode',			type: 'string'},
        {name: 'courseCode',			type: 'string'},
        {name: 'courseName',			type: 'string'},
        {name: 'maxMarksOrGrade',		type: 'string'},
        {
        	name: 'obtainedMarksGrade', 
        	convert : function (v, rec) {
        		if(!isNullOrEmpty(v)){
        			try{
        				if(v=="ABSENT"){
        					return "Absent";
        				}
        				else if(v=="DASH"){
        					return "-";
        				}
        				else if((v!=0 && rec.isLeaf()) && rec.raw.whetherQPPublish){
        						return '<a href=#>'+v+'</a>';
        					} else {
        						if(rec.get('examStatus') && rec.get('examStatus')=="Hold Applied") {
        							return getCommonTranslation('HOLD_APPLIED');
        						} else{
        							return v;
        						}
            					// return v;
        					}
        			}
        			catch(e){
            			return "-";
        			}
        		}else{
        			return "-";
        		}
        	},
        	type: 'string'
        },
        {
        	name: 'effetiveMarksGrade', 
        	convert : function (v, rec) {
        		if(!isNullOrEmpty(v)){
        			try{
        				if(v=="ABSENT"){
        					return "Absent";
        				}
        				else if(v=="DASH"){
        					return "-";
        				} 
        				else if((v!=0 && rec.isLeaf()) && rec.raw.whetherQPPublish){
        						return '<a href=#>'+v+'</a>';
        					} else {
        						if(rec.get('examStatus') && rec.get('examStatus')=="Hold Applied") {
        							return getCommonTranslation('HOLD_APPLIED');
        						} else{
        							return v;
        						}
            					// return v;
        					}
        			}
        			catch(e){
            			return "-";
        			}
        		}else{
        			return "-";
        		}
        	},
        	type: 'string'
        },
        {name: 'weightage',				type: 'string'},
        {name: 'moderationMarksGrade',	type: 'string'},
        {name: 'grade',					type: 'string'},
        {name: 'effectiveMarks',		type: 'string'},
        {name: 'obtainedMarks',			type: 'string'},
        {name: 'evaluationPlanNumber',	type: 'string'},
        {name: 'courseVariantId',		type: 'string'},
        {name: 'moderationPoints',		type: 'string'},
        {name: 'admissionId',			type: 'string'},
        {name: 'periodId',				type: 'string'},
        {name: 'evaluationPlanType',	type: 'string'},
        {name: 'evaluationPlanId',		type: 'string'},
        {name: 'evaluationPlanLevelOneId',     type: 'string'},
        {name: 'evaluationPlanLevelTwoId',     type: 'string'},
        {name: 'evaluationSequenceId',	type: 'string'},
        {name: 'eventId',				type: 'string'},
        {name: 'isResultPublish',				type: 'boolean'},
        {name: 'whetherQPPublish',				type: 'boolean'},
		 {name: 'typeRemark',	type: 'string'},
		 {name: 'examStatus'},

		{ name: 'courseCode' },
		{ name: 'courseName' },
		{ name: 'eventName' }
    ]
});