/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.model.transport.serviceRoute.TimeTablePBSModel',{
	extend : 'Ext.data.Model',
	fields : ["id","programName","batchName","periodName","sectionName","courseVariantName","facultyName","day","roomName",
	          "startTime",
	          "endTime",
	          "courseName","courseCode",
	          "timeslot","periodNo","cycleDays","facultyCode","departmentName","calendarEventId",
	          {
					name    : 'pbsSectionName', 
					convert : function (v, rec) {
						return rec.get('sectionName');
					}
		          },{
		        	  name: "programsArray", 
		        	  convert : function (v, rec) {
		        		  if(!isNullOrEmpty(rec.get('programName'))){
		        			  return rec.get('programName').split(",");
		        		  }
		        		  else{
		        			  return [];
		        		  }
		        	  }

		          },{
		        	  name: "batchesArray", 
		        	  convert : function (v, rec) {
		        		  if(!isNullOrEmpty(rec.get('batchName'))){
		        			  return rec.get('batchName').split(",");
		        		  }
		        		  else{
		        			  return [];
		        		  }
		        	  }

		          },{
		        	  name: "periodsArray", 
		        	  convert : function (v, rec) {
		        		  if(!isNullOrEmpty(rec.get('periodName'))){
		        			  return rec.get('periodName').split(",");
		        		  }
		        		  else{
		        			  return [];
		        		  }
		        	  }

		          }]
});
