Ext.define('Academia.store.admission.applications.applicantProfileBase.programCodeOrNameATCStore', {
     extend: 'Ext.data.Store',
     fields: ['programId','programName','programCode','batchId','batchName',{
         name: 'value',
         convert: function(v, record) {
             var code = record.get('programCode') || '';
             var name = record.get('programName') || '';
             if (code && name) {
                 return code + ' - ' + name;
             } else if (name) {
                 return name;
             } else {
                 return code;
             }
         }
     }],
     autoLoad: false,
     proxy: {
         type: 'rest',
         method: 'GET',
         api: {        		
             read: SERVERURL.PATH_FIND_APPLICANT_PROGRAM_BATCH      
         },
         reader: {
             type: 'json',
             root: 'rows',
             totalProperty: 'records'
         }
     }
 });