/**
 * This store is for displaying the StageStatistics in Admission Selection Stage.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.store.admission.selectionStage.StageStatistics', {
	extend : 'Ext.data.Store',
	model : 'Academia.model.admission.selectionStage.StageStatistic',
	autoLoad : false,
	pageSize : CONSTANTS.DEFAULT_PAGESIZE,

	proxy : {
		type : 'jsonajax',
		header: {
            contentType: 'application/json'
        },
        actionMethods: {
            read: 'POST'
        },  
		api : {
				read : SERVERURL.STAGESTATASTICSFINDBYCRITERIA
		},
		reader : {
			type : 'json',
			root : 'rows',
			totalProperty: 'records'
		}
	}
, filterGrid : function(filterIds) {
		this$ = this;
		if(filterIds.length <= 0) {
				this$.removeFilter();
		}
		
		if(filterIds.length != 0) {
			this$.filterBy(function(record, id){
				var recordFlag = false;
				Ext.each(filterIds, function(filter) {
					if(record.get('quotaTypeId') === filter) {
						recordFlag = true;
					};
				});
			    return recordFlag;
			}, this);
		}
	}

});
