/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.store.coursetransaction.promotion.PromotionPanelCurrentPeriodList', {
	extend : 'Ext.data.Store',
	fields : [
		'evaluationPlanRankId',
		'admissionId',
		'courseVariantId',
		'periodId',
		'obtainedCreditSum',
		'courseCredit',
		'spa',
		'effectiveMarks',
		'courseName',
		'eventMarks',
		'status',
		'academicTopic',
		'academicSubTopic',
		'description',
		'createdDate',
		'programName',
		'periodName',
		'academyLocationName',
		'moderate',
		'moderateId',
		'enrollCourseStatus',
		'minMarksOrGrade',
		'moderationDone',
		'remark',
		'grade',
		'whetherSpecialGrade',
		{
			name: 'combinedScore',
			convert: function(val, rec){
				if (rec.get('grade')){
					return rec.get('grade')
				}else{
					return rec.get('effectiveMarks')
				}
			}
		},
		{
			name: 'combinedCredits',
			convert: function(val, rec){
				return rec.get('courseCredit') + ' / ' + rec.raw.ectsCredits;
			}
		},
		{
			name: 'resitStatus',
			convert: function(val, rec){
				if(val==true){
					return "Yes"
				}
				else if(val==false){
					return "No"
				}
			}
		},
	],
	autoLoad : false,
	proxy : {
		type : 'rest',
		api:{
			read:SERVERURL.PATH_GET_PROGRESSION_PNL_CURRENT_PERIODS
		},
		reader: {
			type: 'json'
		}
	}

});
