/**
 * @author Ankur Jaiswal
 */
Ext.define('Academia.store.hrm.report.HRMAttendanceReportTreeStore', {
    extend: 'Ext.data.TreeStore',
    fields: ['reportXtype', 'reportXtypeItemId', 'text', 'permissionKey'],
    root: {
        success: true,
        expanded: true,
        children: [{
            text: getPersonModuleTranslation('HRM_ATTENDANCE_SUMMARY_REPORT'),
            reportXtype: 'hrmattendancesummaryreportstructure',
            reportXtypeItemId: 'hrmattendancesummaryreportstructureItemId',
            permissionKey: 'ATTENDANCE_SUMMARY_REPORT',
            leaf: true
        }, {
            text: getPersonModuleTranslation('HRM_WORKING_HOUR_REPORT'),
            permissionKey: 'WORKING_HOUR_REPORT',
            reportXtype: 'hrmworkinghourreportstructure',
            reportXtypeItemId: 'hrmworkinghourreportstructureItemId',
            leaf: true
        },{
            text: getPersonModuleTranslation('HRM_ATTENDANCE_PUNCH_LOG_REPORT'),
            permissionKey: 'ATTENDANCE_PUNCH_LOG_REPORT',
            reportXtype: 'hrmattendancepunchlogreportstructure',
            reportXtypeItemId: 'hrmattendancepunchlogreportstructureItemId',
            leaf: true
        },{
            text: getPersonModuleTranslation('HRM_ATTENDANCE_STATUS_REPORT'),
            permissionKey: 'ATTENDANCE_STATUS_REPORT',
            reportXtype: 'hrmattendancestatusreportstructure',
            reportXtypeItemId: 'hrmattendancestatusreportstructureItemId',
            leaf: true
        }
        /*{
            text: getPersonModuleTranslation('HRM_EMPLOYEE_LEAVE_REPORT'),
            permissionKey: 'EMPLOYEE_LEAVE_REPORT',
            leaf: true
        }*/]
    }
});