Ext.define('Academia.store.messaging.MessageCategoryStore', {
     extend: 'Ext.data.Store',
     model: 'Academia.model.common.IdValueCodeDataModel',
     autoLoad: false,
     sorters: [{
         property: 'code',
         direction: 'ASC'
     }],
     sortOnLoad: true,
     remoteSort: false,
     proxy: {
         type: 'rest',
         api: {        	   
             read: SERVERURL.FIND_ALL_MESSAGE_CATEGORY      //URL -rest/msgCatagoryResource/findAllMsgCategory 
         },
         reader: {
             type: 'json'
         }
     },
     listeners: {
         load: {
             element: 'el',
             fn: function(store, records, successful, eOpts) {                 
                 for (var count = 0; count < records.length; count++) {
                     var record = records[count];
                     var resultKey=record.get('code');
                     if(!isNullOrEmpty(resultKey)){
                    	 records[count].set('code', getMessagingModuleTranslation(resultKey));
                     }                     
                 }
                 store.commitChanges();
             }
         }
     }
 });