/**
 * Live search combo details store
 */
Ext.define('Academia.store.personinfo.common.disciplinaryactivity.ReportedUserSearchCombos',{
	extend:'Ext.data.Store',
	model : 'Academia.model.common.LiveSearchComboModel',	
	autoLoad : false,
	proxy : {
		type : 'rest',
		api : {
			read : SERVERURL.APPROVAR_DATA 
		},
		method: 'GET',
		reader : {
			type : 'json'
			
		}
	},
	
	listeners: {
    	beforeload:{
    		 element: 'el',
             fn: function(store, records, successful, eOpts) {
                 var academyLocationId = Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue();
                 store.getProxy().extraParams = {
                	 academyLocationId:academyLocationId
                 };   
             } 
    	},
	},
	
	buildTemplate: function() {
		var displayTpl = null;
		if(this.displayTpl!=undefined || this.displayTpl!=null){
			displayTpl =  this.displayTpl;
		}else{
			displayTpl =  new Ext.XTemplate(
					'<tpl for="."between=" ">',
					//'{[typeof values === "string" ? values : values["salutation.value"]]}'+
					'{[typeof values === "string" ? values : values["firstName"]]}' + ' '+
					'{[typeof values === "string" ? values : values["lastName"]]}' + ' [' +
					'{[typeof values === "string" ? values : values["code"]]}'+']' +
					//'{[typeof values === "string" ? values : values["department"]]}'+
					'</tpl>'
			);
		}
	    return displayTpl;
	},
	sorters: [{
		property: 'code',
		direction: 'ASC'
	}],
});
