/**
 * This store is used for complaints dashboard report tree panel
 * @author Sachin.Bangar
 */
Ext.define('Academia.store.reports.complaints.ComplaintsReportTreeStore', {
	extend : 'Ext.data.TreeStore',
	fields: ['reportXtype', 'reportXtypeItemId', 'text'],
	root: {
        success: true,
        children: [{
        	text: getServiceRequestTranslation('GRIEVANCES'),
        	reportXtype: '',
        	reportXtypeItemId: '',
            leaf: false,
            expanded: true,
            children: [{
            	text: getServiceRequestTranslation('GRIEVANCE_UNASSIGNED'),
            	reportXtype: 'unassignedcomplaintreportview',
            	reportXtypeItemId: 'unassignedComplaintReportView',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('COMPLAINTS_FOLLOW_UP_SCHEDULED'),
            	reportXtype: 'followupscheduledcomplaintsview',
            	reportXtypeItemId: 'followUpScheduledComplaintsView',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('COMPLAINTS_SERVICE_LEVEL_GRAPH'),
            	reportXtype: 'complaintservicelevelgraphview',
            	reportXtypeItemId: 'complaintServiceLevelGraphView',
                leaf: true
            }, /*{
            	text: getServiceRequestTranslation('COMPLAINTS_HISTORY_GRAPH'),
            	reportXtype: 'complaintshistorygraphview',
            	reportXtypeItemId: 'complaintServiceLevelGraphView',
                leaf: true
            }, */{
            	text: getServiceRequestTranslation('GRIEVANCE_PENDING_GRAPH'),
            	reportXtype: 'pendingcomplaintshistoryview',
            	reportXtypeItemId: 'pendingComplaintsHistoryView',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('GRIEVANCE_CLOSURE_RATE'),
            	reportXtype: 'complaintsclosurerateview',
            	reportXtypeItemId: 'complaintsClosureRateView',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('GRIEVANCE_CLOSURE_REASON'),
            	reportXtype: 'complaintsclosurereasonview',
            	reportXtypeItemId: 'complaintsClosureReasonView',
                leaf: true
            }]
        }]
    }
});