Ext.define('Academia.store.securitysetup.Roles',{
	extend:'Ext.data.Store',
	fields:['serialNumber','roleName','description','whetherDeleted','whetherEditable','whetherDeletable','id', 'isLocked',
        {name:'createdOn',
		
        },
        {
            name    : 'roleNameTranslated', 
            convert : function (v, rec) {
            	if(!isNullOrEmpty(rec.get('roleName'))){
            		 return getCommonTranslation(rec.get('roleName'));
            	}else {
            		 return null;
            	}
            }
        }
],
	sorters: [{
        property: 'serialNumber',
        direction: 'ASC'
    },{
        property: 'roleName',
        direction: 'ASC'
    }],
	autoLoad:false,
	proxy:{
		type:'rest',
		api:{
			read:SERVERURL.ROLE_GRID_DATA
		},	
		reader:{
			type:'json',
			root: 'rows',
			totalProperty: 'records'
		},
		
	}/*
	remoteFilter: true,
	remoteSort: true,
	sortOnLoad: true,
	pageSize: 10,
	autoDestroy: true,
	autoSync:true,
	extraParams:{
		searchText:''
	}*/		
});