/**
 * @author Pritam.Patil
 * complaint faculty combo store
 */
Ext.define('Academia.store.servicerequest.complaintrequest.ComplaintPersons',{
	extend:'Ext.data.Store',
	model: 'Academia.model.common.IdValueDataModel',
	autoLoad: false,
	sorters: [{
		sorterFn: function(o1, o2) {
			var value1 = o1.get('value');
			var value2 = o2.get('value');

			if (!isNullOrEmpty(value1) && !isNullOrEmpty(value2)) {
				if (value1.toLowerCase() === value2.toLowerCase()) {
					return 0;
				} else {
					return value1.toLowerCase() > value2.toLowerCase() ? 1 : -1;
				}
			}
			return 0;
		}
	}],
	proxy:{
		type:'rest'
	},
    listeners: {
    	beforeload:{
    		 element: 'el',
             fn: function(store, records, successful, eOpts) {
                 var academyLocationId = Ext.ComponentQuery.query('customcombobox#cmbGlobalAcademyLocation')[0].getValue();
                 store.getProxy().extraParams = {
                	 academyLocationId:academyLocationId
                 };   
             } 
    	}
    }
	  
});
