Ext.define('Academia.store.setup.loginPageSetup.LoginPageUrlStore',{
	extend:'Ext.data.Store',
	fields:['id','name','value',
		{
		name    : 'nameValue', 
		convert : function (v, rec) {
			if(rec.data.value!='Default Page'){
				return rec.get('name') + ' - ' + rec.get('value');
			}else{
				return rec.data.value;
			}
		}
		}],
	autoLoad: false,
	proxy:{
		type:'rest',
		api:{
			read:SERVERURL.PATH_FIND_LOGIN_PAGE_URL_DROP_DOWN
		},
		reader:{
			type: 'json'
		}
	},
	listeners: {
		load: function (store,records) {
			var filteredRecords = records.filter(function(record) {
				return record.get('name') !== null && record.get('value') !== null;
			});

			store.removeAll();
			store.add(filteredRecords);

			store.add({
				id: 'DEFAULT_PAGE', 
				name: 'Default Page',
				value: 'Default Page'
			});
			var comboBox = Ext.ComponentQuery.query("#urlItemId")[0];
			if (comboBox) {
				comboBox.setValue('DEFAULT_PAGE'); 
			}
		}
	}
});