/**
 * @author Raghavendra.Soni
 * All overrides should be written in this file only.
 */

//Override Ext.Ajax.request to automatically set options.fns
Ext.override(Ext.Ajax, {
    request: function(options) {
        options = options || {};

        // Set fns to the name of the caller function if available
        try {
            if (arguments.callee.caller && !isNullOrEmpty(arguments.callee.caller)) {
                options.fns = (arguments.callee.caller.name=="")?"EMPTY":arguments.callee.caller.name;
            } else {
                options.fns = '';
            }
        } catch (e) {
            options.fns = '';
        }

        // Call the original Ext.Ajax.request with modified options
        return this.callParent([options]);
    }
});

Ext.override(Ext.button.Button, {
    initComponent: function () {
        this.callParent(arguments);

        // Replace glyph with Phosphor iconCls based on known glyph values
        switch (this.glyph) {
            case ICONGLYPH.ADDGLYPH:
                this.setIconCls('ph ph-plus');
                delete this.glyph;
                break;

            case ICONGLYPH.EDITGLYPH:
                this.setIconCls('ph ph-pencil');
                delete this.glyph;
                break;

            case ICONGLYPH.DELETEGLYPH:
                this.setIconCls('ph ph-trash');
                delete this.glyph;
                break;

            // Add more cases here as needed
        }
        
     // Replace glyph with Phosphor iconCls based on known glyph values
        switch (this.iconCls) {
            case 'icon-addbutton':
                delete this.iconCls;
                this.setIconCls('ph ph-plus');
                break;

            case 'icon-editbutton':
                delete this.iconCls;
                this.setIconCls('ph ph-pencil');
                break;
                
            case 'icon-View':
            case 'view-icon':
                delete this.iconCls;
                this.setIconCls('ph ph-eye');
                break;

            case 'icon-Delete':
                delete this.iconCls;
                this.setIconCls('ph ph-trash');
                break;

            // Add more cases here as needed
        }
        
        switch(this.cls) {
	        case 'CustomBodyBtnSettings':
	        case 'CustomBodyBtnSettings mtAddRow':
	        case 'CustomBodyBtnSettings addRowButtonCls':
	        	if(this.tooltip == getCommonTranslation('ADD')) {
	        		this.removeCls('CustomBodyBtnSettings');
	        		this.removeCls('mtAddRow');
	        		this.addCls('plus-btn');
	        		this.setIconCls('ph ph-plus');
	        		var btn = this;
	        		Ext.defer(function() {
	        			btn.setText('');
	        		}, 500);
	        	}
	        	break;
	        case 'CustomBodyBtnReject':
	        case 'CustomBodyBtnReject deleteRowButtonCls': 
	        case 'CustomToolbarBtnReject iconDelete':
	        	this.removeCls('CustomBodyBtnReject');
	        	this.addCls('delete-btn');
	        	this.setIconCls('ph ph-trash');
	        	delete this.glyph;
	        	var btn = this;
	        	Ext.defer(function() {
	        		btn.setText('');
	        	}, 500);
	        	break;
        }
    }
});

/* Overridden each component for help field behaviour. */
Ext.override(Ext.Component, {
	afterRender: function(cmp)
	{
		if(Ext.isDefined(this) && Ext.isDefined(this.xtype)){
			var self = this;
			var parent = this.up();
			var selfXtype = this.xtype;
			var parentXtype = (Ext.isDefined(parent) && parent.xtype) ? parent.xtype+"_" : "";
			var selfName = Ext.isDefined(this.name) ? this.name+"_" : "";
			var selfItemId = Ext.isDefined(this.itemId) ? this.itemId+"_" : "";
			
			var xpath = parentXtype+selfName+selfItemId+selfXtype;
			
			if(selfXtype && selfXtype == "verticalnavigationmenubutton"){
				xpath = xpath + "_" + this.displayCode;
			}
				
			if(self && self.el && self.el.dom && self.el.dom.setAttribute){
				self.el.dom.setAttribute('data-xpath', xpath);
			}
		}
		
		//-- Start - Code to hide combo picker on parent panel scroll - V2D-409676
		if(Ext.isDefined(this) && Ext.isDefined(this.xtype) && Ext.isDefined(this.superclass) && Ext.isDefined(this.superclass.xtypesChain) && Ext.isArray(this.superclass.xtypesChain) && Ext.Array.contains(this.superclass.xtypesChain, "container")){
			if(this.autoScroll){
				try{
					this.body.on('scroll', function(){
						if(Ext.query('.x-boundlist:visible').length){
							var boundListCombo = Ext.getCmp(Ext.query('.x-boundlist:visible')[0].id).up('combo');
							if(boundListCombo && Ext.isDefined(boundListCombo) && boundListCombo.collapse && boundListCombo.xtype != 'multiselectcombofield'){
								boundListCombo.collapse();
							}
						}
					});
				}
				catch(e){
					//
				}
			}
		}
		//-- End - Code to hide combo picker on parent panel scroll - V2D-409676
		
		if (Ext.isDefined(this) && Ext.isDefined(this.xtype)) {
            var F = this;
            var E = this.up();
            var v = this.xtype;
            var J = (Ext.isDefined(E) && E.xtype) ? E.xtype + "_" : "";
            var H = Ext.isDefined(this.name) ? this.name + "_" : "";
            var K = Ext.isDefined(this.itemId) ? this.itemId + "_" : "";
            var A = J + H + K + v;
            if (F && F.el && F.el.dom && F.el.dom.setAttribute) {
                F.el.dom.setAttribute("data-xpath", A)
            }
        }
		
		var elements = Ext.ComponentQuery.query('[translationKey]');
		Ext.each(elements, function(element){
			if(element.translationKey){
				if(element.xtype == 'textfield' || element.xtype == 'combo')
					element.setFieldLabel(getCommonTranslation(element.translationKey));
				else if(element.xtype == 'button')
					element.setText(getCommonTranslation(element.translationKey));
			}
		});
		/**
		 * Apply new CSS and Icon class on all grid button (add, edit, view, delete and print) in Academia 
		 * 
		 */
		if((this && this.superclass && this.superclass.xtypesChain && Ext.Array.contains(this.superclass.xtypesChain,'grid')) || (this &&  this.xtype == 'grid')){
			if(this.getHeader() == false){
				this.header=null;
				if(this.xtype == 'griddashlet'){
					this.setTitle(' ');
				}else{
					this.setTitle(this.title);
				}
				
			}
			if(!this.getHeader()){
				this.setTitle(' ');
			}
			if((this.down('custompagingtoolbar') || this.xtype == 'searchresultgrid')){
				var toolBar=this.down("toolbar");
				if(toolBar) {
					toolBar.insert(0, ['->']); 
					toolBar.insert(0, {xtype: 'customTopPagingToolBar'});
				}
				
				
			}else{
				var toolBar=this.down("toolbar");
				if(this.itemId !=='outStandingAmountDashlet' && this.xtype !=='questionpaperdocumentgrid' && this.xtype !=='servicerequestmandatorydocuments' && this.xtype !=='servicerequestvoluntarydocuments' && 
						this.xtype !=='studentfeepayerdetaildocumentgrid' && this.xtype !=='studentpassportdocumentgrid' && this.xtype !=='studentpassporturlgrid' &&
						this.xtype !=='vaccinationinfodocumentgrid' && this.xtype !=='applicantvaccinationinfodocumentgrid'&& this.xtype !=='applicantstaticdocumentattachmentgrid'
						 && this.xtype !=='studentstaticdocumentattachmentgrid'&& this.xtype !=='enquirystaticdocumentattachmentgrid'
						 && this.xtype !=='proofofactivitydocumentgrid'&& this.xtype !=='independentnonexaminingchairpersondocgrid'
						 && this.xtype !=='studentthesisuploaddocumentgrid'&& this.xtype !=='studentethicsclearanceletterdocumentgrid'
						 && this.xtype !=='studentmoudocumentgrid'&& this.xtype !=='functionaryprogressreportdocumentgrid'
						 && this.xtype !=='studentownprogressreportdocumentgrid'&& this.xtype !=='studentjointdegreedocumentgrid'&& this.xtype !=='postdocinfodocumentgrid'
						 && this.xtype !=='studenthealthinformationdocumentgrid'&& this.xtype !=='studenthealthinformationurlgrid'
						 && this.xtype !=='studenteducationhistorydocumentgrid'&& this.xtype !=='studenteducationhistoryurlgrid'
						 && this.xtype !=='studentlanguagedocumentgrid'&& this.xtype !=='studentlanguageurlgrid'
						 && this.xtype !=='trainingtypedocument'&& this.xtype !=='patenttypedocument'&& this.xtype !=='studentvisaurlgrid'&& this.xtype !=='studentvisadocumentgrid'
						 && this.xtype !=='applicantvisadocumentgrid'&& this.xtype !=='applicantvisaurlgrid'&& this.xtype !=='studentlanguagedocumentgrid'&& this.xtype !=='studentlanguageurlgrid'
						 && this.xtype !=='applicantlanguagedocdetailgrid'&& this.xtype !=='applicantlangurlgrid'&& this.xtype !=='permitdocumentgrid'&& this.xtype !=='permiturldocumentgrid'
						 && this.xtype !=='applicantpermitdocumentgrid'&& this.xtype !=='applicantpermiturldocumentgrid'&& this.xtype !=='feepayerdetaildocumentgrid'  && this.xtype !=='studenthomeworkassignmentdocumentgrid'
						 && this.xtype !=='applicanteducationhistoryurlgrid'&& this.xtype !=='applicanteducationhistorydocumentgrid'
						 && this.xtype !=='academictopicdocumentgrid'  && this.xtype !=='programbatchdocumentgrid'
						 && this.xtype !=='lessonplanningdocumentgrid' && this.xtype !=='programdocumentgrid'
						 && this.xtype !=='academictopicdocumenturlgrid' && this.xtype !=='documentandnotesdocumentgrid' && this.xtype !=='documentandnotesurlgrid'
						 && this.xtype !=='applicantpassportdocumentgrid' && this.xtype !=='applicantpassporturlgrid'
						 && this.xtype !=='applicantinsurancedocumentgrid' && this.xtype !=='applicantinsuranceurlgrid'
						 && this.xtype !=='homeworkassignmentdocumentgrid' && this.xtype !=='meetingdocumentgrid' && this.itemId !=='d365dashletgrid' 
						 && this.xtype  !=='coursesessiondocumentgrid' && this.xtype  !=='studenttransferexecutiondocumentgrid'&& this.xtype  !=='applicanthealthinformationdocumentgrid' && this.xtype  !=='applicanthealthinformationurlgrid'
						 && this.itemId  !=='plannedDetailsItemId' && this.itemId  !=='actualDetailsItemId' && this.xtype !=='multiplealandrolesgrid'
						 && this.xtype  !=='coursesessiondocumentgrid' && this.xtype  !=='studenttransferexecutiondocumentgrid'&& this.xtype  !=='applicanthealthinformationdocumentgrid' && this.xtype  !=='applicanthealthinformationurlgrid'
					     && this.xtype  !=='studentinsurancedocumentgrid' && this.xtype  !=='studentinsuranceurlgrid' && this.xtype  !=='bulkAcademicTopicDocumentGrid' && this.xtype  !=='studentexaminersreportdocumentgrid' && this.xtype  !=='positiveincidentdocumentgrid'){
					if(toolBar){
					toolBar.insert(0, ['->']); 
					toolBar.insert(0, {xtype:'displayfield',
						minWidth:40,
						height:30,
						//hidden:true,
						itemId:'totalRecordDisplayField',
						name:'totalRecordDisplayField',
						cls:'total-Count-cls',
						margin:'-3x 0px 0px 10px',
						value:getCommonTranslation('TOTAL_RECORDS')+": 0"
						});
					}else{
						this.getHeader().insert(0, {xtype:'displayfield',
							minWidth:40,
							height:30,
							//hidden:true,
							itemId:'totalRecordDisplayField',
							name:'totalRecordDisplayField',
							cls:'total-Count-cls',
							margin:'-3x 0px 0px 10px',
							value:getCommonTranslation('TOTAL_RECORDS')+": 0"
							});
					}
					}
			}
			if(this.down('toolbar')){
				var toolbarBtnsArray = Ext.query('#'+this.down('toolbar').id+' .x-btn');
				Ext.each(toolbarBtnsArray, function(currentbtn){
					var currentBtnCmp = Ext.getCmp(currentbtn.id);
					var btnCheck = currentBtnCmp.glyph;
					if(!currentBtnCmp.glyph){
						 btnCheck = currentBtnCmp.iconCls;
					}
					if(currentBtnCmp.icon && currentBtnCmp.icon.indexOf('print1') != -1){
						btnCheck = 'printBtn';
					}
						switch (btnCheck) {
					  case '70@Pictos':
						  var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
					    if(spanBtn && spanBtn[0]){
					    	spanBtn[0].removeAttribute('class');
					    	Ext.get(spanBtn[0]).update('');
					    	spanBtn[0].setAttribute('class','x-btn-icon-el icon-addbutton');
					    	currentBtnCmp.setIconCls('icon-addbutton')
					    	currentBtnCmp.addCls('addbutton')

					    }
					    break;
					  case 'view-icon':
						  var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
						  if(spanBtn && spanBtn[0]){
						    	spanBtn[0].removeAttribute('class');
						    	Ext.get(spanBtn[0]).update('');
						    	spanBtn[0].setAttribute('class','x-btn-icon-el icon-View');
						    	currentBtnCmp.setIconCls('icon-View');
						    	currentBtnCmp.addCls('iconView');

						    }
						  break;
					  case '116@Pictos':
						  var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
						  if(spanBtn && spanBtn[0]){
						    	spanBtn[0].removeAttribute('class');
						    	Ext.get(spanBtn[0]).update('');
						    	spanBtn[0].setAttribute('class','x-btn-icon-el icon-Delete');
						    	currentBtnCmp.setIconCls('icon-Delete');
						    	currentBtnCmp.addCls('iconDelete');

						    }
					    break;
					  case '47@Pictos':
					    var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
					    if(spanBtn && spanBtn[0]){
					    	spanBtn[0].removeAttribute('class');
					    	Ext.get(spanBtn[0]).update('');
					    	spanBtn[0].setAttribute('class','x-btn-icon-el icon-editbutton');
					    	currentBtnCmp.setIconCls('icon-editbutton');
					    	currentBtnCmp.addCls('editbutton');

					    }
				    break;
					  case 'printBtn':
						    var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
						    if(spanBtn && spanBtn[0]){
						    	spanBtn[0].removeAttribute('class');
						    	Ext.get(spanBtn[0]).update('');
						    	spanBtn[0].setAttribute('class','x-btn-icon-el print-btn');
						    	currentBtnCmp.setIconCls('print-btn');

						    }
					    break;
					  case '76@Pictos':
						    var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
						    if(spanBtn && spanBtn[0]){
						    	spanBtn[0].removeAttribute('class');
						    	Ext.get(spanBtn[0]).update('');
						    	spanBtn[0].setAttribute('class','x-btn-icon-el refresh-icon');
						    	currentBtnCmp.setIconCls('refresh-icon');
						    	currentBtnCmp.addCls('refresh-btn');

						    }
					    break;
					}
				});
				var toolItems = this.down('toolbar').items.items;
				var isTbfill = false;
				toolItems.forEach(function(item){
					if(item.xtype == 'tbfill'){
						isTbfill = true;
					}
					if(isTbfill){
						item.addCls('algin-right-cls')
					}
				});
				var splitBtn=this.query('splitbutton');
				splitBtn.forEach(function(rec){
					rec.menu && rec.menu.addCls('moreActionNewMneuBtnCls');
				    if(rec.menu && rec.menu.items && rec.menu.items.items){
				    	rec.menu.items.items.forEach(function(menuItem){
				    		menuItem.addCls('moreActionNewMneuBtnCls');
				    	});
				    }
				});
				var me = this;
				Ext.defer(function() {
					var printExportBtn = me.query('button[cls=print_export_btn_cls]');
					if(printExportBtn && printExportBtn[0]) {
						printExportBtn[0].menu.addCls('print_export_btn_menu_cls');
						printExportBtn[0].menu.items.items.forEach(function(rec){
							rec.menu && rec.menu.addCls('print_export_btn_menu_cls');
						});
					}
				}, 100);
			}
			if(this.xtype !=='fileuploadmultipledraganddrop'){
			var view = this.getView();
			view.emptyText = '<div class="x-grid-empty">'+getCommonTranslation('EMPTY_MESSAGE')+'</div>';
			view.deferEmptyText = false;
			view.refresh();
			}
		}
		
		/**
		 * Overridden Calendar for checking and adding 'Export' button.
		 * @author Raghavendra.Soni
		 */
		try{
			if(Ext.isDefined(this.showExportToPNG) && this.showExportToPNG==true){
				//--getting calendar
				var cal = this;
				
				//--getting buttonContainer to place export button
				var buttonContainer = '';
				if(cal.getDockedItems('toolbar').length){
					buttonContainer = cal.getDockedItems('toolbar')[0];
				}
				else if(cal.up().getDockedItems('toolbar').length){
					buttonContainer = cal.up().getDockedItems('toolbar')[0];
				}
				else if(Ext.isDefined(cal.up().down('fieldcontainer'))){
					buttonContainer = cal.up().down('fieldcontainer');
				}
				
				if(!isNullOrEmpty(buttonContainer)){
					//--generating random id for new export button
					var exportButtonId = randomString(7);
					
					//--adding export button to buttonContainer
					buttonContainer.add({
	        			xtype: 'button',
	        			text: getCommonTranslation('EXPORT_TO_PNG'),
	        			id: exportButtonId,
//	    				buttonAlign : 'right',
	    				itemId:'exportToPngBtn',
	    				scale : CONSTANTS.BUTTONSIZE,
	    				ui: 'CustomBtnSubmit',
						cls:'common-btn-cls',
	        			handler: function(button){
	        				//--- generating exported file name dynamically
	        				try{
	        					var tabTitle = button.up('tabpanel').getActiveTab().title;
	        				}
	        				catch(e){
	        					var tabTitle = getCommonTranslation('EXPORT_TO_PNG');
	        				}
        					var fileName = tabTitle.replace(/ /g,'_').toLowerCase() + ".png";
	        				
        					//--- reconfigure texts before exporting
        					var evtBody = Ext.query('.ext-evt-bd');
    	            		Ext.each(evtBody, function(currentEvt){
    	            			currentEvt.innerText = currentEvt.innerText.replace(/-/g, ' - ');
    	            		});
	        				var element = '';        					
	        				if(Ext.isDefined(button.up('calendarpanel'))){
	        					var isPrintBtnPresent = false;
	        					try{
	        						if(Ext.isDefined(button.up('calendarpanel').down('#btnPrint'))){
	        							button.up('calendarpanel').down('#btnPrint').el.dom.style.opacity = 0;
	        							isPrintBtnPresent = true;
	        						}
	        					}
	        					catch(e){
	        						isPrintBtnPresent = false;
	        					}
	        					button.el.dom.style.opacity = 0;

	        					var element = button.up('calendarpanel').el.dom;

	        					setTimeout(function(){
	        						button.el.dom.style.opacity = 1;
	        						if(isPrintBtnPresent){
	        							button.up('calendarpanel').down('#btnPrint').el.dom.style.opacity = 1;
	        						}
	        					},1);
	        				}
	        				else if(button.up('panel').down('calendarpanel')){
	        					var element = button.up('panel').down('calendarpanel').el.dom;
	        				}
	        				if(!isNullOrEmpty(element)){
		        				var getCanvas;
		        				html2canvas(element).then(function(canvas){
		        					document.body.appendChild(canvas);
		        		            getCanvas = canvas;
	        						var imgageData = getCanvas.toDataURL("image/png");
	        						var newData = imgageData.replace(/^data:image\/png/, "data:application/octet-stream");
	        						saveExportedPNGFile(fileName, newData);
	        						setTimeout(function(){
	        							document.body.removeChild(canvas);
	        						},300);
		        				});
	        				}
	        			}
	        		});
				}
			}
		}
		catch (e){
		}
		
		try{
			if(Ext.isDefined(this.isGridConfigurable) && this.isGridConfigurable==true){
				var currentGrid = this;
				var currentPortalId = localStorage.getItem('portalId');

				var isCBGrid = false;
				var isSync=true;
				if(!isNullOrEmpty(currentGrid.up()) && currentGrid.up().xtype == 'studentattendancegrid')
					{
					var gridClass = 'Academia.view.attendance.StudentAttendanceGrid';
					}else{
					var gridClass = currentGrid.$className;
					}
				
				
				if(gridClass.indexOf("SearchResultGrid")!=-1){
					gridClass = currentGrid.cbViewCode;
					isCBGrid = true;
					isSync=false;
				}
				
				var parentUserId = null;
				if(!isNullOrEmpty(localStorage.getItem('parentUserId')) && !isNullOrEmpty(currentPortalId) && currentPortalId==7) {
					parentUserId = localStorage.getItem('parentUserId');
				}
				
				Ext.Ajax.request({
    				type : 'rest',
    				url : SERVERURL.PATH_GET_GRID_COLUMN_CONFIGURATION,
    				params : {
    					portalId : currentPortalId,
    					parentUserId : parentUserId,
    					gridName : gridClass
    				},
    				method : 'GET',
    				async:isSync,
    				success : function(response) {
    				if(response.responseText!="") {
    					var respData = Ext.decode(response.responseText);
    					var responseData = Ext.decode(respData.jsonObject);
    					
    					var respUserData = respData;
    					
    					var hiddenColumns = [];
    					var removedColumns = [];
    					var visibleColumns = [];
    					Ext.each(responseData, function(currentResponseColumn){
    						if(currentResponseColumn.columnVisibility=="HIDE"){
    							hiddenColumns.push(currentResponseColumn.dataIndex);
    						}
    						else if(currentResponseColumn.columnVisibility=="REMOVE"){
    							removedColumns.push(currentResponseColumn.dataIndex);
    						}
    						else if(currentResponseColumn.columnVisibility=="SHOW"){
    							visibleColumns.push(currentResponseColumn.dataIndex);
    						}
    					});
    					if(!isCBGrid){
							
							if(visibleColumns.length==0)
							{
								currentGrid.headerCt.getGridColumns()[0].hide();
							}
	
    						var gridColumn=currentGrid.columns;
    						if(isNullOrEmpty(gridColumn)){
    							gridColumn=currentGrid.down('grid').columns;
    						}
        					Ext.each(gridColumn, function(currentGridColumn){
        						try{
        							if(Ext.Array.contains(hiddenColumns,currentGridColumn.dataIndex)){
        								currentGridColumn.hide();
        							}
        							else if(Ext.Array.contains(visibleColumns,currentGridColumn.dataIndex)){
        								currentGridColumn.show();
        								currentGridColumn.menuDisabled = true;
        							}
        							else{
        								currentGridColumn.hide();
        							}
        						}
        						catch(e){}
        					});
        					currentGrid.visibleColumns = visibleColumns;
    					}
    					
    					Ext.Ajax.request({
            				type : 'rest',
            				url : SERVERURL.PATH_GET_GRID_COLUMN_CONFIGURATION_DEFAULT,
            				params : {
            					portalId : currentPortalId,
            					gridName : gridClass
            				},
            				async:isSync,
            				method : 'GET',
            				success : function(response) {
            					var respData = Ext.decode(response.responseText);
            					var responseData1 = Ext.decode(respData[0].jsonObject);
                    			
                    			var resultGridStoreData = [];
                    			Ext.each(responseData1, function(currentGridColumn){
                    				resultGridStoreData.push({
                    					id: currentGridColumn.id,
                    					columnName: currentGridColumn.columnName,
                    					dataIndex: currentGridColumn.dataIndex,
                    					columnVisibility: currentGridColumn.columnVisibility,
                    					mandatory: currentGridColumn.mandatory,
                    					sequence: currentGridColumn.sequence
                    				});
                    			});
                    			if(currentGrid.xtype == "griddashlet"){
                    				var panel = currentGrid.up();
                    				currentGrid.up().addDataGridConfigureButtonDashlet(panel,gridClass,resultGridStoreData,responseData,respUserData);
                    			}
                    			else{
                    				var isWindow=null;
                    				if(isNullOrEmpty(currentGrid.getHeader())){
                    					var grid= currentGrid.down('grid');
                    					if(grid.up('window')){
                    						isWindow=grid.up('window');
                    					}
                    					if(!isNullOrEmpty(grid)){
                    						grid.getHeader().add({
                    							xtype: 'button',
                    							text: getCommonTranslation('COLUMNS'), 
                    							ui: 'CustomBtnSubmit',
                    							cls:'common-btn-cls',
                    							scale: CONSTANTS.BUTTONSIZE,
                    							gridClass: gridClass,
                    							hidden:true,
                    							defaultColumns: resultGridStoreData,
                    							userDefinedColumns: responseData,
                    							recordId: respUserData.id,
                    							dataGridId: respUserData.dataGridId,
                    							gridNamePath:respUserData.gridName,
                    							handler: function(btn){
                    								createColumnWindow(gridClass, btn.recordId, btn.dataGridId, btn.defaultColumns, btn.userDefinedColumns,isWindow,btn.gridNamePath);
                    							}
                    						});
                    						var grid =currentGrid;
                        					var headerCt = grid.headerCt;
                        	                var headerEl = headerCt.el;

                        	                // Create a wrapper div *inside* the headerCt
                        	                var btnWrap = Ext.DomHelper.append(headerEl, {
                        	                    tag: 'div',
                        	                    cls: 'header-action-btn-wrap',
                        	                    style: 'position: absolute; top: 0; right: -3px; z-index: 5; height: 28px;'
                        	                }, true);

                        	                // Create button inside that wrapper
                        	                var addBtn = Ext.create('Ext.Button', {
                        	                    //text: '+',
                        	                    iconCls:'ph ph-columns-plus-right',
                        	                    renderTo: btnWrap,
                        	                    cls:'columnBtnCls',
                        	                    width: 36,
                        	                    height: 40,
                        	                    id:grid.id+'Button',
                        	                    gridClass: gridClass,
                        			            hidden:true,
                        			            defaultColumns: resultGridStoreData,
                        			            userDefinedColumns: responseData,
                        			            recordId: respUserData.id,
                        			            dataGridId: respUserData.dataGridId,
                        			            gridNamePath:respUserData.gridName,
                        	                    style: 'margin-top: 2px;',
                        	                    listeners: {
                        	                        afterrender: function(btn) {
                        	                            Ext.create('Ext.tip.ToolTip', {
                        	                                target: btn.getEl(),
                        	                                title: getCommonTranslation('ADD_COLUMNS'),
                        	                                html: getCommonTranslation('ADD_MORE_COLUMNS'),
                        	                                anchor: 'top',
                        	                                trackMouse: true,
                        	                                width:250,
                        	                                cls: 'column-btn-cls'
                        	                            });
                        	                        }
                        	                    },
                        	                    handler: function (btn) {
                        	                    	createColumnWindow(gridClass, btn.recordId, btn.dataGridId, btn.defaultColumns, btn.userDefinedColumns,isWindow,btn.gridNamePath);
                        	                    }
                        	                });

                        	                // Sync horizontal scroll so button stays in visible header zone
                        	                grid.view.el.on('scroll', function () {
                        	                    var scrollLeft = grid.view.el.dom.scrollLeft;
                        	                    btnWrap.setStyle('right', (-3 - scrollLeft) + 'px');
                        	                });
                    						
                    						currentGrid.config.isGridColumnBtn=respData[0].isVisibleColumn;
                    					}
                    				}else{
                    					if(currentGrid.up('window')){
                    						isWindow=currentGrid.up('window');
                    					}
                    					currentGrid.getHeader().add({
                    				        xtype: 'button',
                    			            text: getCommonTranslation('COLUMNS'), 
                    			            ui: 'CustomBtnSubmit',
                    			            cls:'common-btn-cls',
                    		    			scale: CONSTANTS.BUTTONSIZE,
                    			            gridClass: gridClass,
                    			            hidden:true,
                    			            defaultColumns: resultGridStoreData,
                    			            userDefinedColumns: responseData,
                    			            recordId: respUserData.id,
                    			            dataGridId: respUserData.dataGridId,
                    			            gridNamePath:respUserData.gridName,
                    			            handler: function(btn){
                    			            	createColumnWindow(gridClass, btn.recordId, btn.dataGridId, btn.defaultColumns, btn.userDefinedColumns,isWindow,btn.gridNamePath);
                    			            }
                    				    });
                    					var grid =currentGrid;
                    					var headerCt = grid.headerCt;
                    	                var headerEl = headerCt.el;

                    	                // Create a wrapper div *inside* the headerCt
                    	                var btnWrap = Ext.DomHelper.append(headerEl, {
                    	                    tag: 'div',
                    	                    cls: 'header-action-btn-wrap',
                    	                    style: 'position: absolute; top: 0; right: -3px; z-index: 5; height: 28px;'
                    	                }, true);

                    	                // Create button inside that wrapper
                    	                var addBtn = Ext.create('Ext.Button', {
                    	                    //text: '+',
                    	                    iconCls:'ph ph-columns-plus-right',
                    	                    renderTo: btnWrap,
                    	                    width: 40,
                    	                    height: 40,
                    	                    gridClass: gridClass,
                    			           hidden:true,
                    			          id:grid.id+'Button',
                    			            defaultColumns: resultGridStoreData,
                    			            userDefinedColumns: responseData,
                    			            recordId: respUserData.id,
                    			            dataGridId: respUserData.dataGridId,
                    			            gridNamePath:respUserData.gridName,
                    	                    cls:'columnBtnCls',
                    	                    style: 'margin-top: 2px;',
                    	                    listeners: {
                    	                        afterrender: function(btn) {
                    	                            Ext.create('Ext.tip.ToolTip', {
                    	                                target: btn.getEl(),
                    	                                title: getCommonTranslation('ADD_COLUMNS'),
                    	                                html: getCommonTranslation('ADD_MORE_COLUMNS'),
                    	                                anchor: 'top',
                    	                                trackMouse: true,
                    	                                width:250,
                    	                                cls: 'column-btn-cls'
                    	                            });
                    	                        }
                    	                    },
                    	                    handler: function (btn) {
                    	                    	createColumnWindow(gridClass, btn.recordId, btn.dataGridId, btn.defaultColumns, btn.userDefinedColumns,isWindow,btn.gridNamePath);
                    	                    }
                    	                });

                    	                // Sync horizontal scroll so button stays in visible header zone
                    	                grid.view.el.on('scroll', function () {
                    	                    var scrollLeft = grid.view.el.dom.scrollLeft;
                    	                    btnWrap.setStyle('right', (-3 - scrollLeft) + 'px');
                    	                });
                    	                
                    					currentGrid.config.isGridColumnBtn=respData[0].isVisibleColumn;
                    				}
                    			}
            				}
            			});
    				}
    				}
				});
			}
			/**********Start Code added for clear Report Header data for again new tab open*****/
			if(Ext.isDefined(this.config) && Ext.isDefined(this.config.searchFilterForm)){
				delete this.config.searchFilterForm;
			}
			if(Ext.isDefined(this.config) && Ext.isDefined(this.config.htmlFilter)){
				delete this.config.htmlFilter;
			}
			if(Ext.isDefined(this.config) && Ext.isDefined(this.config.htmlFilterExcel)){
				delete this.config.htmlFilterExcel;
			}
			/**********End Code added for clear Report Header data for again new tab open*****/
			if((this.$className == "Ext.tree.Panel" || this.xtype == "treepanel") && this.titleAlign && this.titleAlign == "left") {
				var me = this;
				me.addCls('left-collapsible-tree');
				Ext.defer(function() {
					var domEl = me.el.dom.querySelector('.x-header-text-container');
					var style = document.createElement('style');
					style.type = 'text/css';
					style.innerHTML = '.x-tree-panel.x-grid .x-header-text-container { width: '+domEl.style.width+' !important;left: '+domEl.style.left+' !important; } .x-tree-panel.x-grid .x-header-text { margin-left: initial !important; }';
					document.getElementsByTagName('head')[0].appendChild(style);
					
					me.on('collapse', function() {
						Ext.defer(function() {
							var domEl = me.reExpander.el.dom.querySelector('.x-header-text-container');
							var style = document.createElement('style');
							style.type = 'text/css';
							style.innerHTML = '.x-tree-panel.x-grid .x-header-text-container { width: '+domEl.style.width+' !important;left: '+domEl.style.left+' !important; }';
							document.getElementsByTagName('head')[0].appendChild(style);
						}, 1);
					});
					me.on('beforeexpand', function() {
							var domEl = me.el.dom.querySelector('.x-header-text-container');
							var style = document.createElement('style');
							style.type = 'text/css';
							style.innerHTML = '.x-tree-panel.x-grid .x-header-text-container { width: '+domEl.style.width+' !important;left: 0px !important; }';
							document.getElementsByTagName('head')[0].appendChild(style);
					});
				}, 1);
			}
			
			/** start - validate filefield and form if filefield's browse button clicked and then cancle button **/
			if(this.xtype == "filefield" && this.allowBlank == false) {
				var fileField = this;
				fileField.on('boxready', function() {
					Ext.defer(function() {
						var inputEl = fileField.getEl().down('input[type=file]').dom;
						document.getElementById(inputEl.id).addEventListener('change', function(event) {
						// Check if files were selected
							if (event.target.files.length === 0) {
								fileField.up('form').isValid();
								fileField.clearInvalid();
							}
						});
					}, 500);
					fileField.button.on('click', function() {
						fileFieldInterval = setInterval(fileFieldTimer, 100);
						function fileFieldTimer() {
							if(fileField.up('form') && !fileField.up('form').isValid()) {
								fileField.up('form').getForm().checkValidity();
								fileField.clearInvalid();
								myStopFunction();
							}
						}

						function myStopFunction() {
							clearInterval(fileFieldInterval);
						}
					});
					fileField.button.setUI('browse-file-btn');
				});
			}
			/** end - validate filefield and form if filefield's browse button clicked and then cancle button **/
		if(this.xtype == "filefield" && this.buttonOnly == true) {
				var fileField = this;
				fileField.button.setUI('browse-file-btn');
					Ext.defer(function() {
						var inputEl = fileField.getEl().down('input[type=file]').dom;
						document.getElementById(inputEl.id).addEventListener('change', function(event) {
						// Check if files were selected
							if (event.target.files.length === 0) {
								fileField.up('form').isValid();
								fileField.clearInvalid();
								try {
                                    if(fileField.buttonOnly == true) {
                                    	var profileUploadWindow = fileField.up('window');
                                        var profileImage = profileUploadWindow.down('image');
                                    	 // **Restore the last saved image instead of the default**
                                        if (profileUploadWindow.lastSavedImageUrl) {
                                            profileImage.setSrc(profileUploadWindow.lastSavedImageUrl);
                                        } else {
                                            profileImage.setSrc('resources/images/default-profile.png');
                                        }
                                        fileField.up('window').down('#btnSaveItemId').setDisabled(true);
                                    }
                                }
                                catch (e) {}
							}
						});
					}, 500);
			}
			if(this.xtype == 'settingCombo' || this.xtype == 'customcombobox' || this.xtype == 'combobox' || this.xtype == 'combo' || this.xtype == 'multiselectcombofield' || this.xtype == 'groupingcombobox' || this.xtype == 'nestedJsonCombo'  || this.xtype == 'timefield') {
				if(this.triggerCls == 'x-form-search-trigger') {
					return;
				}
				var trigger = this.getEl().down('.x-form-trigger');
				if(this.xtype == 'multiselectcombofield') {
					trigger = this.getEl().down('.x-trigger-index-1');
				}
	            if (trigger) {
	                trigger.addCls('ph ph-caret-down');
	                // Reapply class on mouseover
	                trigger.on('mouseover', function () {
	                	if (!trigger.hasCls('ph')) {
	                		trigger.addCls('ph');
	                	}
	                });
	            }
			}
			if(Ext.isDefined(this) && Ext.isDefined(this.xtype) && this.xtype == 'fieldset' && this.title == getTransportTranslation('MORE_FILTERS')){
				this.addCls('more-filters-fieldset');
			}
		}
		catch(e){
			
		}
		try{
			this.callParent(arguments);
		}
		catch(e){
			
		}
		this.on('afterlayout', function(cmp){
			 var comp = cmp;

		        if (comp.hasCls && comp.hasCls('x-form-fixed-footer-parent')) {
		            var footer = comp.el && comp.el.down('.form-fixed-footer');
		            if (!footer) {
		                return;
		            }

		            var contentPanel = comp.up('contentpanel');
		            if (contentPanel && contentPanel.getActiveTab) {
		                var activeTab = contentPanel.getActiveTab();
		                if (activeTab) {
		                    footer.setStyle({
		                        left: comp.getPosition()[0] + 'px',
		                        width: activeTab.getWidth() + 'px'
		                    });
		                }
		            }
		        }
		})
	}
});

Ext.override(Ext.container.Container, {
    afterRender: function () {
        this.callParent(arguments);
        if (this.cls === 'customSearchPanel' && isNullOrEmpty(this.isRemoveToggleButton)) {
        	
        	var parent = this.up('[cls=customSearchPanel]') // find nearest ancestor with that class

            if (parent) {
                // Parent already has the same class → remove from current item
                this.removeCls('customSearchPanel');
            	//this.addCls('noPaddingCustomSearchPanel');
                return; // stop further execution
            }
            
            var panel = this;
            var originalHeight = panel.getHeight();
            var originalItems = panel.items.items.slice(); // shallow copy
            var summaryEl;
            
            Ext.defer(function () {
            	if(!isNullOrEmpty(panel.form)){
            		var hasDownloadForm = panel.getForm().findField('downloadUploadTemplate');
            		var hasDownloadFormBulkTransfer = panel.getForm().findField('downloadUploadTemplate1');
            	    if (hasDownloadForm || hasDownloadFormBulkTransfer) {
            	    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading'); 
                        setTimeout(function(){
                        	 panel.addCls('downloadFormHeightRemoveCls');
                        	 Ext.getBody().unmask();
                 	        return; // Do NOT create toggle button
                        },500);
            	    }else{
            	    	 var toggleEl = Ext.DomHelper.append(panel.body, {
                             tag: 'div',
                             cls: 'filter-toggle-button',
                             html: '<i class="ph ph-caret-up"></i>'
                         }, true);

                         var isSummary = false;

                         toggleEl.on('click', function () {
                         	var innerCt = panel.getEl().down('#' + panel.id + '-innerCt');
                             var outerCt = panel.getEl().down('#' + panel.id + '-outerCt');
                             if (!isSummary) {
                                 // → Enter Summary Mode
                                 var form = panel.getForm ? panel.getForm() : null;
                                 if (!form) return;

                                 // Save form height
                                 originalHeight = panel.getHeight();

                                 // Hide all items (fields/buttons)
                                 /*panel.items.each(function(item) {
                                     item.hide();
                                 });*/
                                 
                                 if (innerCt) {
                                 	innerCt.hide(); // hide the wrapper
                                 	innerCt.setStyle('display', 'none');
                                 	panel.addCls('customSearchPanelCollapsed');
                                 	panel.removeCls('customSearchPanelExpand');
                                 }
                                 
                                 // Remove inline height from outerCt to prevent conflicts
                                 if (outerCt) {
                                     outerCt.setStyle('height', 'auto');
                                 }

                                 // Create and show summary HTML
                                 summaryEl = Ext.DomHelper.append(panel.body, {
                                     tag: 'div',
                                     cls: 'summary-wrapper',
                                     html: generateSummaryHTML(panel)
                                 }, true);
                                 
                                 // Attach handler for Clear All button
                                 summaryEl.select('.filterClearAllBtnCls').on('click', function () {
                                     handleClearAllClick(panel, toggleEl);
                                 });
                                 
                                 summaryEl.select('.summary-pill').on('click', function (evt) {

         						    var t = evt.getTarget();
         						    var pill = Ext.fly(t).hasCls('summary-pill') ? Ext.fly(t) : Ext.fly(t).up('.summary-pill');
         						
         						    if (!pill) return;
         						
         						    var fieldName = pill.dom.getAttribute('data-fieldname');
         						
         						    toggleEl.dom.click(); // expand back
         						
         						    Ext.defer(function () {
         						        var fld = panel.getForm().findField(fieldName);
         						        if (!fld) return;
         						
         						        var fs = fld.up('fieldset[collapsible=true]');
         						        if (fs && fs.collapsed) {
         						
         						            fs.expand();
         						
         						            Ext.defer(function () {
         						                fld.focus();
         						            }, 150);
         						
         						        } else {
         						            fld.focus();
         						        }
         						    }, 50);
         						});
                                 

                                 panel.on('afterlayout', function () {
                                     var maxSearchPanelWidth = contentPanel.getWidth()-64;
                                     if(!panel.isMinWidthNotRequired){
                                    	 panel.getEl().setStyle('min-width', maxSearchPanelWidth + 'px');
                                     }
                                	
                                	 panel.getEl().setStyle('max-width', maxSearchPanelWidth + 'px');
                                	 panel.body.el.setStyle('width', maxSearchPanelWidth + 'px');
                                 });
                                 panel.setHeight(108); // adjust as needed
                                 //panel.getEl().setStyle('min-width', maxSearchPanelWidth+'px');
                                 //panel.getEl().setStyle('max-width', maxSearchPanelWidth+'px');
                                 
                                 toggleEl.update('<i class="ph ph-caret-down"></i>');
                             } else {
                                 // → Return to Normal Mode
                                 if (summaryEl) summaryEl.remove();
                                 Ext.util.CSS.removeStyleSheet("customSearchPanelExpandStyle");
                                 Ext.util.CSS.createStyleSheet(
                                 		".customSearchPanelExpand{ height:" + originalHeight + "px !important; }",
                                 		"customSearchPanelExpandStyle"
                                 );


                                 /*panel.items.each(function(item) {
                                     item.show();
                                 });*/
                                 if (innerCt) {
                                 	innerCt.show(); // restore wrapper
                                 	innerCt.setStyle('display', 'table-cell');
                                 	panel.removeCls('customSearchPanelCollapsed');
                                 	panel.addCls('customSearchPanelExpand');
                                 }

                                 panel.setHeight(originalHeight);
                                 toggleEl.update('<i class="ph ph-caret-up"></i>');
                                 adjustFormHeight(panel);
                             }

                             isSummary = !isSummary;
                         });
                         
                         /*var searchBtn = panel.down('button[text=' + getCommonTranslation('SEARCH') + ']');
                         if (searchBtn) {
                             searchBtn.on('click', function () {
                                 if (!isSummary) {
                                     toggleEl.dom.click(); // Trigger toggle to summary
                                 }
                             });
                         }*/
                         
                         var searchBtns = Ext.Array.filter(panel.query('button'), function (btn) {
                     	    return btn.ui && (
                     	        Ext.String.startsWith(btn.ui, 'CustomBtnSubmit') ||
                     	        Ext.String.startsWith(btn.ui, 'CustomBtnThird')
                     	    );
                     	});

                         Ext.Array.forEach(searchBtns, function (btn) {
                             btn.on('click', function () {
                                 if (!isSummary) {
                                     toggleEl.dom.click(); // Trigger toggle to summary
                                 }
                             });
                         });
                         Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading'); 
                         toggleEl.dom.click();
                         toggleEl.dom.click();
                         setTimeout(function(){
                         	 Ext.getBody().unmask();
                             adjustFormHeight(panel);
                             
                             // Attach listeners to all fieldsets to recalc height on collapse/expand
                             panel.query('fieldset[collapsible=true]').forEach(function(fs) {
                                 fs.on('collapse', function() { adjustFormHeight(panel); });
                                 fs.on('expand', function() { adjustFormHeight(panel); });
                             });
                             
                         },1000);
            	    }
            	}  
            }, 10);
        }
    }
});

/* Overridden the ajax request timeout */
Ext.override(Ext.data.proxy.Ajax, { timeout: CONSTANTS.AJAX_TIMEOUT });

Ext.override(Ext.form.field.Base, {
    msgTarget: 'under',
    labelSeparator: '',
    initComponent: function () {
        var me = this;
        me.callParent(arguments);

        me.on('errorchange', function (field, msg) {
            // Remove existing tooltip if any
            if (field.inputEl && field.inputEl.tooltip) {
                field.inputEl.tooltip.destroy();
                field.inputEl.tooltip = null;
            }

            // If there's an error, attach tooltip
            if (msg && field.inputEl) {
                field.inputEl.tooltip = Ext.create('Ext.tip.ToolTip', {
                    target: field.errorEl,
                    cls:'error-field-tooltip',
                    html: msg,
                    trackMouse: true,
                    dismissDelay: 0 // stays while hovering
                });
            }
        });
    }
});

/* Overridden the combo field and added a matchFieldWidth. Whether the picker dropdown's width should be explicitly set to match the width of the field */
/* validates combobox selected value */
Ext.override(Ext.form.field.ComboBox, {
	matchFieldWidth : false,
	triggerCls: 'ph-caret-down',
	listConfig: {
		listeners: {
			beforeshow: function(picker) {
				picker.minWidth = picker.up('combobox').getSize().width;
			}
		}
	},
	validateValue : function(value) {
		if(this.xtype == 'multiselectcombofield') {
			if(this.hasFocus && this.allowBlank == false) {
				var errs = this.getErrors(value);

				if((value || value != "")){
					var val = this.getValue();
					for(var i = 0;i < val.length; i++) {
						var rec;
						if(typeof val[i] == 'object' && val[i] != "") {
							rec = this.findRecord(this.valueField, val[i].data[this.valueField]);
						}
						else {
							if(val[i] != "") {
								rec = this.findRecord(this.valueField, val[i]);								
							}
						}

						if(!rec)
							errs.push("Invalid Selection"); 
					}
				}

				var error = errs[0];

				if (error == undefined) {
					this.clearInvalid();
					return true;
				} else {
					this.markInvalid(error);
					return false;
				}
			}
			else if(this.allowBlank == true) {
				return true;
			}
			else if(this.allowBlank == false && Ext.isEmpty(value)) {
				return false;
			}
			else if(this.allowBlank == false && !Ext.isEmpty(value)) {
				var rawVal = this.processRawValue(this.getRawValue());
				var errs = this.getErrors(rawVal),
		          	errCount = Ext.isEmpty(errs);
		        if (!this.preventMark) {
		            if (errCount) {
		                this.clearInvalid();
		            }
		            else {
		                this.markInvalid(errs);
		            }
		        }
		        return errCount;
				//return true;
			}
		}
		else if(this.hasFocus && this.allowBlank == false) {
			var errs = this.getErrors(value);

			if((value || value != "")){
				var val = this.getRawValue();
				if(this.xtype == 'livesearchcombo' && this.lastSelection[0]) {
                    val = this.lastSelection[0].get('value');
                }
				var rec = this.findRecord(this.displayField, val);
				if(!rec && !isNaN(parseInt(val))) {
					rec = this.findRecord(this.displayField, parseInt(val));
				}
				if(this.xtype == "timefield"){
					if(this.minValue){
						var time = this.minValue.getTime();
						if(this.getValue()){
							var currentTime = this.getValue().getTime();
							if(currentTime<time){
								this.markInvalid('The time in this field  must be equal to or after '+timeRender(this.minValue.getTime()));
								return false;
							}else{
								this.clearInvalid();
								return true;
							}
						}else{
								this.markInvalid('Not a valid time');
								return false;
						}
					}else{
						this.clearInvalid();
					}
					return true;
				}
				if(!rec)
					errs.push("Invalid Selection"); 
			}

			var error = errs[0];

			if (error == undefined) {
				this.clearInvalid();
				return true;
			} else {
				this.markInvalid(error);
				return false;
			}
		}
		else if(this.allowBlank == true) {
			if(this.xtype == "timefield"){
				if(this.minValue){
					var time = this.minValue.getTime();
					if(this.getValue()){
						var currentTime = this.getValue().getTime();
						if(currentTime<time){
							this.markInvalid('The time in this field  must be equal to or after '+timeRender(this.minValue.getTime()));
							return false;
						}else{
							this.clearInvalid();
							return true;
						}
					}else{
						if(this.getRawValue()){
							this.markInvalid('Not a valid time');
							return false;
						}
					}
				}else{
					this.clearInvalid();
				}
				return true;
			}else{
				return true;
			}
		}
		else if(this.allowBlank == false && Ext.isEmpty(value)) {
			return false;
		}
		else if(this.allowBlank == false && !Ext.isEmpty(value)) {
			return true;
		}
	}
});

Ext.override(Ext.form.field.Date, {
	submitFormat:CONSTANTS.NEW_SUBMIT_DATE_FORMAT,
    initComponent: function () {
        this.callParent(arguments);
        
        if (this.vtype === 'daterange') {
            this.on('change', function (field, newValue) {
                var form = field.up('form');
                if (!newValue) {
                    if (field.startDateField) {
                        var start = form.down('datefield#' + field.startDateField);
                        if (start) {
                            start.setMaxValue(null);
                            start.validate();
                        }
                    }
                    if (field.endDateField) {
                        var end = form.down('datefield#' + field.endDateField);
                        if (end) {
                            end.setMinValue(null);
                            end.validate();
                        }
                    }
                }
            });
        }
    }
});

/* Overridden the display field to set max Length text */
Ext.override(Ext.form.field.Display, {
	listeners:{
		render : function(me,eOpts){
			if(me.name=="smsDiscriptionNotice"){
				var maxLength = localStorage.getItem('maxLength');
				me.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+maxLength+'/'+maxLength+'</span>');
			}
		}
	}
});

Ext.override(Ext.form.field.File, {
	initComponent: function () {
        this.cls = (this.cls || '') + ' x-filefield-cls';
        this.callParent(arguments);
    },
	listeners:{
		change : function(field, value, eOpts){
			try{
				var filename = value.replace(/^.*[\\\/]/, '');
				if(!isValidFile(filename)){
					field.reset();
					return false;
				}
			}
			catch(e){
				//error
			}
		}
	}
});

/* Overridden the text Area to set max Length */
Ext.override(Ext.form.field.TextArea, {
	enforceMaxLength :true,
	listeners:{
		render : function(me,eOpts){
			if(me.name=="smsDiscription"){
				var maxLength = localStorage.getItem('maxLength');
				me.maxLength = maxLength;
				me.el.dom.children[0].children[0].children[0].children[1].maxLength = maxLength;
			}
		}
	}
});

/* Overridden the text field to set max Length */
Ext.override(Ext.form.field.Text, {
	maxLength : 255,
	enforceMaxLength :true,
	initComponent: function () {
		if(this.xtype == 'textfield' || this.xtype =='textarea' || this.xtype =='textareafield') {
			this.cls = (this.cls || '') + ' x-textfield-cls';
		}
		if(this.xtype == 'customcombobox' || this.xtype =='combo' || this.xtype =='combobox' || this.xtype =='multiselectcombofield') {
			this.cls = (this.cls || '') + ' x-combofield-cls';
		}
		if(this.xtype == 'datefield'){
			this.cls = (this.cls || '') + ' x-datefield-cls';
		}
        this.callParent(arguments);
    },
	listeners:{
		blur : function(){
			if(this.xtype =='textfield' || this.xtype =='textarea' || this.xtype =='textareafield'){
				var str = this.getValue();
				if(!isNullOrEmpty(str)){
					str = str.replace(/\s{2,}/g, ' ');
					this.setValue(str.trim());				
				}
			}
		}
	}
});

Ext.override(Ext.form.FieldContainer, {
	labelSeparator: '',
	initComponent: function () {
		this.callParent(arguments);

		// Re-check when child items change visibility
		this.on('afterlayout', this.checkHiddenItems, this);
	},
	afterRender: function () {
		this.callParent(arguments);

		// Only apply to our footer container
		if (this.hasCls && this.hasCls('form-fixed-footer')) {
			if (this.items && this.items.items.length > 1) {

				var buttons = this.items.items.slice().reverse(); // copy & reverse
				this.removeAll(false); // remove without destroying
				this.add(buttons);

				this.updateLayout();
			}
		}

		// Only apply to our footer container
		if (this.hasCls && this.hasCls('customSearchPanelBtnsFieldContainerCls')) {
			if (this.items && this.items.items.length) {
				var buttons = this.items.items.slice().reverse(); // copy & reverse
				this.removeAll(false); // remove without destroying

				// Insert a flex container at 0th position
				this.add({
					xtype: 'container',
					flex: 1
				});

				this.add(buttons);

				// Search buttons: CustomBtnSubmit + CustomBtnThird
				var searchBtns = Ext.Array.filter(this.query('button'), function (btn) {
					return btn.ui && (
							Ext.String.startsWith(btn.ui, 'CustomBtnSubmit') ||
							Ext.String.startsWith(btn.ui, 'CustomBtnThird')
					);
				});

				var resetBtns = Ext.Array.filter(this.query('button'), function (btn) {
					return btn.ui && Ext.String.startsWith(btn.ui, 'CustomBtnCancel');
				});

				Ext.Array.forEach(searchBtns, function (btn) {
					btn.setIconCls('ph ph-arrow-counter-clockwise');
				});

				Ext.Array.forEach(resetBtns, function (btn) {
					btn.setIconCls('ph ph-x');
				});

				this.updateLayout();
			}
		}

		var parentPanel = this.up('[cls=customSearchPanel]');
		if (!parentPanel) return;
	},
	 checkHiddenItems: function () {
	        var me = this,
	            allHidden = true;

	        if (!me.rendered || !me.el) {
	            return;
	        }

	        me.items.each(function (item) {
	            if (!item.hidden) {
	                allHidden = false;
	                return false;
	            }
	        });

	        if (allHidden) {
	            me.setVisible(false);
	        } else {
	            me.setVisible(true);
	        }
	    },
	    onAdd: function () {
	        this.callParent(arguments);
	        this.checkHiddenItems();
	    },
	    onRemove: function () {
	        this.callParent(arguments);
	        this.checkHiddenItems();
	    }
});

Ext.override(Ext.form.Panel, {
    afterRender: function () {
        this.callParent(arguments);

        var form = this;
        if (form.xtype.includes('upload') || form.xtype.includes('download')) {
            form.addCls('customSearchInnerPanel');
        }

        // Defer to ensure all items are rendered
        Ext.defer(function () {
            // All fields including radiogroup and fields inside fieldcontainer
            var allFields = form.query('field, fieldcontainer, radiogroup');

            Ext.Array.forEach(allFields, function (field) {
                var xtype = field.getXType();

                // Process fieldcontainers and radiogroups specially
                if ((xtype === 'fieldcontainer' || xtype === 'radiogroup') && Ext.isFunction(field.getWidth)) {

                    // Recursively process child fields
                    var innerFields = field.query('field');
                    Ext.Array.forEach(innerFields, function (childField) {
                        applyFieldFormatting(childField);
                    });
                } else {
                    applyFieldFormatting(field);
                }
            });

            function applyFieldFormatting(field) {
                var xtype = field.getXType();
                
             // for individual radio && checkboxfield items
                if ((xtype === 'radiofield' || xtype === 'checkboxfield') && Ext.isFunction(field.getWidth)) {
                	var parentLabel = field.up().fieldLabel;
                	if (parentLabel) {
                		var plainLabel = parentLabel.replace(/<\/?[^>]+(>|$)/g, "").replace(/\*/g, "").trim();

                		if(parentLabel && parentLabel.indexOf('ellipsisFieldLabelCls') === -1){
                			var plainLabel = parentLabel ? parentLabel.replace(/<\/?[^>]+(>|$)/g, "").replace(/\*/g, "").trim() : "";
                			var label = '<span title="'+plainLabel+'">'+ parentLabel +'</span>' || '';
                		}
                		else{
                			var label = parentLabel || '';
                		}
                		var helpTextTitle = label;

                		// Add red asterisk for required fields
                		if (field.allowBlank === false && label.indexOf('*') === -1 && !isNullOrEmpty(label)) {
                			label += ' <span class="required" style="color:red">*</span>';
                		}

                		field.up().setFieldLabel(label);
                	}
                }

            	// for individual checkbox
                if (xtype === 'checkbox' && Ext.isFunction(field.getWidth)) {
                	var parentLabel = field.boxLabel;
                	if (parentLabel) {
                		var plainLabel = parentLabel.replace(/<\/?[^>]+(>|$)/g, "").replace(/\*/g, "").trim();

                		if(field.boxLabel && field.boxLabel.indexOf('ellipsisFieldLabelCls') === -1){
                			var plainLabel = field.boxLabel ? field.boxLabel.replace(/<\/?[^>]+(>|$)/g, "").replace(/\*/g, "").trim() : "";
                			var label = '<span title="'+plainLabel+'">'+field.boxLabel+'</span>' || '';
                		}
                		else{
                			var label = field.boxLabel || '';
                		}
                		var helpTextTitle = label;

                		// Add red asterisk for required fields
                		if (field.allowBlank === false && label.indexOf('*') === -1 && !isNullOrEmpty(label)) {
                			label += ' <span class="required" style="color:red">*</span>';
                		}
                		field.setBoxLabel(label);
                	}
                }

                // Skip radiofield and checkboxfield and checkbox
                if ((xtype !== 'radiofield' && xtype !== 'checkboxfield') && Ext.isFunction(field.getWidth)) {
                    if(field.fieldLabel && field.fieldLabel.indexOf('ellipsisFieldLabelCls') === -1 && !field.noEllipses){
                    	var plainLabel = field.fieldLabel ? field.fieldLabel.replace(/<\/?[^>]+(>|$)/g, "").replace(/\*/g, "").trim() : "";
                        var label = '<span class="ellipsisFieldLabelCls" title="'+plainLabel+'">'+field.fieldLabel+'</span>' || '';
                    }
                    else{
                    	var label = field.fieldLabel || '';
                    }
                	var helpTextTitle = label;

                 // Add red asterisk for required fields
                    if (field.allowBlank === false && label.indexOf('*') === -1 && !isNullOrEmpty(label)) {
                        label += ' <span class="required" style="color:red">*</span>';
                    }

                    // Add help icon if applicable
                    if (field.isHelpText === true && !isNullOrEmpty(field.helpTextToShow) && !field._helpIconAdded) {
                        var helpId = Ext.id(); // Unique ID for tooltip target
                        label += ' <span id="' + helpId + '" class="ph ph-question labelHelpTextCls"></span>'; // Unicode circled 'i'

                        // Defer tooltip creation to ensure the element is rendered
                        Ext.defer(function () {
                            var el = Ext.fly(helpId);
                            if (el) {
                                Ext.create('Ext.tip.ToolTip', {
	                                target: helpId,
	                                title: helpTextTitle,
	                                html: field.helpTextToShow,
	                                anchor: 'top',
	                                trackMouse: true,
	                                cls: 'column-btn-cls'
	                            });
                            }
                        }, 50);
                        
                        field._helpIconAdded = true; // Flag to prevent duplication
                    }

                    field.setFieldLabel(label);
                }
            }
            
            if(form && form.el){
                form.el.unmask();
            }

            var buttons = form.query('button');

            Ext.Array.forEach(buttons, function (btn) {
                var text = btn.text && btn.text.toUpperCase();
                if (btn.ui === 'CustomBtnSubmit-small' && getCommonTranslation(text).toUpperCase() !== getCommonTranslation('SEARCH').toUpperCase() && getCommonTranslation(text).toUpperCase() !== getCommonTranslation('RESET').toUpperCase()) {
                    btn.addCls('download-upload-template-btn');
                }
            });
        }, 10); // slight defer to wait for render
    }
});

/* checkcolumn override for click event to be work on checkbox only */
Ext.override(Ext.grid.column.CheckColumn, {
	processEvent: function(type1, view, cell, recordIndex, cellIndex, e, record, row) {
        var me = this,
            key = (type1 === 'keydown' && e.getKey()),
            mousedown = (type1 == 'mousedown');

        if (mousedown && !Ext.fly(e.getTarget()).hasCls('x-grid-checkcolumn')) {
            return !me.stopSelection;
        }

        me.callParent([type1, view, cell, recordIndex, cellIndex, e, record, row]);
    }
});

/* This Section Add For Customize Sorting Order Of Grid Column */
Ext.override(Ext.grid.column.Column, {
	// Automatically size column to fit header text after rendering
	afterRender: function () {
	    this.callParent(arguments);

	    var me = this;
	    setTimeout(function () {
	        try {
	            var grid = me.up('gridpanel');
	        } catch (e) {
	            return;
	        }

	        if (!grid || !grid.view || !grid.view.el) return;
	        
	        if(grid.isFixWidthColums){
	        	return;
	        }

	        var allCols = grid.headerCt.getGridColumns();
	        var visibleCols = Ext.Array.filter(allCols, function (col) {
	            return !col.hidden;
	        });

	        // --- Auto-size current column ---
	       // me.flex = null;
	       // delete me.flex;

	       // me.setWidth(null); // remove any previously set width
	        me.autoSize(false); // resize to header text
	        var paddedWidth = 0;
	        var getOriginalWidth = 0;
	        if(me.getWidth() == 0){
	        	 getOriginalWidth = me.width;
	        	  paddedWidth = getOriginalWidth + 58;
	        }else{
	        	 getOriginalWidth = me.getWidth();
	        	 paddedWidth = getOriginalWidth + 20;
	        }
	        
	       

	        // Apply minWidth except for check columns
	        var minWidth = (me.isCheckerHd) ? getOriginalWidth : 100;
	        if (paddedWidth < minWidth) paddedWidth = minWidth;
	        me.setWidth(paddedWidth);

	        // --- Handle remaining space across ALL visible columns ---
	        if (visibleCols[visibleCols.length - 1] === me) {
	            var totalColWidth = 0;
	            Ext.Array.forEach(visibleCols, function (col) {
	                if (col && col.el && col.getWidth) {
	                    totalColWidth += col.getWidth() == 0 ? col.width : col.getWidth();
	                }
	            });

	            var gridWidth = grid.view.el.getWidth() == 0 ? 1200 : grid.view.el.getWidth();
	            var remaining = gridWidth - totalColWidth;

	            if (remaining > 0) {
	                var distributableCols = Ext.Array.filter(visibleCols, function (col) {
	                    return !col.isCheckerHd; // don’t stretch check column
	                });

	                var extraPerCol = Math.floor(remaining / distributableCols.length);

	                Ext.Array.forEach(distributableCols, function (col, idx) {
	                    var newWidth = col.getWidth() == 0 ? col.width + extraPerCol : col.getWidth() + extraPerCol;

	                    // Give last distributable col any leftover pixels
	                    if (idx === distributableCols.length - 1) {
	                        newWidth += remaining - (extraPerCol * distributableCols.length);
	                    }

	                    col.minWidth= newWidth;
	                    col.flex=1;
	                });
	            }
	        }
	    }, 50); // delay to let layout settle
	},
	doSort : function(state) {
		var ds = this.up('grid').store;
		var field = this.getSortParam();
		var grid = this.up('grid');
		if(ds.sorters.length){
			var oldIndex;
			var dataIndex = ds.sorters.keys[0];
			var gridColumns = this.up('grid').columns;
			for (oldIndex = 0; oldIndex < gridColumns.length; ++oldIndex) {
				if (gridColumns[oldIndex].dataIndex == dataIndex) { break; }
			}
			grid.store.applyState({root: "data", property: "", direction: ""});
			if(!isNullOrEmpty(grid.columns[oldIndex])) {
				grid.columns[oldIndex].setSortState(null);
			}
			grid.store.sorters.clear();
			grid.view.refresh();
		}
		if(Ext.isDefined(grid.getStore()) && Ext.isDefined(grid.getStore().getProxy()) && Ext.isDefined(grid.getStore().getProxy().api) && Object.keys(grid.getStore().getProxy().api).length>0  && grid.getStore().count()>0 && Ext.isDefined(grid.getStore().remoteSort) &&  grid.getStore().remoteSort== true){
			grid.getStore().load({
				callback: function(){
					ds.sort({
						property : field,
						direction : state,
						sorterFn : function(v1, v2) {
							var reA = /[^a-zA-Z]/g;
							var reN = /[^0-9]/g;
							if (!isNullOrEmpty(v1.get(field))
									&& !isNullOrEmpty(v2.get(field))) {
								if (typeof (v1.get(field)) == "string" && typeof (v2.get(field)) == "string") {
									v1 = v1.get(field);
									v2 = v2.get(field);
									var aA = v1.replace(reA, "");
									var bA = v2.replace(reA, "");
									if(aA.toLowerCase() === bA.toLowerCase()) {
										var aN = parseInt(v1.replace(reN, ""), 10);
										var bN = parseInt(v2.replace(reN, ""), 10);
										return aN === bN ? 0 : aN > bN ? 1 : -1;
									} else {
										return aA.toLowerCase() > bA.toLowerCase() ? 1 : -1;
									}
								}else if (typeof (v1.get(field)) == "object" && typeof (v2.get(field)) == "object") {
									v1 = v1.get(field).value;
									v2 = v2.get(field).value;
									if (!isNullOrEmpty(v1)
											&& !isNullOrEmpty(v2)) {
										var aA = v1.replace(reA, "");
										var bA = v2.replace(reA, "");
										if(aA.toLowerCase() === bA.toLowerCase()) {
											var aN = parseInt(v1.replace(reN, ""), 10);
											var bN = parseInt(v2.replace(reN, ""), 10);
											return aN === bN ? 0 : aN > bN ? 1 : -1;
										} else {
											return aA.toLowerCase() > bA.toLowerCase() ? 1 : -1;
										}
									}
								} else {
									v1 = v1.get(field);
									v2 = v2.get(field);
									return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
								}
							} else {
								if (isNullOrEmpty(v1.get(field))) {
									v1.set(field, '');
								}
								if (isNullOrEmpty(v2.get(field))) {
									v2.set(field, '');
								}
								v1 = v1.get(field);
								v2 = v2.get(field);
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						}
					});
					
				}
			});
		}
		else{
			ds.sort({
				property : field,
				direction : state
			});
		}
	}
});

Ext.override(Ext.grid.header.Container, {
	getMenuItems :function(){
		   var me = this,
           menuItems = [],
           hideableColumns = me.enableColumnHide ? me.getColumnMenu(me) : null;

       if (me.sortable) {
           menuItems = [{
               itemId: 'ascItem',
               text: getCommonTranslation("SORT_ASCENDING"),
               cls: me.menuSortAscCls,
               handler: me.onSortAscClick,
               scope: me
           },{
               itemId: 'descItem',
               text: getCommonTranslation("SORT_DESCENDING"),
               cls: me.menuSortDescCls,
               handler: me.onSortDescClick,
               scope: me
           }];
       }
       if (hideableColumns && hideableColumns.length) {
           if (me.sortable) {
               menuItems.push('-');
           }
           menuItems.push({
               itemId: 'columnItem',
               text: getCommonTranslation('COLUMNS'),
               cls: me.menuColsIcon,
               menu: hideableColumns,
               hideOnClick: false
           });
       }
       return menuItems;
	},
	getMenu: function() {
        var menu = this.callParent(arguments);
        menu.addCls('grid-column-menu');
        return menu;
    },
    afterRender: function() {
        this.callParent(arguments);
        this.on('menucreate', function(headerCt, menu) {
            menu.on('beforeshow', function(m) {
                Ext.Array.each(m.items.items, function(item) {
                    if (item.menu) {
                        item.menu.addCls('grid-column-sub-menu');
                    }
                });
            });
        });
    }
});

/*Ext.override(Ext.grid.Panel, {
    titleAlign: 'center',
    reserveScrollbar: true,
    minHeight: 300,
    scrollable: {
        x: 'scroll',
        y: 'scroll'
    },
    viewConfig: {
        emptyText: ' ',
        deferEmptyText: false
    },
    autoScroll: true,

    initComponent: function () {
        var me = this;
        me.callParent(arguments);

        me.on('afterrender', function () {
            me.bindFormResizeListener();
            me.adjustGridHeight();

            // Hide grid panel header
            var header = me.getHeader && me.getHeader();
            if (header && header.hide) {
                header.hide();
            }

            // Create title component
            var titleComponent = Ext.create('Ext.toolbar.TextItem', {
                text: me.title || '',
                cls: 'gridTitleCls'
            });

            var tbar = me.down('toolbar[dock="top"]');
            if (tbar) {
                tbar.insert(0, titleComponent);
            } else {
                me.addDocked({
                    xtype: 'toolbar',
                    dock: 'top',
                    items: [titleComponent, '->']
                });
            }
        });
    },

    bindFormResizeListener: function () {
        var me = this,
            parent = me.ownerCt,
            formSibling;

        // case 1: form is sibling of grid
        if (parent) {
            formSibling = Ext.Array.findBy(parent.items.items, function (item) {
                return item !== me && item.isXType && item.isXType('form');
            });
        }

        // case 2: form is sibling of grid's parent
        if (!formSibling && parent && parent.ownerCt) {
            formSibling = Ext.Array.findBy(parent.ownerCt.items.items, function (item) {
                return item !== parent && item.isXType && item.isXType('form');
            });
        }

        if (formSibling) {
            formSibling.on({
                resize: me.adjustGridHeight,
                collapse: me.adjustGridHeight,
                expand: me.adjustGridHeight,
                scope: me
            });
        }
    },

    adjustGridHeight: function () {
        var me = this,
            menuHolder = Ext.getCmp('menuHolder');

        if (!menuHolder || !me.rendered) {
            return;
        }

        var emptySpace = 10,
            myTop = me.getPosition()[1],
            screenHeight = menuHolder.getHeight() + menuHolder.getPosition()[1],
            calculatedHeight = screenHeight - myTop - emptySpace;

        var finalHeight = Math.max(me.minHeight || 0, calculatedHeight);

        if (me.getHeight() !== finalHeight) {
            me.setHeight(finalHeight);
        }
    }
});*/

Ext.override(Ext.grid.Panel, {
    titleAlign: 'center',
    reserveScrollbar: true,
    minHeight: 300,
    scrollable: {
        x: 'scroll',
        y: 'scroll'
    },
    viewConfig: {
        emptyText: ' ',
        deferEmptyText: false
    },
    autoScroll: true,

    initComponent: function () {
        var me = this;
        me.callParent(arguments);

        me.on('afterrender', function () {
            me.bindFormResizeListener();

            // Always bind to window resize as fallback (for cases with no filter form)
            Ext.EventManager.onWindowResize(me.adjustGridHeight, me);

            // Initial adjustment
            Ext.defer(function(){
                me.adjustGridHeight();
            },500);

            // Hide grid panel header
            var header = me.getHeader && me.getHeader();
            if (header && header.hide) {
                header.hide();
            }

            // Create title component
            var titleComponent = Ext.create('Ext.toolbar.TextItem', {
                text: me.title || '',
                cls: 'gridTitleCls'
            });

            var tbar = me.down('toolbar[dock="top"]');
            if (tbar) {
                tbar.insert(0, titleComponent);
            } else {
                me.addDocked({
                    xtype: 'toolbar',
                    dock: 'top',
                    items: [titleComponent, '->']
                });
            }
        });

        me.on('destroy', function () {
            // Cleanup window resize listener
            Ext.EventManager.removeResizeListener(me.adjustGridHeight, me);
        });
        
        me.on('show', function(){
        	var me = this;
        	Ext.defer(function() {
        		if (!me.headerCt || !me.headerCt.items) {
        			return; 
        		}
        		Ext.Array.each(me.headerCt.items.items, function(col) {
        			if (!col || typeof col.afterRender !== 'function') {
        				return;
        			}
        			try {
        				col.afterRender();
        			} catch (e) {

        			}
        		});
        	}, 200);
        });
    },

    bindFormResizeListener: function () {
        var me = this,
            parent = me.ownerCt,
            formSibling;

        // case 1: form is sibling of grid
        if (parent) {
            formSibling = Ext.Array.findBy(parent.items.items, function (item) {
                return item !== me && item.isXType && item.isXType('form');
            });
        }

        // case 2: form is sibling of grid's parent
        if (!formSibling && parent && parent.ownerCt) {
            formSibling = Ext.Array.findBy(parent.ownerCt.items.items, function (item) {
                return item !== parent && item.isXType && item.isXType('form');
            });
        }
        
        if(!formSibling && parent && parent.ownerCt && parent.ownerCt.ownerCt) {
        	formSibling = Ext.Array.findBy(parent.ownerCt.ownerCt.items.items, function (item) {
                return item !== parent && item.isXType && item.isXType('form');
            });
        }

        if (formSibling) {
            formSibling.on({
                resize: me.adjustGridHeight,
                collapse: me.adjustGridHeight,
                expand: me.adjustGridHeight,
                scope: me
            });
        }
    },

    adjustGridHeight: function () {
        var me = this,
            menuHolder = Ext.getCmp('menuHolder');
        
        if(me.isFixHeightGrid){
        	return;
        }

        if (!menuHolder || !me.rendered) {
            return;
        }

        var emptySpace = 10,
            myTop = me.getPosition()[1],
            screenHeight = menuHolder.getHeight() + menuHolder.getPosition()[1],
            calculatedHeight = screenHeight - myTop - emptySpace;

        var finalHeight = Math.max(me.minHeight || 0, calculatedHeight);

        if (me.getHeight() !== finalHeight) {
            me.setHeight(finalHeight);
        }
    }
});

/* Overridden the grid panel, applied for grid row editing like excel */
Ext.override(Ext.grid.plugin.CellEditing,{
	onSpecialKey: function(ed, field, e) {
		Ext.app.gridRendered = true;
		var grid = this.grid,sm;
		if (e.getKey() === e.TAB) {
			e.stopEvent();
			sm = grid.getSelectionModel();
			if (sm.onEditorTab)sm.onEditorTab(this, e);
		}else if(e.getKey() === e.ENTER){
			e.stopEvent();
			sm = grid.getSelectionModel();
			if (sm.onEditorEnter)sm.onEditorEnter(this, e);
		}
	}
});

/* Overridden the grid to set total records */
Ext.override(Ext.grid.View, {
	refresh : function(grid){
		var me = this,
	        hasFocus = me.el && me.el.isAncestor(Ext.Element.getActiveElement());
	
	    me.callParent(arguments);
	    me.headerCt.setSortState();
	
	    // Create horizontal stretcher element if no records in view and there is overflow of the header container.
	    // Element will be transient and destroyed by the next refresh.
	    if (me.el && !me.all.getCount() && me.headerCt && me.headerCt.tooNarrow) {
	        me.el.createChild({style:'position:absolute;height:1px;width:1px;left:' + (me.headerCt.getFullWidth() - 1) + 'px'});
	    }
	
	    if (hasFocus) {
	        me.selModel.onLastFocusChanged(null, me.selModel.lastFocused);
	    }
	    
		var grid = this.up('grid');
		var gridDom = grid.el ? grid.el.dom : null;
		
		if(gridDom){
			 
			try{
				grid.on('hide', function(){
					try{
						Ext.query('.'+this.id)[0].style.display = 'none';
					}
					catch(e){
						//
					}
				});
				grid.on('destroy', function(){
					try{
						Ext.query('.'+this.id)[0].style.display = 'none';
					}
					catch(e){
						//
					}
				});
				grid.on('show', function(){
					try{
						Ext.query('.'+this.id)[0].style.display = '';
					}
					catch(e){
						//
					}
				});
				grid.on('afterlayout', function(curGrid){
					var curGridLeft = curGrid.el.dom.offsetLeft;
					var curGridWidth = curGrid.el.dom.offsetWidth;
					var curGridTop = curGrid.el.dom.offsetTop;
					var curGridHeight = curGrid.el.dom.offsetHeight;
					
					if(Ext.query('.'+curGrid.id).length){
						Ext.query('.'+curGrid.id)[0].style.width = '150px';
						Ext.query('.'+curGrid.id)[0].style.left = (curGridLeft + curGridWidth - 150) + 'px';
						Ext.query('.'+curGrid.id)[0].style['float'] = 'initial';
						Ext.query('.'+curGrid.id)[0].style['top'] = (curGridTop + curGridHeight + 5) + 'px';
						Ext.query('.'+curGrid.id)[0].style.position = 'absolute';
					}
					
					if(curGrid.xtype == 'fileuploadmultipledraganddrop') {
						var manageFileController = Academia.app.getController('Academia.controller.filemanagement.ManageFileController');
					    var fileuploadmultiplegrid = manageFileController.getFileUploadMultipleDragAndDrop();
					    recordCount = fileuploadmultiplegrid.getStore().getCount();
						var gridDom1 = curGrid.el.el ? curGrid.el.el.dom : null;
						if(gridDom1){
						  gridDom1.nextElementSibling.children[0].innerText = getCommonTranslation('TOTAL_RECORDS')+": "+ recordCount;
					    }
					}
					if(curGrid.xtype == 'roleprivilege') {
					    recordCount = curGrid.getStore().getCount();
						var gridDom1 = curGrid.el.el ? curGrid.el.el.dom : null;
						if(gridDom1 && !isNullOrEmpty(gridDom1.nextElementSibling)){
						  gridDom1.nextElementSibling.children[0].innerText = getCommonTranslation('TOTAL_RECORDS')+": "+ recordCount;
					    }
					}
					
					//-- START HERE --- Grid Header Fix issue on tab change (Generic)
						//resetGridHeaderFix(curGrid);
					//-- START HERE --- Grid Header Fix issue on tab change (Generic)
				});
			}
			catch(e){
				//
			}
			
			if(grid.xtype!=="courseparametergrid"){
				if(gridDom.parentNode && (gridDom.parentNode.lastElementChild.className== "gridTotalDivCls")){
					gridDom.parentNode.removeChild(gridDom.parentNode.lastElementChild)
				}
				
				try{
					if(gridDom.parentNode && $('.gridTotalDivCls.'+grid.id).length == 1){
						gridDom.parentNode.removeChild($('.gridTotalDivCls.'+grid.id)[0]);
					}
				}
				catch(e){
					try{
						$('.gridTotalDivCls.'+grid.id)[0].parentNode.removeChild($('.gridTotalDivCls.'+grid.id)[0]);
					}
					catch(ee){
						//--
					}
				}
			}
			
			try{
				if(grid.itemId=="applicationStageBasicSearchGrid" || grid.itemId=="exportAllGrid" || grid.itemId=="d365dashletgrid" || grid.itemId =="enquiryStaticDocumentAttachmentGridMessage"||
					  grid.xtype.indexOf("documentgrid") >= 0 || grid.itemId== "userListGrid" || grid.xtype == "hosteldocument" ||
					  grid.itemId=="userSelectedGrid" || grid.itemId=="programListGrid" || grid.itemId=="programSelectedGrid" || grid.itemId=="courseListGrid"|| 
					  grid.itemId=="courseSelectedGrid" || grid.itemId=="facultyListgrid" || grid.itemId=="facultySelectedgrid" || grid.itemId=="equipmentListGrid"||
					  grid.itemId=="equipmentSelectedGrid" || grid.itemId=="externalResourceListGrid" || grid.itemId=="externalResourceSelectedGrid"||
					  grid.itemId=="studentpassporturlgrid" || grid.itemId=="studentvisaurlgrid" || grid.itemId=="applicantpassporturlgrid"|| grid.itemId=="applicantvisaurlgrid"||
					  grid.itemId=="studenteducationhistoryurlgrid" || grid.itemId=="studentinsuranceurlgrid" || grid.itemId=="applicanteducationhistoryurlgrid" || grid.itemId=="studenthealthinformationurlgrid" || grid.itemId=="applicantinsuranceurlgrid" ||
					  grid.itemId=="applicantlanguagedocdetailgrid" || grid.itemId=="applicantlangurlgrid" ||grid.itemId=="studentlanguagedocumentgrid" ||
					  grid.itemId=="studentlanguageurlgrid" ||grid.itemId=="applicanthealthinformationurlgrid" || grid.xtype=="academictopicdocumenturlgrid" || grid.itemId=="admissionDetailDashletGrid" || grid.itemId=="positiveincidentdocumentgrid" || grid.itemId== 'studentHoldItemId'){
					//--do not show total records here
					try{
						grid.down('#totalRecordDisplayField').hide();
					}
					catch(ex){
						
					}
				}
				else if(grid.isHidden() == false && ($('.gridTotalDivCls.'+grid.id).length == 0)) {
					
					if(grid.xtype!=="courseparametergrid"){
						var totalDiv = document.createElement("div");
						totalDiv.className = "gridTotalDivCls "+grid.id;
						totalDiv.innerHTML = "<span class='totalSpanCls'>"+getCommonTranslation('TOTAL_RECORDS')+": 0</span>";
					}

					if(grid.xtype!=="courseparametergrid"){
						if(gridDom.nextSibling) {
							gridDom.parentNode.insertBefore(totalDiv, gridDom.nextSibling);
						} else {
							gridDom.parentNode.appendChild(totalDiv);
						}
						if(gridDom.style.marginBottom == "0px" || gridDom.style.marginBottom =="" ){
							gridDom.style.marginBottom = "10px";
						}
					}
					if (grid.store.totalCount) {
						if( grid.store.getCount() == 0){
							var recordCount =grid.store.getCount();
						}else{
							var recordCount =grid.store.totalCount;
						}

					}else {
						var recordCount = grid.store.getCount();
					}
					if(grid.itemId == 'sectionGridItemId' || grid.xtype == 'mapprogramoutcomegrid' || grid.xtype == 'paymenttermconfiguredocumentlistgrid' || grid.xtype == 'availableevents' || grid.xtype == 'programbatchsectiongrid'){
						var recordCount =grid.store.getCount();
					}
					if(grid.xtype!=="courseparametergrid"){
						if( recordCount == 0){
							gridDom.nextElementSibling.children[0].innerText = '';
						}else{
							gridDom.nextElementSibling.children[0].innerText = getCommonTranslation('TOTAL_RECORDS')+": "+ recordCount;
						}
						
					}
					else{
						if(recordCount == 0){
							gridDom.nextElementSibling.children[0].children[0].children[0].children[0].children[0].innerText = '';
							
						}else{
							gridDom.nextElementSibling.children[0].children[0].children[0].children[0].children[0].innerText = getCommonTranslation('TOTAL_RECORDS')+": "+ recordCount;	
						}
						}
						if(grid.down('#totalRecordDisplayField')){
							grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ recordCount)
						}
						if(recordCount > 0){
							grid.addCls('removeBackgroundImageCls');
							grid.removeCls('gridHeightCls');
							
						}else{
							grid.removeCls('removeBackgroundImageCls');
							grid.addCls('gridHeightCls');
						}
					grid.doLayout();
				}
			}
			catch(e){
				//--
			}
		}
	}
});

Ext.override(Ext.panel.Panel, {
    afterRender: function () {
        this.callParent(arguments);
        
        // Only apply to our footer container
        if (this.hasCls && this.hasCls('form-fixed-footer')) {
            if (this.items && this.items.items.length > 1) {
            	
            	var buttons = this.items.items.slice().reverse(); // copy & reverse
            	this.removeAll(false); // remove without destroying
            	this.add(buttons);
            	
                this.updateLayout();
            }
        }

        var parentPanel = this.up('[cls=customSearchPanel]');
        if (!parentPanel) return;
        
        Ext.defer(function () {
            var buttons = this.query('button');
            var searchBtn = null, resetBtn = null;

            Ext.Array.forEach(buttons, function (btn) {
                var text = btn.text && btn.text.toUpperCase();
                if (getCommonTranslation(text).toUpperCase() === getCommonTranslation('SEARCH').toUpperCase()) {
                    searchBtn = btn;
                } else if (getCommonTranslation(text).toUpperCase() === getCommonTranslation('RESET').toUpperCase()) {
                    resetBtn = btn;
                } else if (getProgramandcourseTranslation(text).toUpperCase() === getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD').toUpperCase() || getCommonTranslation('DOWNLOAD')) {
                    btn.addCls('download-upload-template-btn');
                } else if (getTranslation(text).toUpperCase() === getTranslation('UPLOAD_DATA').toUpperCase() || getExaminationTranslation(text).toUpperCase() === getExaminationTranslation('CALCULATE_RESULT').toUpperCase() || getCommonTranslation(text) === getCommonTranslation('UPLOAD')) {
                    btn.addCls('download-upload-template-btn');
                }
            });

            if (searchBtn && resetBtn) {
            	// Set icon classes
            	resetBtn.el.setStyle('opacity', '0');
            	searchBtn.el.setStyle('opacity', '0');
                searchBtn.setIconCls('ph ph-arrow-counter-clockwise');
                resetBtn.setIconCls('ph ph-x');
            	
                var btnContainer = searchBtn.ownerCt;
                if (btnContainer && btnContainer.getLayout && btnContainer.getLayout()) {
                    // Move both buttons to right
                    btnContainer.getLayout().pack = 'end';
                    
                    btnContainer.addCls('custom-flex-button-container');

                    // Reorder: RESET first, SEARCH last
                    btnContainer.remove(searchBtn, false);
                    btnContainer.remove(resetBtn, false);
                    btnContainer.add({
                        xtype: 'container',
                        flex: 1
                    });
                    btnContainer.add(resetBtn);
                    btnContainer.add(searchBtn);
                    resetBtn.addCls('x-btn-CustomBtnCancelFilterForm-small');
                    resetBtn.el.setOpacity(1);
                    searchBtn.el.setOpacity(1);
                    btnContainer.doLayout();
                    
                    // Check if previous sibling is collapsible fieldset
                    var fieldContainer = this;
                    var items = parentPanel.items;
                    var index = items.indexOf(fieldContainer);
                    if (index > 0) {
                        var prevItem = items.getAt(index - 1);
                        if (prevItem && prevItem.xtype === 'fieldset' && prevItem.collapsible) {
                            btnContainer.addCls('button-shift-up');
                        }
                    }
                }
            }
            else if (resetBtn) {
            	// Set icon classes
            	resetBtn.el.setStyle('opacity', '0');
            	resetBtn.setIconCls('ph ph-x');
            	
                var btnContainer = resetBtn.ownerCt;
                if (btnContainer && btnContainer.getLayout && btnContainer.getLayout()) {
                    // Move both buttons to right
                    btnContainer.getLayout().pack = 'end';
                    
                    btnContainer.addCls('custom-flex-button-container');

                    // Reorder: RESET first, SEARCH last
                    btnContainer.remove(resetBtn, false);
                    btnContainer.add({
                        xtype: 'container',
                        flex: 1
                    });
                    btnContainer.add(resetBtn);
                    resetBtn.addCls('x-btn-CustomBtnCancelFilterForm-small');
                    resetBtn.el.setOpacity(1);
                    btnContainer.doLayout();
                    
                    // Check if previous sibling is collapsible fieldset
                    var fieldContainer = this;
                    var items = parentPanel.items;
                    var index = items.indexOf(fieldContainer);
                    if (index > 0) {
                        var prevItem = items.getAt(index - 1);
                        if (prevItem && prevItem.xtype === 'fieldset' && prevItem.collapsible) {
                            btnContainer.addCls('button-shift-up');
                        }
                    }
                }
            }
            
            // Apply width = 320 to all direct child fields (skip radio & checkbox)
            var allFields = this.query('field');
            Ext.Array.forEach(allFields, function(field) {
                var xtype = field.getXType();

                // Skip radiofield and checkboxfield
                if (xtype !== 'radiofield' && xtype !== 'checkboxfield' && field.getWidth() != 80 && xtype !='fieldcontainer'  && xtype !='panel') {
                    // Preserve asterisk for required fields
                    if (field.allowBlank === false && field.fieldLabel && field.fieldLabel.indexOf('*') == -1 && !isNullOrEmpty(field.fieldLabel)) {
                        field.setFieldLabel(field.fieldLabel + ' <span class="required" style="color:red">*</span>');
                    } else {
                        field.setFieldLabel(field.fieldLabel);
                    }
                }
            });
        }, 10, this); // Defer to allow DOM/layout to complete
    }
});

Ext.override(Ext.panel.Table, {
	getView: function() {
        var me = this,
            sm;

        if (!me.view) {
            sm = me.getSelectionModel();
            sm.headerWidth = 40;
            
            // TableView injects the view reference into this grid so that we have a reference as early as possible
            Ext.widget(Ext.apply({

                // Features need a reference to the grid, so configure a reference into the View
                grid: me,
                deferInitialRefresh: me.deferRowRender !== false,
                trackOver: me.trackMouseOver !== false,
                scroll: me.scroll,
                xtype: me.viewType,
                store: me.store,
                headerCt: me.headerCt,
                columnLines: me.columnLines,
                rowLines: me.rowLines,
                selModel: sm,
                features: me.features,
                panel: me,
                emptyText: me.emptyText || ''
            }, me.viewConfig));

            // Normalize the application of the markup wrapping the emptyText config.
            // `emptyText` can now be defined on the grid as well as on its viewConfig, and this led to the emptyText not
            // having the wrapping markup when it was defined in the viewConfig. It should be backwards compatible.
            // Note that in the unlikely event that emptyText is defined on both the grid config and the viewConfig that the viewConfig wins.
            if (me.view.emptyText) {
                me.view.emptyText = '<div class="' + me.emptyCls + '">' + me.view.emptyText + '</div>';
            }

            // TableView's custom component layout, Ext.view.TableLayout requires a reference to the headerCt because it depends on the headerCt doing its work.
            me.view.getComponentLayout().headerCt = me.headerCt;

            me.mon(me.view, {
                uievent: me.processEvent,
                scope: me
            });
            sm.view = me.view;
            me.headerCt.view = me.view;
        }
        return me.view;
    }
});

/* Overridden the selection rowmodel timeout */
Ext.override(Ext.selection.RowModel, {
	lastId:null,
	onEditorTab: function(ep, e) {
		me = this,
		view = me.view,
		record = ep.getActiveRecord(),
		header = ep.getActiveColumn(),
		position = view.getPosition(record, header),
		direction = e.shiftKey ? 'left' : 'right',
				newPosition = view.walkCells(position, direction, e, false),
				newId=newPosition.row,
				grid=view.up('gridpanel');
		if(Ext.isDefined(grid)){
		var myInterval = setInterval(function(){
			if(Ext.app.gridRendered){
				if(newPosition.column >= 10){
					deltaX = -Infinity;
					header=grid.headerCt.getHeaderAtIndex(0);
					position = view.getPosition(record, header);
					position.row = position.row+1;
					if(header){
						while(!header.getEditor()){
							position= view.walkCells(position,direction, e, false);
							header=grid.headerCt.getHeaderAtIndex(position.column);
						}
					}
					newPosition = position;
				} else if (me.lastId!=newId && me.lastId!=null){
					deltaX = me.lastId<newId? -Infinity : Infinity;
					header=grid.headerCt.getHeaderAtIndex(newPosition.column);
					if(header){
						while(!header.getEditor()){
							newPosition= view.walkCells(newPosition,direction, e, false);
							header=grid.headerCt.getHeaderAtIndex(newPosition.column);
						}
					}
				} else {
					deltaX = ep.context.column.width * (direction== 'right' ? 1 : -1);
				}
					if(!isNaN(deltaX)){
				grid.scrollByDeltaX(deltaX);
					}
				me.lastId=newPosition.row;
				if (newPosition)ep.startEditByPosition(newPosition);
				else ep.completeEdit();
				Ext.app.gridRendered = false;
				clearInterval(myInterval);
			}
		}, 100);
		}
	},
	onEditorEnter:function(ep,e){
		var me = this,
		view = me.view,
		record = ep.getActiveRecord(),
		header = ep.getActiveColumn(),
		position = view.getPosition(record, header),
		direction = e.shiftKey ? 'up' : 'down',
				newPosition = view.walkCells(position, direction, e, false),
				newId=newPosition.row,
				grid=view.up('gridpanel');

		deltaY=20 * (direction== 'down' ? 1 : -1);
		if(Ext.isDefined(grid)){
		grid.scrollByDeltaY(deltaY);
		me.lastId=newPosition.row;
		Ext.defer(function(){
			if(Ext.app.gridRendered){
				if (newPosition)ep.startEditByPosition(newPosition);
				else ep.completeEdit();
			}
		}, 100);
	}
	}
});

//--Tooltip issue on IE
Ext.override(Ext.tip.QuickTip, {
    helperElId: 'ext-quicktips-tip-helper',
    initComponent: function ()
    {
        var me = this;

        me.target = me.target || Ext.getDoc();
        me.targets = me.targets || {};
        me.callParent();

        // new stuff
        me.on('move', function ()
        {
            var offset = me.hasCls('x-tip-form-invalid') ? 45 : 37,
                helperEl = Ext.fly(me.helperElId) || Ext.fly(
                    Ext.DomHelper.createDom({
                        tag: 'div',
                        id: me.helperElId,
                        style: {
                            position: 'absolute',
                            left: '-1000px',
                            top: '-1000px',
                            'font-size': '12px',
                            'font-family': 'tahoma, arial, verdana, sans-serif'
                        }
                    }, Ext.getBody())
                );
            try{
                if(!isNullOrEmpty(me.html) && (me.html.length <= '64000' && me.html.length>='1000')){
                	helperEl.update(me.html);
                	me.setWidth(1200);
                }
                else if (me.html && (me.html !== helperEl.getHTML() || me.getWidth() !== (helperEl.dom.clientWidth + offset)))
                {
                    helperEl.update(me.html);
                    me.setWidth(Ext.Number.constrain(helperEl.dom.clientWidth + offset, me.minWidth, me.maxWidth));
                }
            }
            catch(e){
            	if (me.html && (me.html !== helperEl.getHTML() || me.getWidth() !== (helperEl.dom.clientWidth + offset)))
                {
                    helperEl.update(me.html);
                    me.setWidth(Ext.Number.constrain(helperEl.dom.clientWidth + offset, me.minWidth, me.maxWidth));
                }
            }
        }, this);
    }
});

Ext.override(Ext.tree.Panel, {
	titleAlign:'center',
	listeners: {
        afterrender: function(panel) {
            var header = panel.getHeader && panel.getHeader();
            if (header) {
                var titleEl = header.getEl().down('.x-panel-header-text');
                if (titleEl) {
                    Ext.create('Ext.tip.ToolTip', {
                        target: titleEl,
                        html: panel.title || '',   
                        dismissDelay: 0,
                        cls:'error-field-tooltip'
                    });
                }
            }
        }
    }
});

Ext.override(Ext.window.Window,{
	initComponent: function ()
	{
		var me = this;
		me.target = me.target || Ext.getDoc();
		me.targets = me.targets || {};

        // disable resizing and dragging globally
        me.resizable = false;
       me.draggable = false;
		me.callParent();
		me.on('show', function ()
				{
			if(me.id !='NotificationAlertWindow') {
				var el = me.getEl();
				el.setOpacity(0);
				el.fadeIn({
					duration: 800
				});
			}
			
		}, this);

		me.on('beforeclose',function(win){
			if(win.id !='NotificationAlertWindow') {
				
			if (!win.shouldClose) {
					win.getEl().fadeOut({
						duration: 500,
						callback: function () {
							win.shouldClose = true;
							win.close();
						}
					});
				}
			return win.shouldClose ? true : false;
			}
			
		});
	},
    afterRender: function () {
        var me = this;
        me.callParent(arguments);
        var hasFixedFooter = false;
        
        // helper to update position
        var updateFooterPosition = function (fc) {
            var el = fc.getEl && fc.getEl();
            var win = fc.up('window');
            if (el) {
                var winLeft = win.getPosition()[0];
                var winTop = win.getPosition()[1];
                var winHeight = win.getHeight();
                var winWidth = win.getWidth();

                var footerPositionFromTop = winTop + winHeight;

                el.setStyle('top', footerPositionFromTop + 'px');
                el.setStyle('left', winLeft + 'px');
                el.setStyle('width', winWidth + 'px');
            }
        };

        // scan for fieldcontainers with a CustomBtnSubmit
        me.query('fieldcontainer').forEach(function (fc) {
        	var hasSubmitBtn = fc.items && fc.items.findBy(function (cmp) {
                return cmp.xtype === 'button' && cmp.ui && (cmp.ui.indexOf('CustomBtnSubmit') === 0 || cmp.ui.indexOf('CustomBtnCancel') === 0);
            });

            if (hasSubmitBtn) {
            	fc.addCls('fixedFooterOfWindow');
            	
            	if (fc.items && fc.items.items.length > 1) {
                	//fc.items.items.reverse();
                	var buttons = fc.items.items.slice().reverse(); // copy & reverse
                	fc.removeAll(false); // remove without destroying
                	fc.add(buttons);
                	
                	fc.updateLayout();
                }

            	setTimeout(function(){
            		updateFooterPosition(fc);
            	},100);
            	
            	// update on resize/move
                me.on('resize', function () { updateFooterPosition(fc); });
                me.on('move', function () { updateFooterPosition(fc); });
                fc.on('afterlayout', function () { updateFooterPosition(fc); }); 
                hasFixedFooter = true;
            }
        });

        if (hasFixedFooter) {
            me.addCls('hasFixedFooterWindow');

            // ensure body scrolls
            var body = me.body;
            if (body) {
                body.setStyle('overflow-y', 'auto');
            }
        }
    }
});

Ext.override(Ext.form.FieldSet, {
    afterRender: function () {
        this.callParent(arguments);

        var el = this.el;

        // Check for a direct legend child
        var hasTitle = !!el.down('legend');

        // First fieldset in its form?
        var isFirst = el.dom.parentNode && el.dom === el.dom.parentNode.querySelector('.x-fieldset');

        if (!hasTitle) {
            el.addCls('fieldSet-without-titleCls');
        }

        if (!hasTitle && isFirst) {
            el.addCls('fieldSet-first-without-titleCls');
        }
    }
});
Ext.override(Ext.Date, {
	  unescapeFormat: function(l) {
          switch (l) {
          case "d-m-Y":
              l = "dd-mm-YYYY";
              break;
          case "Y-m-d":
              l = "YYYY-mm-dd";
              break;
          case "M-d-Y":
              l = "MMM-dd-YYYY";
              break;
          case "Y-d-m":
              l = "YYYY-dd-mm";
              break;
          case "d/m/Y":
              l = "dd/mm/YYYY";
              break;
          case "m-d-Y":
              l = "mm-dd-YYYY";
              break;
          case "m/d/Y":
              l = "mm/dd/YYYY";
              break;
          case "d-M-Y":
              l = "dd-MMM-YYYY";
              break;
          case "d/m/Y h:i A":
              l = "dd/mm/YYYY h:i A"
          }
          ;return l.replace('/\\/gi', "")
      }
});
		
//Marker class so we can require this file
Ext.define('Academia.utilities.AllOverrides', {});