/**
 * This is used for Grouping data in combo box
 * @author Pravin.Surve
 */
Ext.define('Academia.utilities.ux.GroupingComboBox', {
    extend: 'Ext.form.field.ComboBox',
    alias: 'widget.groupingcombobox',
    constructor: function (args) {
        var me = this,
            groupField = args.groupField || "code",
            groupDisplayField = args.groupDisplayField || groupField,
            displayField = args.displayField || "value";


        args.tpl = new Ext.XTemplate(
                '<tpl for=".">',
                '<tpl if="this.' + groupField + ' != values.' + groupField + '">',
                '<tpl if="code != null">',
                	'<tpl exec="this.' + groupField + ' = values.' + groupField + '"></tpl>',
                	'<div class="x-panel-header-default x-panel-header-text-container x-panel-header-text x-panel-header-text-default" title="{' + groupDisplayField + '}">{' + groupDisplayField + '}</div>',
            	'<tpl else>',
            		'<div class="x-panel-header-default x-panel-header-text-container x-panel-header-text x-panel-header-text-default" title="Other">Other</div>',
            	'</tpl>',
                '</tpl>',
                '<div class="x-boundlist-item">{' + displayField + '}</div>',
                '</tpl>'
            );


        me.callParent(arguments);
    }
});