/*
 * author @Raghavendra.Soni
 *
 */
Ext.define('Academia.view.DMSView.DocumentCopyMoveWindow', {
	extend : 'Ext.window.Window',
	alias : 'widget.documentcopymovewindow',
	autoScroll : true,
	maxHeight : 900,
	maxWidth: 1000,
	modal : true,
	closeAction: 'destroy',
	items : [ {
		xtype : 'form',
		columns : 1,
		defaults : {
			width: 536,
			labelWidth: 150
		},
		plugins : "formlabelrequired",
		items : [{
			xtype: 'hidden',
			itemId: 'fileNodesItemId'
		},{
			xtype: 'label',
			text: getDMSTranslation('PATH')
		},{
        	xtype: 'treepanel',
        	height: 300,
        	border: true,
        	itemId: 'libraryDocumentWindowTreePanel',
        	rootVisible: true,
        	store:Ext.create('Ext.data.TreeStore', {
        	    root: {
        	        expanded: true,
        	        text: 'Documents',
        	        leaf: false,
        	        children: []
        	    }
        	})
        },{
			xtype : 'fieldcontainer',
			width : '100%',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				action : 'Submit',
				text : getDMSTranslation('SAVE'),
				itemId : 'dmsDocCopySubmitButtonId',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}, {
				xtype : 'button',
				itemId : 'dmsDocCopyCancelButtonId',
				text : getDMSTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				scale : CONSTANTS.BUTTONSIZE
			} ]
		} ]
	} ]

});