Ext.define('Academia.view.DMSView.EditTaskStructure', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.edittaskstructure',
    autoScroll:true,
	
	cls:'horizontalScrollingFixed' ,
    items: [{
    	xtype: 'form',
    	width: 700,
        plugins: "formlabelrequired",
        items: [{
        	xtype:'hiddenfield',
        	name: 'id',
        	itemId: 'id'
        },{
        	xtype:'hiddenfield',
        	name: 'owner_userName',
        	itemId: 'owner_userName'
        },{
        	xtype: 'fieldset',
        	defaults: {
                width: 256,
                labelWidth: 80
            },
            layout: 'anchor',
        	items:[{
        		xtype: 'displayfield',
        		name: 'title',
        		itemId: 'title',
        		fieldLabel: getDMSTranslation('WORKFLOW')
        	},{
        		xtype: 'displayfield',
        		name: 'workflowInstance_message',
        		itemId: 'workflowInstance_message',
        		fieldLabel: getDMSTranslation('MESSAGE')
        	},{},{
        		xtype: 'displayfield',
        		name: 'owner',
        		itemId: 'owner',
        		fieldLabel: getDMSTranslation('OWNER'),
        	},{
        		xtype: 'displayfield',
        		name: 'propertyLabels_bpm_priority',
        		itemId: 'propertyLabels_bpm_priority',
        		fieldLabel: getDMSTranslation('PRIORITY'),
        	},{
        		xtype: 'displayfield',
        		name: 'workflowInstance_dueDate',
        		itemId: 'workflowInstance_dueDate',
        		fieldLabel: getDMSTranslation('DUE'),
        	},{
        		xtype: 'displayfield',
        		name: 'identifier',
        		itemId: 'identifier',
        		fieldLabel: getDMSTranslation('IDENTIFIER'),
        	},{
        		xtype: 'customcombobox',
        		name: 'propertyLabels_bpm_status',
        		itemId: 'propertyLabels_bpm_status',
        		fieldLabel: getDMSTranslation('STATUS'),
        		valueField: 'id',
    			displayField: 'value',
    			store: new Ext.data.ArrayStore({
    	    		id: 0,
    	    		fields: ['value'],
    				data: ['Not Yet Started','In Progress','On Hold','Cancelled','Completed']  // data is local
    	    	}),
    			queryMode: 'local',
    			editable: false,
    			allowBlank: false
        	},{
        		xtype: 'textarea',
        		name: 'comment',
        		itemId: 'comment',
        		fieldLabel: getDMSTranslation('COMMENT')
        	},{
        		xtype: 'button',
        		itemId: 'approveItemId',
        		text: getDMSTranslation('APPROVE')
        	},{
        		xtype: 'button',
        		itemId: 'rejectItemId',
        		text: getDMSTranslation('REJECT')
        	},{
        		xtype: 'button',
        		itemId: 'saveItemId',
        		text: getDMSTranslation('SAVE')
        	},{
        		xtype: 'button',
        		itemId: 'cancelItemId',
        		text: getDMSTranslation('CANCEL')
        	}]
        }]
    }]
});