Ext.define('Academia.view.DMSView.ViewDocumentPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.viewdocumentpanel',
    margin: 0,
    layout: 'vbox',
    autoScroll: true,
    frame: true,
    border: true,
    height: 580,
    items:[{
    	xtype: 'label',
    	itemId: 'documentPathItemId',
    	cls: 'documentPathCls'
    },{
    	xtype: 'panel',
    	itemId: 'documentInfoPanelItemId',
    	layout: 'hbox',
    	width: '100%',
    	items:[{
    		xtype: 'image',
    		itemId: 'documentIconItemId',
    		src: '',
        	cls: 'documentIconCls'
    	},{
        	xtype: 'label',
        	itemId: 'documentNameItemId',
        	cls: 'documentNameCls'
        },{
        	xtype: 'label',
        	itemId: 'documentVersionItemId',
        	cls: 'documentVersionCls'
        },{
        	xtype: 'label',
        	itemId: 'documentUpdateItemId',
        	cls: 'documentUpdateCls'
        },{
        	xtype: 'tbspacer',
        	flex:1
        },{
        	xtype: 'button',
        	text: getDMSTranslation('DOWNLOAD'),
        	itemId: 'documentDownloadBtnItemId',
        	cls: 'documentDownloadBtnCls',
        	ui: 'CustomBtnSubmit',
        	scale: CONSTANTS.BUTTONSIZE,
        }]
    },{
    	xtype: 'panel',
    	layout: 'hbox',
    	width: '100%',
        height: 400,
    	items:[{
        	xtype: 'tbspacer',
        	flex:1
        },{
        	xtype: 'panel',
        	width: 400,
            height: 400,
    		border: true,
    		frame: true,
        	layout: {
                type: 'accordion',
                titleCollapse: false,
                animate: true,
                activeOnTop: false,
            },
            items: [{
            	title: getDMSTranslation("WORKFLOW_I_HAVE_STARTED_ACTIVE"),
            	collapsed: true,
        		layout: 'fit',
            	items:[{
            		xtype: 'dataview',
            		itemId: 'activeWorkflowIHaveStartedListItemId',
            		autoScroll: true,
            		store: new Ext.data.ArrayStore({
        				id: 0,
        				fields: ['id','url','name','title','description','isActive','startDate','priority','message','endDate','dueDate','context','initiator','definitionUrl','isEditable','owner','status'],
        				data: []
        			}),
            		tpl: new Ext.XTemplate(
            				'<p style="margin: 0px 11px;border-bottom: 1px solid #ddd;padding: 8px 0px;">This document is part of the following workflow(s):</p>',
            				'<tpl for=".">',
            					'<div class="thumb-wrap-workflow">',
            						'<img src="resources/images/dms_user.png" />',
            						'<div class="workflow_info_container">',
            							'<span class="workflow_description workflowEditable">{message}</span><br />',
            							'<span class="workflow_type">{title}</span>',
            						'</div>',
            					'</div>',
            				'</tpl>'
            		),
            		itemSelector: 'div.thumb-wrap-workflow',
            		emptyText: 'No workflow assigned to you.',
            	}]
            },{
            	title: getDMSTranslation("WORKFLOW_I_HAVE_STARTED_COMPLETED"),
            	collapsed: true,
        		layout: 'fit',
            	items:[{
            		xtype: 'dataview',
            		itemId: 'completedWorkflowIHaveStartedListItemId',
            		autoScroll: true,
            		store: new Ext.data.ArrayStore({
        				id: 0,
        				fields: ['id','url','name','title','description','isActive','startDate','priority','message','endDate','dueDate','context','initiator','definitionUrl','isEditable','owner','status'],
        				data: []
        			}),
            		tpl: new Ext.XTemplate(
            				'<p style="margin: 0px 11px;border-bottom: 1px solid #ddd;padding: 8px 0px;">This document is part of the following workflow(s):</p>',
            				'<tpl for=".">',
            					'<div class="thumb-wrap-workflow">',
            						'<img src="resources/images/dms_user.png" />',
            						'<div class="workflow_info_container">',
            							'<span class="workflow_description workflowEditable">{message}</span><br />',
            							'<span class="workflow_type">{title}</span>',
            						'</div>',
            					'</div>',
            				'</tpl>'
            		),
            		itemSelector: 'div.thumb-wrap-workflow',
            		emptyText: 'No workflow assigned to you.',
            	}]
            },{
            	title: getDMSTranslation("ACTIVE_WORKFLOWS"),
            	collapsed: true,
        		layout: 'fit',
            	items:[{
            		xtype: 'dataview',
            		itemId: 'workflowListItemId',
            		autoScroll: true,
            		store: new Ext.data.ArrayStore({
        				id: 0,
        				fields: ['id','url','name','title','description','isActive','startDate','priority','message','endDate','dueDate','context','initiator','definitionUrl','isEditable','owner','status'],
        				data: []//[[1, 'Pixels', 'Review and Approve (one or more reviewers)'],[2, 'Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pix', 'Review and Approve (one or more reviewers)']]
        			}),
            		tpl: new Ext.XTemplate(
            				'<p style="margin: 0px 11px;border-bottom: 1px solid #ddd;padding: 8px 0px;">This document is part of the following workflow(s):</p>',
            				'<tpl for=".">',
            					'<div class="thumb-wrap-workflow">',
            						'<img src="resources/images/dms_user.png" />',
            						'<div class="workflow_info_container">',
            							'<span class="workflow_description workflowEditable">{message}</span><br />',
            							'<span class="workflow_type">{title}</span>',
            						'</div>',
            					'</div>',
            				'</tpl>'
            		),
            		itemSelector: 'div.thumb-wrap-workflow',
            		emptyText: 'No workflow assigned to you.',
            	}]
            },{
            	title: getDMSTranslation("COMPLETED_WORKFLOWS"),
            	collapsed: true,
        		layout: 'fit',
            	items:[{
            		xtype: 'dataview',
            		itemId: 'completedWorkflowListItemId',
            		autoScroll: true,
            		store: new Ext.data.ArrayStore({
        				id: 0,
        				fields: ['id','url','name','title','description','isActive','startDate','priority','message','endDate','dueDate','context','initiator','definitionUrl','isEditable','owner','status'],
        				data: []//[[1, 'Pixels', 'Review and Approve (one or more reviewers)'],[2, 'Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pixels-2Pixels-2 Pix', 'Review and Approve (one or more reviewers)']]
        			}),
            		tpl: new Ext.XTemplate(
            				'<p style="margin: 0px 11px;border-bottom: 1px solid #ddd;padding: 8px 0px;">This document is part of the following workflow(s):</p>',
            				'<tpl for=".">',
            					'<div class="thumb-wrap-workflow">',
            						'<img src="resources/images/dms_user.png" />',
            						'<div class="workflow_info_container">',
            							'<span class="workflow_description workflowEditable">{message}</span><br />',
            							'<span class="workflow_type">{title}</span>',
            						'</div>',
            					'</div>',
            				'</tpl>'
            		),
            		itemSelector: 'div.thumb-wrap-workflow',
            		emptyText: 'No workflow assigned to you.',
            	}]
            }, {
            	title: getDMSTranslation("VERSION_HISTORY"),
            	collapsed: false,
        		layout: 'fit',
            	items:[{
            		xtype: 'dataview',
            		itemId: 'versionHistoryDataViewItemId',
            		autoScroll: true,
            		store: new Ext.data.ArrayStore({
        				id: 0,
        				fields: [
        					'version',
        					'fileName',
        					'username',
        					'dateTime',
        					'comment',
        					'nodeRef',
        					'isCurrentVersion'
        				],
        				data: []
        			}),
            		tpl: new Ext.XTemplate(
            				'<tpl for=".">',
            					'<div class="thumb-wrap-version">',
            						'<div class="doc_version">{version}</div>',
            						'<div class="doc_info_container">',
            							'<span class="doc_fileName">{fileName}</span>',
            							'<img src="resources/images/dms_user.png" />',
            							'<span class="doc_username">{username} {dateTime} ago</span><br />',
            							'<span class="doc_comment">{comment}</span>',
            							'<span class="SideBtns">{[this.sideBtns(values)]}</span>',
            						'</div>',
            					'</div>',
            				'</tpl>',
        			        {
            					sideBtns: function(values){
         		    			   var btnHtml = '';
         		    			   var isDownloadAvailable = true;
         		    			   var isRevertAvailable = true;
         		    			   
         		    			   if(values.isCurrentVersion){
         		    				  var isDownloadAvailable = false;
            		    			  var isRevertAvailable = false; 
         		    			   }
         		    			   
         		    			   if(isRevertAvailable){
         		    				   btnHtml = btnHtml+'<span title="Revert" class="revertVersionBtnIconCls"></span>';
         		    			   }
         		    			   if(isDownloadAvailable){
         		    				   btnHtml = btnHtml+'<span title="Download" class="downloadVersionBtnIconCls"></span>';
         		    			   }
         		    			   return btnHtml;
         		    		   }
        			        }
            		),
            		itemSelector: 'div.thumb-wrap-version',
            		emptyText: 'This document has no previous versions',
            	}]
            }]
        }]
    }]
});