/**
* This is the basic tab structure of the Admission Cycle Setup.
* @author Akshay.Kalbhor
*/
Ext.define('Academia.view.admission.admissionCycle.AdmissionCycleSetupUpdateStructure', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.admissioncyclesetupupdate',
    itemId: 'admissioncyclesetupupdate',
    plugins: "formlabelrequired",
    autoScroll: false,
    cls: 'panelNoSpace',
    layout:'anchor',
    items: [{
        xtype: 'form',
        frame: false,
        method: 'POST',
        cls:'customSearchPanel',
        standardSubmit: false,
        items: [{
            xtype: 'radiogroup',
            itemId: 'importAdmissionSetupUpdatesRadioGroupItemId',
            style: {
                marginLeft: '8px'
            },
            defaults: {
                flex: .1
            },
            items: [{
                boxLabel: getCommonTranslation('DOWNLOAD_TEMPLATE'),
                name: 'downloadUploadTemplate',
                inputValue: 'forDownloadTemplate',
                checked: true

            }, {
                boxLabel: getCommonTranslation('UPLOAD_TEMPLATE'),
                name: 'downloadUploadTemplate',
                inputValue: 'forUploadTemplate'
            }]
        }, {
            xtype: 'admissionsetupupdatesuploadform',
            itemId: 'admissionsetupupdatesuploadformItemId',
            hidden: true
        }, {
            xtype: 'admissionsetupupdatesdownloadform',
            itemId: 'admissionsetupupdatesdownloadformItemId'
        }]
    }, {
        xtype: 'panel',
        items: [{
            xtype: 'importadmissionsetupupdatesgrid',
            itemId: 'importadmissionsetupupdatesgridItemId',
            hidden: true
        }]
    }]
});