/**
 * This panel is used in the Admission Settings Form of the admission Cycle.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.admissionCycle.AdmissionSettingsForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.admissionsettingsform',
    title: getAdmissionTranslation('ADMISSION_SETTING'),
    collapsible: true,
    autoScroll: true,
    frame:true,
    layout: 'anchor',
	cls:'horizontalScrollingFixed x-form-fixed-footer-parent applicationsettingformCls', 
    defaults: {
        labelAlign: 'top'
    },
    items: [{
        xtype: 'hidden',
        name: 'id'
    },
    {
        xtype: 'hidden',
        name: 'multipleId',
        itemId :'multipleId'
    },{
        xtype: 'hidden',
        itemId: 'versionField',
        name: 'version'
    },{
    	xtype : 'fieldcontainer',
    	width: '100%',
    	defaults : {
    		labelAlign : 'top',
    		 width: '100%'
    	},
    	items : [{
    		xtype:'displayfield',
    		value:'<b class="menu-title">'+getAdmissionTranslation('ADMISSION_OFFER_SETTINGS')+'</b>',
    		style: {
    			fontWeight: "bold"
    		}
    	}, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 230
        },
        items: [{
            xtype: 'checkbox',
            labelWidth: 200,
            name: 'whetherOfferLetterApplicable',
            itemId: 'whetherOfferLetterApplicable',
            inputValue: true,
            uncheckedValue:false,
            fieldLabel: getAdmissionTranslation('OFFER_LETTER_APPLICABLE')
	        },
	        {
	        	xtype: 'datefield',
	            name: 'admissionOfferStartDate',
	            labelAlign: 'top',
	            fieldLabel: getAdmissionTranslation('ADMISSION_OFFER_START_DATE'),
	            vtype: 'daterange',
	            itemId: 'admissionOfferStartDate',
	            endDateField:'admissionOfferEndDate',
	            allowBlank: false,
	            editable: false,
	            hidden:true,
	            listeners: {
	          	  render: function(field) {
	          		  return dateFormatRender(field);
	          	  }
	            }
	      }, {
	          xtype: 'datefield',
	          name: 'admissionOfferEndDate',
	          fieldLabel: getAdmissionTranslation('ADMISSION_OFFER_END_DATE'),
	          labelAlign: 'top',
	          vtype: 'daterange',
	          itemId: 'admissionOfferEndDate',
	          startDateField:'admissionOfferStartDate',
	          allowBlank: false,
	          editable: false,
	          hidden:true,
	          listeners: {
	          	render: function(field) {
	          		return dateFormatRender(field);
	          	}
	          }
	      },{
  			xtype: 'button',
			itemId: 'offerLetterBtn',
			text: getCommonTranslation('OFFER_LETTER_MAPPING'),
			cls: 'offerLetterMappingBtn btn-with-no-icon',
			ui:'CustomBtnCancel',
			hidden:true,
			scale: CONSTANTS.BUTTONSIZE
		}]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 230
        },
        items: [{
			 xtype: 'customcombobox',
			 name: 'offerLetterIssueProcess',
			 itemId:'offerLetterIssueProcess',
			 fieldLabel: getAdmissionTranslation('OFFER_LETTER_ISSUE_PROCESS'),
			 store: Ext.create('Academia.store.admission.admissionCycle.OfferLetterIssueProcessStore'),
			 valueField: 'id',
			 displayField: 'value',
			 typeAhead:true,
			 forceSelection:true,
			 allowBlank:false,
			 editable: false,
			 hidden:true
		 },{
            xtype: 'numberfield',
            name: 'offerLetterAcceptDaysLimit',
            itemId:'offerLetterAcceptDaysLimit',
            labelAlign: 'top',
            fieldLabel: getAdmissionTranslation('MAX_DAYS_TO_ACCEPT_OFFER'),
            minValue: 0,
            allowBlank: true,
            hidden:true,
        },  {
	          xtype: 'datefield',
	          name: 'offerLetterExpiryDate',
	          fieldLabel: getAdmissionTranslation('OFFER_LETTER_EXPIRY_DATE'),
	          labelAlign: 'top',
	          vtype: 'daterange',
	          itemId: 'offerLetterExpiryDate',
	          startDateField:'admissionOfferEndDate',
	          allowBlank: true,
	          editable: false,
	          hidden:true,
	          listeners: {
	          	render: function(field) {
	          		return dateFormatRender(field);
	          	}
	          }
	      },{
	          xtype: 'numberfield',
	            name: 'offerLetterIssuancePotential',
	            itemId:'offerLetterIssuancePotential',
	            labelAlign: 'top',
	            fieldLabel: getAdmissionTranslation('OFFER_LETTER_ISSUANCE_POTENTIAL'),
	            minValue: 1,
	            maxValue:10000,
	            allowBlank: true,
	            hidden:true,
	     
	      }]
     }, {
    xtype: 'fieldcontainer',
    layout: {
        type: 'hbox'
    },
    defaults: {
        labelAlign: 'top',
        width: 450
    },
    items: [{
        xtype: 'checkbox',
        labelWidth: 200,
        name: 'whetherEnableAutoOfferletterExpiry',
        itemId: 'whetherEnableAutoOfferletterExpiry',
        inputValue: true,
        hidden:true,
        uncheckedValue:false,
        fieldLabel: getAdmissionTranslation('ENABLE_AUTO_OFFER_LETTER_EXPIRY'),
        labelAlign: 'left',

        }]
},{
    xtype: 'fieldcontainer',
    layout: {
        type: 'hbox'
    },
    defaults: {
        width: 230
    },    
    items: [{
        xtype: 'checkbox',
        labelWidth: 200,
        name: 'whetherProvisionalOfferApplicable',
        itemId: 'whetherProvisionalOfferApplicable',
        inputValue: true,
        uncheckedValue:false,
        fieldLabel: getAdmissionTranslation('PROVISIONAL_OFFER_APPLICABLE'),
        hidden:true,
        style:{
        	marginTop:'20px'
        	}
        },
        {
        	xtype: 'datefield',
            name: 'proAdmissionOfferStartDate',
            labelAlign: 'top',
            fieldLabel: getAdmissionTranslation('PROVISIONAL_OFFER_START_DATE'),
            vtype: 'daterange',
            itemId: 'proAdmissionOfferStartDate',
            endDateField:'proAdmissionOfferStartDate',
            allowBlank: false,
            editable: false,
            hidden:true,
            listeners: {
          	  render: function(field) {
          		  return dateFormatRender(field);
          	  }
            }
      }, {
          xtype: 'datefield',
          name: 'proAdmissionOfferEndDate',
          fieldLabel: getAdmissionTranslation('PROVISIONAL_OFFER_END_DATE'),
          labelAlign: 'top',
          vtype: 'daterange',
          itemId: 'proAdmissionOfferEndDate',
          startDateField:'proAdmissionOfferStartDate',
          allowBlank: false,
          editable: false,
          hidden:true,
          listeners: {
          	render: function(field) {
          		return dateFormatRender(field);
          	}
          }
      }]
},{
    xtype: 'fieldcontainer',
    layout: {
        type: 'hbox'
    },
    defaults: {
        labelAlign: 'top',
        width: 230
    },
    items: [{
		 xtype: 'customcombobox',
		 name: 'proOfferLetterIssueProcess',
		 itemId:'proOfferLetterIssueProcess',
		 fieldLabel: getAdmissionTranslation('PRO_OFFER_LETTER_ISSUE_PROCESS'),
		 store: Ext.create('Academia.store.admission.admissionCycle.OfferLetterIssueProcessStore'),
		 valueField: 'id',
		 displayField: 'value',
		 typeAhead:true,
		 forceSelection:true,
		 allowBlank:false,
		 editable: false,
		 hidden:true
	 },{
        xtype: 'numberfield',
        name: 'proOfferLetterAcceptDaysLimit',
        itemId: 'proOfferLetterAcceptDaysLimit',
        labelAlign: 'top',
        fieldLabel: getAdmissionTranslation('PRO_MAX_DAYS_TO_ACCEPT_OFFER'),
        minValue: 0,
        allowBlank: true,
        hidden:true,
    }, {
        xtype: 'datefield',
        name: 'proOfferLetterExpiryDate',
        fieldLabel: getAdmissionTranslation('PROVISIONAL_OFFER_LETTER_EXPIRY_DATE'),
        labelAlign: 'top',
        vtype: 'daterange',
        itemId: 'proOfferLetterExpiryDate',
        startDateField:'proAdmissionOfferEndDate',
        allowBlank: true,
        editable: false,
        hidden:true,
        listeners: {
        	render: function(field) {
        		return dateFormatRender(field);
        	}
        }
    }]
    },
    {
    xtype: 'fieldcontainer',
    layout: {
        type: 'hbox'
    },
    defaults: {
        labelAlign: 'top',
        width: 230
    },
    items: [{
		 xtype      : 'radiogroup',
		 fieldLabel : getAdmissionTranslation('ADDITIONAL_CONDITION_APPLICABLE'),
		 itemId: 'additionalConditionApplicableItemId',
		 name: 'whetherAdditionalConditionApplicable',
		 hidden: true,
		 defaults: {
			 flex: 1
		 },
		 layout: 'hbox',
		 items:[{ 
			 boxLabel: getCommonTranslation('YES'), 
			 name: 'whetherAdditionalConditionApplicable', 
			 inputValue: true
			 //checked:true
		 },{ 
			 boxLabel: getCommonTranslation('NO'), 
			 name: 'whetherAdditionalConditionApplicable', 
			 inputValue: false,
			 checked:true
		 }]
	 },{
			xtype: 'multiselectcombofield',
			name: 'currentActivityName',
			itemId:'currentActivityItemId',
			store:'enquiry.CurrentActivityStore',
			fieldLabel: getAdmissionTranslation('CURRENT_ACTIVITY'),
			valueField: 'id',
			displayField: 'value',
			allowBlank: true,
			labelSeparator : '',
			//typeAhead:true,
			hidden:true,
			editable: false,
			disableKeyFilter: false,
			forceSelection:true,
			cls:'commonAutoHeightMultiselectField',
		}/* {
        xtype: 'numberfield',
        name: 'maxDaysToHoldProOfferLetter',
        itemId: 'maxDaysToHoldProOfferLetter',
        labelAlign: 'top',
        align: 'bottom',
        fieldLabel: getAdmissionTranslation('PRO_MAX_DAYS_TO_HOLD_OFFER'),
        minValue: 0,
        allowBlank: true,
        hidden:true,
    }*/]
}
]},
{
	xtype : 'fieldcontainer',
	width: '100%',
	defaults : {
		labelAlign : 'top',
		width: '100%'
	},	
	items : [{
		xtype:'displayfield',
		value:'<b class="menu-title">'+getAdmissionTranslation('ADMISSION_CYCLE_SETTINGS')+'</b>',
		style: {
			fontWeight: "bold"
		}
	},{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 230
        },
        items: [{
        	  xtype: 'datefield',
              name: 'admissionProcessStartDate',
              fieldLabel: getAdmissionTranslation('ADMISSION_START_DATE'),
            //--submitFormat: CONSTANTS.DATE_FORMAT,
//              format: CONSTANTS.DATE_FORMAT
              vtype: 'daterange',
              itemId: 'admissionProcessStartDate',
              endDateField:'lastDateForAdmission',
              labelAlign: 'top',
              allowBlank: false,
              editable: false,
              listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              }
        }, {
            xtype: 'datefield',
            name: 'lastDateForAdmission',
            fieldLabel: getAdmissionTranslation('ADMISSION_LAST_DATE'),
          //--submitFormat: CONSTANTS.DATE_FORMAT,
//            format: CONSTANTS.DATE_FORMAT,
            vtype: 'daterange',
            itemId: 'lastDateForAdmission',
            labelAlign: 'top',
            startDateField:'admissionProcessStartDate',
            allowBlank: false,
            editable: false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            }
        }, {
            xtype: 'datefield',
            name: 'applicationRejectDateAsOn',
            fieldLabel: getAdmissionTranslation('APPLICATION_REJECT_DATE_AS_ON'),
          //--submitFormat: CONSTANTS.DATE_FORMAT,
//            format: CONSTANTS.DATE_FORMAT,
            vtype: 'daterange',
            itemId: 'applicationRejectDateAsOn',
            labelAlign: 'top',
            startDateField:'lastDateForAdmission',
            allowBlank: true,
            editable: true,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            }
        }]
    }]},{
    	xtype: 'fieldcontainer',
    		defaults: {
            width: 230
        },
        layout: {
            type: 'hbox'
        },
        items: [{
               xtype: 'checkbox',
               labelWidth: 200,
               name: 'whetherAllowBackDateAdmission',
               inputValue: true,
               uncheckedValue:false,
               checked:true,
               fieldLabel: getAdmissionTranslation('ALLOW_BACK_DATE_ADMISSION'),
               listeners: {
            	   change : function( checkBox, newValue, oldValue, eOpts ) {
            		   var field=this.nextSibling();
//        		field.allowBlank = !newValue;
            		   field.setVisible(newValue);
            		   field.setDisabled(!newValue);
            		   field.validate();
            	   }
               }
        }, {
        	xtype: 'numberfield',
        	width: 230,
        	labelAlign: 'top',
        	labelAlign: 'top',
        	fieldLabel: getAdmissionTranslation('BACK_DAYS'),
        	//TODO: change the store
        	//store: 'Academia.store.admission.admissionCycle.QuotaTypePickList',
        	name: 'admissionBackDays',
        	itemId: 'admissionBackDays',
        	displayField: 'value',
        	valueField: 'id',
        	minValue: 0
        }]
    }, {
            xtype: 'fieldcontainer',
            defaults: {
                width: 230
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'checkbox',
                labelWidth: 200,
                name: 'whetherTrialAdmissionAllowed',
                itemId: 'whetherTrialAdmissionAllowed',
                fieldLabel: getAdmissionTranslation('ALLOW_TRIAL_ADMISSIONS'),
                inputValue: true,
                uncheckedValue:false,
                checked:true,
                listeners: {
	                change : function( checkBox, newValue, oldValue, eOpts ) {
	                	var field=this.nextSibling();
	                	field.allowBlank = !newValue;
	                	field.setVisible(newValue);
	                	field.setDisabled(!newValue);
	                	//field.validate();
	                }
                }
            }, {
                xtype: 'datefield',
                labelAlign: 'top',
                itemId:'trialAdmissionEndDateId',
                name: 'trialAdmissionEndDate',
                fieldLabel: getAdmissionTranslation('TRIAL_END_DATE'),
              //--submitFormat: CONSTANTS.DATE_FORMAT,
                minValue : new Date(),
//                format: CONSTANTS.DATE_FORMAT,
                allowBlank: false,
                editable: false,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            defaults: {
                width: 230
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'checkbox',
                labelWidth: 200,
                name: 'allowProvisionalAdmission',
                itemId: 'allowProvisionalAdmission',
                inputValue: true,
                uncheckedValue:false,
                checked:true,
                fieldLabel: getAdmissionTranslation('ALLOW_PROVISIONAL_ADMISSIONS'),
                listeners: {
	                change : function( checkBox, newValue, oldValue, eOpts ) {
	                	var field=this.nextSibling();
	                	field.allowBlank = !newValue;
	                	field.setVisible(newValue);
	                	field.setDisabled(!newValue);
	                	//field.validate();
	                }
                }
            }, {
                xtype: 'datefield',
                labelAlign: 'top',
                name: 'lastDateForConfirmation',
                fieldLabel: getAdmissionTranslation('PROVISIONAL_END_DATE'),
              //--submitFormat: CONSTANTS.DATE_FORMAT,
//                format: CONSTANTS.DATE_FORMAT,
                minValue : new Date(),
                allowBlank: false,
                editable: false,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                }
        }]
    }, {
        xtype: 'fieldcontainer',
        defaults: {
            width: 230
        },
        layout: {
            type: 'hbox'
        },
        items: [{
        	 xtype: 'checkbox',
             labelWidth: 200,
             name: 'whetherAutoAdmissionApproval',
             itemId: 'whetherAutoAdmissionApproval',
             inputValue: true,
             uncheckedValue:false,
             fieldLabel: getAdmissionTranslation('AUTO_ADMISSION_APPROVAL')
        }]
    }, {
        xtype: 'fieldcontainer',
        defaults : {
    		width: 230
    	},
        layout: {
            type: 'hbox'
        },
        items: [{
        	 xtype: 'checkbox',
             labelWidth: '200',
             name: 'checkForEligibilityBeforeApproveAdmissionAutomatically',
             itemId: 'checkForEligibilityBeforeApproveAdmissionAutomatically',
             inputValue: true,
             style : {paddingTop:'5px'},
             uncheckedValue:false,
             hidden: true,
             fieldLabel: getAdmissionTranslation('CHECK_FOR_ELIGIBILITY_BEFORE_APPROVE_ADMISSION_AUTOMATICALLY')
        },{
			 xtype: 'multiselectcombofield',
			 name: 'eligibilityRecommendation',
			 itemId:'eligibilityRecommendation',
			 fieldLabel: getAdmissionTranslation('ELIGIBILITY_RECOMMENDATION'),
			// store: Ext.create('Academia.store.admission.admissionCycle.OfferLetterIssueProcessStore'),
			 store: Ext.create('Academia.store.enquiry.EligibilityRecommendationForAdmissionSetupStore'),
			 valueField: 'id',
			 width: 230,
			 labelAlign: 'top',
			 displayField: 'value',
			 typeAhead:true,
			 forceSelection:true,
			 allowBlank:false,
			 editable: false,
			 hidden:true
		 
        }]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 230
        },
        items: [{
	    	xtype: 'livesearchcombo',
	    	style : {paddingTop:'17px'},
		    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    	allowBlank: true,
	    	name: 'approverAuthority',
	    	itemId:'approverAuthority',
	    	fieldLabel: getAdmissionTranslation('APPROVAL_AUTHORITY')
        },{
	    	xtype: 'datefield',
		    name: 'referenceLetterSubmissionDeadline',
		    fieldLabel: getAdmissionTranslation('REFERENCE_LETTER_SUBMISSION_DEADLINE'),
		    vtype: 'daterange',
		    itemId: 'referenceLetterSubmissionDeadline',
		    editable: false,
		    listeners: {
		  	  render: function(field) {
		  		  return dateFormatRender(field);
		  	  } 
		    }   
        }]   
    }, {
        xtype: 'textarea',
	    width: 466,
        name: 'remark',
        fieldLabel: getCommonTranslation('REMARKS')
        
    },{
	  xtype:'fieldcontainer',
	  cls: 'form-fixed-footer',
	  width:'auto',
	  layout: {
		  type: 'hbox'
	  },
	  items:[{
	        xtype: 'button',
	        text: getCommonTranslation('SAVE'),
	        itemId: 'saveAdmissionSetting',
	        ui: 'CustomBtnSubmit',
	        scale: CONSTANTS.BUTTONSIZE,
	        formBind: true
	    }]
  }]
});