/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.admission.admissionCycle.AdmissionSetupUpdatesDownloadForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
   // extend: 'Ext.form.FormPanel',
    alias: 'widget.admissionsetupupdatesdownloadform',
    frame: false,
   // autoScroll: true,
    method: 'POST',
    //cls:'customSearchPanel',
    standardSubmit: false,
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
            name: 'academyLocationCombo',
            itemId:'academyLocationCombo',
            store: 'user.UserAcademyLocationStore',
            displayField: 'value',
            valueField: 'id',
            width: 536,
            typeAhead : false,
            forceSelection:true,
            allowBlank:false,
            hideTrigger:false,
            queryMode: 'remote',
            queryParam: 'qry',
    	    triggerAction: 'all',
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
        },{
            xtype: 'customcombobox',
            name: 'intakeYear',
            itemId: 'intakeYearItemId',
            allowBlank:true,
            fieldLabel: getCommonTranslation('INTAKE_YEAR'),
            store: Ext.create('Academia.store.common.IntakeYearStore'),
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            editable: false,
            cls:'commonAutoHeightMultiselectField'
        },{
        	xtype: 'customcombobox',
			name: 'programGroup',
			itemId:'Program_Group',
			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
			store:'program.ProgramGroupStore',
			editable: false,
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			//allowBlank: false
        }]
    	},{
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
    			xtype: 'customcombobox',
    			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'), //Program
    			name: 'PROGRAM',
    			itemId: 'program',
    			autoload: false,
    			store: 'program.ProgramByGroupIdStore',
    			valueField: 'id',
    			displayField: 'valueCode',
    			queryParam:'qry',
    		//	typeAhead : true,
                forceSelection:true,
                hideTrigger:false,
                 triggerAction: 'all',
                minChars:3,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                    '{code} / {value}'+ 
    	                    '</div>';
    	                }
    	            }
    		},{
    			xtype: 'customcombobox',
    			fieldLabel: getAdmissionTranslation('BATCH'),   //Batch
    			name: 'BATCH',
    			itemId: 'batch',
    			editable: false,
    			autoload: false,
    			store: 'Academia.store.common.BatchesByProgramId',
    			disabled:true,
    			valueField: 'id',
    			displayField: 'value',
    			queryMode : 'local'
    		},{
    			xtype: 'customcombobox',
    			fieldLabel: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
    			name: 'SEAT_TYPE',
    			itemId: 'seatType',
    			editable: false,
    			autoload: false,
    			store:'Academia.store.common.SeatTypesByBatchId',
    			disabled:true,
    			valueField: 'seatTypeId',
    			displayField: 'seatTypeName',
    			queryMode : 'local'
    		}]
        },{
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
    			xtype: 'customcombobox',
    			fieldLabel: getAdmissionTranslation('ADMISSION_CYCLE_STATUS'),
    			name: 'admissionCycleStatus',
    			itemId: 'admissionCycleStatus',
    			editable: false,
    			autoload: false,
    			store:'Academia.store.admission.admissionCycle.admissionCycleStatusStore',
    			valueField: 'value',
    			displayField: 'name',
    			queryMode : 'local'
    		},{
    			xtype: 'datefield',
    			name: 'START_DATE',
    			itemId: 'START_DATE',
    			vtype: 'daterange',
    			endDateField: 'END_DATE',
    			fieldLabel: getAdmissionTranslation('START_DATE'),
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			}
    		}, {
    			xtype: 'datefield',
    			name: 'END_DATE',
    			itemId: 'END_DATE',
    			vtype: 'daterange',
    			startDateField: 'START_DATE',
    			fieldLabel: getAdmissionTranslation('END_DATE'),
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			}
    		}]
        },{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
		margin: '0 0 0 -24',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('DOWNLOAD_TEMPLATE'),
            itemId: 'downloadAdmissionSetupUpdateFormItemId',
            //buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            hidden: false,
            disabled:true,
            formBind: true,
            scale: CONSTANTS.BUTTONSIZE
        },{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
    }]
});