/**
 * This window will be shown on the add/Edit/View of the Program Group grid's Configure grid.
 * @author Rupesh.Agrawal
 */
Ext.define('Academia.view.admission.admissionCycle.CopyProgramGroupConfigWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.copyprogramgroupconfigwindow',
    modal : true,
	resizable:true,
	autoScroll: true,
	height: '70%',
	width: '80%',
	frame: true,
	title: getAdmissionTranslation('COPY_PROGRAM_CONFIG'),
	items: [{
	        xtype: 'form',
	        itemId: 'copyprogramgroupconfigform',
	        standardSubmit: false,
	        plugins: "formlabelrequired",
	        defaults: {
	            labelAlign: 'top'
	},  
	items:[{
    	xtype:'hidden',
    	itemId:'destinationProgramBatchSeatConfigId',
    	name:'destinationProgramBatchSeatConfigId'
    },
    {
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		style: {
			marginLeft : '10px'
		},
		items:[{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
			itemId:'academyLocationCombo',
			store: 'user.UserAcademyLocationStore',
			displayField: 'value',
			valueField: 'id',
			width:350,
			typeAhead:true,
			editable: false,
			allowBlank:true
		},{
	 		xtype: 'customcombobox',
	 		fieldLabel: getAdmissionTranslation('PROGRAM_GROUP'),
	 		name: 'programGroup',
	 		itemId: 'programGroupCombo',
	 		typeAhead:true,
	 		editable: false,
	 		store: 'Academia.store.admission.applicationFormSale.ProgramGroupComboStore',
	 		valueField: 'id',
	 		displayField: 'value'			 	
	 	},{
		    xtype: 'customcombobox',
		    name: 'programId',
		    itemId:'programIdCombo',
		    fieldLabel: getEnquiryTranslation('PROGRAM'),
		    store: 'program.ProgramByGroupIdStore',
		    displayField:'value',
		    valueField:'id',
		    typeAhead:true,
		    editable: false,
			allowBlank:true,
			disabled:true
		},{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchCombinations',
			ui: 'CustomBtnSubmit',
			formBind : true,
			scale: CONSTANTS.BUTTONSIZE,
			style:{
				marginTop: '32px !important',
				marginLeft: '25px !important'
		}
		}]  
	},
    {
		xtype: 'grid',
		store: 'admission.admissionCycle.CopyProgramGroupCombinations',
		autoScroll: true,
		itemId : 'documentsForm',
		border: true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		title: getAdmissionTranslation('LIST_CONFIGURED_PROGRAM'),
		style:{
			marginTop: '30px !important'
		},		
		columns: [{
            hidden: true,
            dataIndex: 'id'
        },{
			header : getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex : 'academyLocation',
            sortable: true,
			flex : .2
		},{
			header : getCommonTranslation('PROGRAM'),
			dataIndex : 'program',
            sortable: true,
			flex : .2
		},{
            text: getAdmissionTranslation('BATCH'),
            dataIndex: 'batch',
            sortable: true,
			flex : .2
        }, {
			header : getExaminationTranslation('SEAT_TYPE'),
			dataIndex : 'seatType',
            sortable: true,
			flex : .2
		},{
            text: getAdmissionTranslation('SELECTION_PROCESS'),
            dataIndex: 'selectionProcessValue',
            sortable: true,
			flex : .2
        },{
            text: getAdmissionTranslation('ADMISSION_STATUS'),
            dataIndex: 'whetherAdmissionOpen',
            sortable: true,
			flex : .2,
			renderer: function(value){
				if(value == null) {
					return "";
				} else if(value == false){
					return getCommonTranslation('Close')
				}else{
					return getCommonTranslation('Open');
				}
			}
        } ],
        dockedItems: [{
  	      xtype: 'toolbar',
	  	  dock: 'bottom',
	  	  items: [{
	  	      xtype: 'pagingtoolbar',
	  	      plugins: ['pagesize'],
	  	      displayInfo: true,
	  	      emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
	  	      store: 'admission.admissionCycle.CopyProgramGroupCombinations',
	  	    style:{
				marginTop:'5px !important'
			},
	  	      }]
	  	  }]	  	 
	  },{	
			xtype:'fieldcontainer',
			layout : 'hbox',
			style:{
				marginTop:'5px !important',
				marginLeft:'10px !important'
			},
			cls:'windowBtnPos',
			defaults: {
				labelAlign:'top',
			},
			items:[
			{
		  		  xtype: 'button',
		  		  itemId: 'copyConfigureMultipleCombination',
		  		  scale: CONSTANTS.BUTTONSIZE,
		  		  ui: 'CustomBtnSubmit',
		  		  tooltip: getCourseTxCommonTranslation('COPY'),
		  		  text: getCourseTxCommonTranslation('COPY')
		  	  }]
		}]
	        
	}]        
});