/**
 * This window will be shown on the add/Edit/View of the document in the documents grid
 * of the admission Cycle setup's -> Application setting and Admission Setting tab.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.admissionCycle.DocumentsWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.applicationdocumentswindow',
    modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    width:350,
    title: getAdmissionTranslation('APPLICATION_DOCUMENTS'),
    items: [{
        xtype: 'form',
        itemId: 'documentsForm',
        cls:'applicationdocumentswindowCls',
        standardSubmit: false,
        plugins: "formlabelrequired",
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        style:{
        	'margin-left':'32px !important'
        },
        items: [{
        	xtype : 'hidden',
        	name: 'id'
        },{
        	xtype : 'hidden',
        	name: 'version'
        },{
            xtype: 'nestedJsonCombo',
            name: 'documentType',
            fieldLabel: getAdmissionTranslation('SELECT_DOCUMENT'), 
            allowBlank: false,
            //store: 'Academia.store.common.DocumentTypeStore',
            store: Ext.create('Academia.store.common.DocumentTypeStore'),
            displayField: 'value',
            valueField: 'id',
            editable: false,
            itemId: 'documentTypeCombo'
        }, {
			xtype : 'customcombobox',
			name : 'applicability',
			fieldLabel : getAdmissionTranslation('APPLICABILITY'),
            allowBlank: false,
            store: 'Academia.store.admission.selectionProcess.Applicabilities',
            displayField: 'value',
            valueField: 'name',
            editable: false,
            listeners:{
                'change': function(comboReference, record, eOpts) {
                	var field=this.up('form').down('textfield#applicabilityRule');
                	if(record === 'COMPULSORYFORALL' || record === 'OPTIONAL' || record === 'OFFERBASED') {
                		field.allowBlank = true;
                		field.setVisible(false);
                		field.setDisabled(true);
                	} else {
                		field.allowBlank = false;
                		field.setVisible(true);
                		field.setDisabled(false);
                	}
                	field.validate();
                }
			}
        }, {
        	xtype: 'textarea',
            name: 'applicabilityRule',
            itemId: 'applicabilityRule',
            fieldLabel: getAdmissionTranslation('APPLICABILITY_RULE'),
            //emptyText: getCommonTranslation('{"Nationality":"India","AreyouaCitizen":"Y","AreyouAsylumSeeker":"Y","AreyouaPermanentResident":"N","Disabilities":"Yes"}'),
            allowBlank: false
        }, {
        	xtype: 'textarea',
        	name: 'remark',
        	fieldLabel: getCommonTranslation('REMARKS')
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                itemId: 'btnSaveDocuments',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            },{
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
                    click: function() {
                        this.up('window').close(); 
                    }
                }
            }]
        }]
    }]

});