/**
 * This window is used to show the Mandatory Quota Type grid in a window
 * which will open on the click of the link from the Combinations in program grid window.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.admissionCycle.MandatoryQuotaTypeGridWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.mandatoryquotatypegridwindow',
    autoScroll: true,
    modal: true,
    resizable: false,
    width: '60%',
    height: '70%',
    title: getAdmissionTranslation('SELECTION_PROCESS_DETAILS'),
    items: [{
        xtype: 'grid',
        store: 'Academia.store.admission.admissionCycle.MandatoryQuotas',
        title: getAdmissionTranslation('SELECTION_PROCESS_DETAILS'),
        border: true,
        viewConfig: {
            stripeRows: CONSTANTS.STRIPEROWS
        },

        columns: [{
            text: getAdmissionTranslation('QUOTA'),
            dataIndex: 'code',
            flex: 1
        }, {
            text: getAdmissionTranslation('DESCRIPTION'),
            dataIndex: 'quotaDescription',
            sortable: true,
            flex: 1
        }],
        dockedItems: [{
            xtype: 'toolbar',
            dock: 'bottom',
            items: [{
                xtype: 'custompagingtoolbar',
                plugins: ['pagesize'],
                displayInfo: true,
                emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
                store: 'Academia.store.admission.admissionCycle.MandatoryQuotas'
            }]
        }]
    }]
});