/**
 * This panel is used in the Selection Settings Form of the selection setting tab of
 * the admission cycle.
 * 
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.admissionCycle.SelectionSettingsForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.selectionsettingsform',
    title: getAdmissionTranslation('SELECTION_SETTING'),
    itemId: 'selectionsettingsform',
    autoScroll:true,
    layout: 'anchor',
    cls:'horizontalScrollingFixed x-form-fixed-footer-parent applicationsettingformCls', 
    frame:true,
    plugins: "formlabelrequired",
    defaults: {
    	width: 256,
    	labelAlign: 'top'
    },
    items: [{
        xtype: 'hidden',
        name: 'id'
    }, {
        xtype: 'hidden',
        itemId: 'selectionProcessStageIdField',
        name: 'selectionProcessStageId'
    }, {
        xtype: 'hidden',
        itemId: 'selectionMode',
        name: 'whetherSelectionInBatches',
        disabled:true
    }, {
        xtype: 'hidden',
        name: 'programBatchSeatConfiguration'
    }, {
        xtype: 'hidden',
        itemId: 'versionField',
        name: 'version'
    }, {
        xtype: 'hidden',
        name: 'mandatoryQuotaTypeId'
    }, {
    	xtype: 'nestedJsonCombo',
        itemId: 'selectionProcessCombo',
        name: 'selectionProcess',
        allowBlank: false,
        fieldLabel: getAdmissionTranslation('SELECTION_PROCESS'),
        store: 'Academia.store.admission.admissionCycle.SelectionProcesses',
        displayField: 'value',
        valueField: 'id',
        width : 300,
        flex: 1,
        editable: false
    }, {
        xtype: 'radiogroup',
        width: 'auto',
        allowBlank: false,
        fieldLabel: getAdmissionTranslation('SELECTION_MECHANISM'),
        itemId: 'whetherSelectionInBatches',
        columns: 3,
        vertical: false,
        items: [{
            boxLabel: getAdmissionTranslation('INDIVIDUAL'),
            name: 'whetherSelectionInBatches',
            inputValue: false
        }, {
            boxLabel: getAdmissionTranslation('SELECTION_PROCESS_IN_BATCH'),
            name: 'whetherSelectionInBatches',
            inputValue: true,
            checked: true
        }]
    },{
    	xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: 'hbox',
    	items: [{
    		xtype: 'numberfield',
    		style: {
                marginLeft: '6px'
            },
            name: 'numberOfBatch',
            fieldLabel: getAdmissionTranslation('NUMBER_OF_BATCHES'),
    		itemId: 'numberOfBatchItemId',
    		hidden: false,
    		allowBlank: true,
    		value : 1,
    		minValue: 1,
    		maxValue: 9
    	}]
    
    }, {
        html: ''
    },{
    	xtype:'fieldcontainer',
    	cls: 'form-fixed-footer',
    	width:'auto',
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype: 'button',
    		itemId: 'saveSelectionSetting',
    		ui: 'CustomBtnSubmit',
    		text: getCommonTranslation('SAVE'),
    		formBind: true
    	}]
    }]
});