/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show selected program details in grid
 *  
 */
var addProgramGridStore = Ext.create('Academia.store.enquiry.EnquiryGridStore');
Ext.define('Academia.view.admission.applicantFormSaleDirectSubmission.AddProgramGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.addprogramgrid',
   // store : 'admission.applicationFormSale.ProgramTabGridStore',
    store : addProgramGridStore,
    title: getAdmissionTranslation('APPLICATION_PROGRAM_DETAILS'), 
    refreshStoreData:true,
    applicationProgramType:'',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    isGridConfigurable : true,
    enableColumnHide: false,
    border: true,
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    },  {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }],
   /* dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'admission.applicationFormSale.ProgramTabGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],*/
    columns: [{
    	 header: getCommonTranslation('ACADEMY'), //Academy 
         dataIndex: 'academy',
         flex: .2,
         sortable: true,
         renderer : function(value){
        	 if(!isNullOrEmpty(value)){
        		 return value.value;
        	 }
         }
     }, {
         header: getCommonTranslation('LOCATION'), //Location
         dataIndex: 'location',
         flex: .2,
         sortable: true,
         renderer : function(value){
        	 if(!isNullOrEmpty(value)){
        		 return value.value;
        	 }
         }
     }, {
         header: getCommonTranslation('PROGRAM'), //Program
         dataIndex: 'program',
         flex: .2,
         sortable: true,
         renderer : function(value){
        	 if(!isNullOrEmpty(value)){
        		 return value.value;
        	 }
         }
     }, {
         header: getCommonTranslation('BATCH'), //Batch
         dataIndex: 'batch',
         flex: .2,
         sortable: true,
         renderer : function(value){
        	 if(!isNullOrEmpty(value)){
        		 return value.value;
        	 }
         }
     }, {
         header: getCommonTranslation('SEAT_TYPE'), //Seat Type
         dataIndex: 'seatType',
         flex: .2,
         sortable: true,
         renderer : function(value){
        	 if(!isNullOrEmpty(value)){
        		 return value.value;
        	 }
         }
	}, {
		header: getCommonTranslation('SCHOOL_ATTENDANCE_START_DATE'),
		dataIndex: 'schoolAttendanceStartDate',
		flex: .2,
		sortable: true,
		renderer: function(val) {
				if(!isNullOrEmpty(val)){
                   return dateRender(val);
                }
		}
	}]
});
