/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of Applicant Details in grid  
 */
Ext.define('Academia.view.admission.applicationFormSale.ApplicantGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.applicantgrid',
    store: 'admission.applicationFormSale.ApplicantGridStore',
    title: getAdmissionTranslation('LIST_OF_APPLICANTS'), //List of Applicants	
    plugins: [{
        ptype: 'rowexpander',
        pluginId: 'applicantRowExpander',
        rowBodyTpl: new Ext.XTemplate('<td colspan="5"><table style="border:1px solid black; width:100%;">', 
        		'<tr>',
        			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('ACADEMY') + '</th>',
        			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('LOCATION') + '</th>',
        			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('PROGRAM') + '</th>',
        			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('BATCH') + '</th>',
        			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('SEAT_TYPE') + '</th>',
        			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('FEES_AMOUNT') + '</th>',
        		'</tr>',
        		'<tpl for=".">',
        		'<tr>',
        			'<td style="width:100px;text-align:center">{academy}</td>',
        			'<td style="width:100px;text-align:center">{location}</td>', 
        			'<td style="width:100px;text-align:center">{program}</td>', 
        			'<td style="width:100px;text-align:center">{batch}</td>', 
        			'<td style="width:100px;text-align:center">{seatType}</td>', 
        			'<td style="width:100px;text-align:center">{feeAmount}</td>',
        		'</tr>', 
        		'</tpl>', 
        '</table></td>')
    }],
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    features: [{
        ftype: 'summary',
        dock: 'bottom'
    }],
    columns: [{
        header: getAdmissionTranslation('APPLICANT'), //Applicant
        dataIndex: 'applicantName',
        flex: .2
    }, {
        header: getAdmissionTranslation('SALE_REF_TYPE'), //Sale Ref Type
        dataIndex: 'saleRefType',
        renderer: function(value){
        	return getAdmissionTranslation(value);
        },
        flex: .2
    }, {
        header: getAdmissionTranslation('SALE_REF'), //Sale Ref
        dataIndex: 'saleRefId',
        flex: .2
    }, {
        header: getAdmissionTranslation('FEES_AMOUNT'), //Fees Amount
        dataIndex: 'totalFee',
        flex: .2,
        summaryType: 'sum',
        renderer: function(value, metaData, record, rowIdx, colIdx, store, view) {
            return value;
        },
        summaryRenderer: function(value, summaryData, dataIndex) {
        	if(!isNullOrEmpty(value) && value==0){
        		return '<span></span>';
        	}else{
        		return '<span><b>Total ' + value + '</b></span>';
        	}            
        }
    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            store: 'admission.applicationFormSale.ApplicantGridStore'
        }]
    }]
});
