/**
 * @author Prakash.sharma
 * 
 * This component is used for to show list of Existing Student in Dialog box
 * 
 */
Ext.define('Academia.view.admission.applications.admissionAndMidTermAdmission.AddExistingStudentToAdmissionWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.addexistingstudenttoadmissionwindow',
	modal: true,
	resizable: false,
	autoScroll: true,
	height: (Ext.isIE8) ? 600 : '60%',
			width: (Ext.isIE8) ? 500 : '60%',
					title: getPersonModuleTranslation('EXISTING_STUDENT_DETAILS'),
					items: [{
						xtype: 'idgeneratorformwin',
						layout: 'fit',
						itemId: 'admissionTypeForm',
						items: [
							{
								xtype: 'fieldcontainer',
								width: 'auto',
								layout: 'hbox',
								defaults: {
									labelAlign: 'top',
									width: 256
								},
								style: {
									marginLeft: '6px'
								},
								items: [{
									xtype: 'textfield',
									fieldLabel: getPersonModuleTranslation('STUDENT_NAME'),  
									itemId: 'studentName',									readOnly: true,
									width: 536,
									hidden:true,
									style:{marginLeft:'0px'}
								},{
									xtype: 'textfield',
									fieldLabel: getCommonTranslation('ADM_EXISUSER_NATIONAL_ID'),  
									itemId: 'nationalId',
									name: 'nationalId',                    
									readOnly: true,
									style:{marginLeft:'0px'}
								},{
									xtype: 'textfield',
									fieldLabel: getCommonTranslation('ADM_EXISUSER_SYSTEM_EXTERNAL_REF_ONE'),  
									itemId: 'externalSysRefOneId',   
									name: 'externalSysRefOne',                    
									readOnly: true,
									hidden:true,
									style:{marginLeft:'0px'}
								},{
									xtype: 'hidden',
									name: 'saveOrUpdate',
									itemId:'saveOrUpdateHidden'
								}]
							}

]
					},{
						xtype: 'existingstudentdetailgrid',
						itemId: 'existingstudentdetailgrid'
					}, {
						width: '100%',
						cls : 'windowBtnPos',
						style :{marginLeft: '16px'},

						items: [{
							xtype: 'button',
							text: getAdmissionTranslation('IMPORT'), //Proceed
							itemId: 'importExistingStudentId',
							ui: 'CustomBtnSubmit',
							scale: CONSTANTS.BUTTONSIZE,
							formBind: true
						}, {
							xtype: 'button',
							text: getCommonTranslation('CANCEL'), //Cancel
							action: 'cancel',
							ui: 'CustomBtnCancel',
							itemId: 'cancelBtn',
							scale: CONSTANTS.BUTTONSIZE
						}]
					}]
});