/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of offer letter accepted program in Dialog box
 * 
 */
Ext.define('Academia.view.admission.applications.admissionAndMidTermAdmission.EditAdmissionProgramWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.editadmissionprogramwindow',
	modal: true,
	resizable: false,
	autoScroll: true,
	height: (Ext.isIE8) ? 600 : '75%',
			width: (Ext.isIE8) ? 600 : '65%',
					title: getAdmissionTranslation('EDIT_PROGRAMS'), //Add Programs
					cls : 'panelNoSpace',
					items: [{
						xtype : 'form',
						itemId  : 'formId',
						items : [{
							xtype: 'addprogramwindowgrid',
							addApplicationProgramType:'ADMISSION_ADD_APPLICATION_PROGRAMS',
							itemId: 'applicantAdmissionEditApplicationProgramGrid',
							style: {
								marginTop: '10px'
							}
						},{
							xtype: 'dynamicfieldformwin',    	
							itemId:'applicantEditAdmissionForm',
							plugins : "formlabelrequired",
							title:getAdmissionTranslation('ENTER_ADMISSION_DETAILS'), //Enter admission details
							border:true,
							bodyPadding:'10px',
							layout:{
								type:'vbox'
							},
							items:[{
								xtype: 'fieldcontainer',
								width: '100%',
								itemId : 'periodAdmissionDateContainer',
								layout: 'hbox',
								defaults: {
									labelAlign: 'top',
									width: 256
								},
								items: [{
									xtype: 'customcombobox',
									name: 'period',
									itemId: 'cmbPeriod',
									fieldLabel: getAdmissionTranslation('SELECT_PERIOD'),//+' <span class="required" style="color:black"> :</span>'+' <span class="required" style="color:red"> *</span>', //Select Period
									store: 'admission.applications.admissionAndMidTermAdmission.PeriodComboStore',
									valueField: 'id',
									displayField: 'value',
									editable: false,
									disabled:true,
									queryMode: 'local',
									triggerAction: 'all',
									forceSelection: true,
									allowBlank: false
								},{
					                xtype: 'customcombobox',
					                name: 'section',
					                itemId: 'section',
					                fieldLabel: getPersonModuleTranslation('SECTION'),
					                editable: false,
					                queryMode: 'local',
					                disabled:true,
					                valueField: 'id',
					                displayField: 'value',
					                store:'coursetransaction.sectionmanagement.SectionsStore',
					                /*listeners: {
					                    render: function(combo) {
					                        var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
					                        combo.bindStore(store);
					                    }
					                }*/
					            },{
					    			xtype: 'datefield',
					    			name: 'admissiondate',
					    			itemId:'admissiondateEditId',
					    			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
					    			listeners: {
					    				render: function(field) {
					    					return dateFormatRender(field);
					    				}
					    			},
					    			editable:false,
					    			allowBlank:false,
					    			fieldLabel: getAdmissionTranslation('ADMISSION_DATE')
								}]
							},/*{
								xtype: 'fieldcontainer',
								width: '100%',
								itemId : 'advisorTypeOfAdmissionContainer',
								layout: 'hbox',
								defaults: {
									labelAlign: 'top',
									width: 256
								},
								items: [{
									fieldLabel: getAdmissionTranslation('ASSIGN_ADVISOR'),  //Assign Advisor
									xtype: 'customcombobox',
									name: 'advisiorId',
									itemId: 'advisior',                    
									store: 'common.ActiveUserStore',
									valueField: 'id',
									displayField: 'value',
									editable: false,                                       
									triggerAction: 'all',
									forceSelection: true
//									allowBlank: false,
								}, {
									xtype: 'customcombobox',
									fieldLabel: getAdmissionTranslation('TYPE_OF_ADMISSION'),   //Type Of Admission
									//Type Of Admission
									name: 'admissionType',
									itemId: 'typeOfAdmission',      
									store: 'admission.applications.admissionAndMidTermAdmission.TypeOfAdmissionComboStore',
									valueField: 'id',
									displayField: 'value',
									editable: false,
									allowBlank: false,
									renderer: function(value) {
										return getAdmissionTranslation(value);
									}
								}]
							}, {
								xtype : 'fieldcontainer',
								width: '100%',
								items: [{
									xtype: 'button',
									text: getAdmissionTranslation('PROGRAM_ADD'), //Add Admission
									itemId: 'addAdmissionBtn',
									ui: 'CustomBtnSubmit',
									scale: CONSTANTS.BUTTONSIZE,
									formBind: true
								}, {
									xtype: 'button',
									text: getCommonTranslation('CANCEL'), //Cancel Admission
									action: 'cancel',
									ui: 'CustomBtnCancel',
									itemId: 'cancelAdmissionBtn',
									scale: CONSTANTS.BUTTONSIZE
								}]
							}*/]    	
						}] }],
						initComponent: function() {    	     
							var window=this;
							this.callParent(arguments);
							var applicantEditAdmissionForm=window.down('#applicantEditAdmissionForm');
							if(applicantEditAdmissionForm){
								applicantEditAdmissionForm.insert(1,window.getAdvisorTypeOfAdmissionPanel());
								applicantEditAdmissionForm.insert(2,window.getExistingStudentField());
								applicantEditAdmissionForm.insert(3,window.getTrialAdmissionPanel());
								applicantEditAdmissionForm.insert(4,window.getProvisionalAdmissionPanel());
								applicantEditAdmissionForm.insert(5,window.getAddProgramButtonPanel());
								applicantEditAdmissionForm.doLayout();
							}
							var editProgramWindowGridPageRmv = window.down('addprogramwindowgrid');
							 //var toolbarItems = addProgramWindowGrid.dockedItems.items;
							editProgramWindowGridPageRmv.dockedItems.items[1].items.items[0].destroy();
							 return;
				        	   /*Ext.each(toolbarItems, function(cr){
				        		   if(cr.dock=="bottom"){
				        			   b = cr.setDocked();
				        			   b.remove();
				        		   }
				        		   })*/
						},
						getAdvisorTypeOfAdmissionPanel:function(){
							
							var advisorTypeOfAdmission = {
								xtype: 'fieldcontainer',
								width: '90%',
								itemId : 'advisorTypeOfAdmissionContainer',
								layout: 'hbox',
								defaults: {
									labelAlign: 'top',
									width: 256
								},
								items: [{
									fieldLabel: getAdmissionTranslation('ASSIGN_ADVISOR'),  //Assign Advisor
									xtype: 'customcombobox',
									name: 'advisiorId',
									itemId: 'advisior',                    
									store: 'common.ActiveUserStore',
									valueField: 'id',
									displayField: 'valueCode',
									forceSelection: true,
									queryParam:'name',
									minChars:3,
									emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
									 listConfig: {
											listeners: {
												beforeshow: function(picker) {
													picker.minWidth = picker.up('combobox').getSize().width;
													picker.width = picker.up('combobox').getSize().width;
												}
											},
									 loadingText: getCommonTranslation('SEARCHING'),
											emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
											getInnerTpl: function() {
												return '<div class="search-item">' +
												'{value}' +
												'</div>';
											}
										}
								}, {
									xtype: 'customcombobox',
									fieldLabel: getAdmissionTranslation('TYPE_OF_ADMISSION'),   //Type Of Admission
									//Type Of Admission
									name: 'admissionType',
									itemId: 'typeOfAdmission',      
									store: 'admission.applications.admissionAndMidTermAdmission.TypeOfAdmissionComboStore',
									valueField: 'id',
									displayField: 'value',
									editable: false,
									allowBlank: false,
									renderer: function(value) {
										return getAdmissionTranslation(value);
									}
								}, {
									xtype: 'datefield',
									fieldLabel: getCommonTranslation('SCHOOL_ATTENDANCE_START_DATE'),
									itemId: "schoolAttendanceStartDate",
									name: 'schoolAttendanceStartDate',
									allowBlank: true,
									editable: false,
									listeners: {
										render: function(field) {
											return dateFormatRender(field);
										}
									}
						        }]
							}
							return advisorTypeOfAdmission;
						},
						
						/*Existing student details*/
						getExistingStudentField:function(){
							
							var existingStudentTypeOfAdmission = {
								xtype: 'fieldcontainer',
								width: '100%',
								itemId : 'studentOfAdmissionContainer',
								layout: 'hbox',
								defaults: {
									labelAlign: 'top',
									width: 256
								},
								items: [{
									xtype: 'checkboxfield',
									itemId : 'isExistingStudent',
									labelAlign: 'right',
									style: {
										marginTop: '25px',
										marginLeft:'0px'
									},
									boxLabel: getPersonModuleTranslation('USE_EXISTING_STUDENT'),
									name: 'isExistingStudent',
									itemId:'isExistingStudent',
									inputValue: true,
									uncheckedValue: false                            
								}, {
									xtype: 'textfield',
									fieldLabel: getPersonModuleTranslation('STUDENT_ID'),  
									//name: 'existingStudentId',
									itemId: 'existingStudentId', 
									labelSeparator : '',
									readOnly: true,
									hidden:true,
									style:{marginLeft:'0px'}
								},{
							        xtype: 'hidden',
							        name: 'existingStudentId',
							        itemId:'studentIdHidden'
									},{
									xtype: 'button',
									text: getCommonTranslation('SEARCH_STUDENT'),
									itemId: 'searchStudentButtonItemId',
									ui: 'CustomBtnSubmit',
									hidden:true,
									style:{marginTop:'29px',
										padding: '5px'}
									
								}]
							}
							return existingStudentTypeOfAdmission;
						},
						
						
						getAddProgramButtonPanel:function(){
							
							var programButtonsPanel =  {
									xtype : 'fieldcontainer',
									width: '100%',
									itemId: 'addButtonsPanelContainer',
									items: [{
										xtype: 'button',
										text: getCommonTranslation('SAVE'), //Add Admission
										itemId: 'editAdmissionBtn',
										ui: 'CustomBtnSubmit',
										scale: CONSTANTS.BUTTONSIZE,
										//formBind: true
									}, {
										xtype: 'button',
										text: getCommonTranslation('CANCEL'), //Cancel Admission
										action: 'cancel',
										ui: 'CustomBtnCancel',
										itemId: 'cancelAdmissionBtn',
										scale: CONSTANTS.BUTTONSIZE
									}]
								}
							return programButtonsPanel;
						},
						getTrialAdmissionPanel:function(){
							var trialAdmissionPanel={
									xtype: 'fieldcontainer',
									width: '100%',
									itemId: 'trialAdmissionContainer',
									hidden: true,
									layout: {
										type: 'vbox'
									},
									defaults: {
										labelAlign: 'top'
									},           
									items: [{
										xtype: 'fieldcontainer',                                 
										itemId: 'trialAdmissionDateContainer',
										//hidden: true,
										layout: {
											type: 'hbox'
										},
										defaults: {
											labelAlign: 'top',
											width: 256                        
										},           
										items: [{
											xtype: 'datefield',
											fieldLabel: getAdmissionTranslation('TRIAL_START_DATE'), //Trial Start Date
											//Trial Start Date
											name: 'trialStartDate',
											itemId: 'trialStartDate',                        
											//--submitFormat: CONSTANTS.DATE_FORMAT,                        
											vtype: 'daterange',
											endDateField: 'trialEndDate',
											allowBlank: false,
											minvalue : new Date(),
											listeners: {
												render: function(obj) {
													obj = dateFormatRender(obj);						
													obj.setMinValue(new Date());						
												}
											}
										}, {
											xtype: 'datefield',
											fieldLabel: getAdmissionTranslation('TRIAL_END_DATE'),  //Trial End Date
											//Trial End Date
											name: 'trialEndDate',                        
											itemId: 'trialEndDate',
											//--submitFormat: CONSTANTS.DATE_FORMAT,                                                
											vtype: 'daterange',
											startDateField: 'trialStartDate',
											allowBlank: false,     
											minvalue : new Date(),
											listeners: {
												render: function(obj) {
													obj = dateFormatRender(obj);						
													obj.setMinValue(new Date());
												}
											}
										}]
									},{
										xtype: 'radiogroup',                    
										fieldLabel: getAdmissionTranslation('NO_CONCLUSION_TRIAL_END_DATE'),  //If no conclusion by trial end date, assume following decision                    
										name: 'RADIO_Btn',
										itemId:'trialRadio',
										width: 560,
										layout: 'hbox',
										items: [{
											boxLabel: getAdmissionTranslation('CONFIRMED'),  //Confirmed
											name: 'conclusion',
											inputValue: 'CONFIRMED',
											checked: true
										}, {
											boxLabel: getAdmissionTranslation('WITHDRAWN'),  //Withdrawn
											name: 'conclusion',
											inputValue: 'WITHDRAWN'
										}]
									}]                       
							};
							return trialAdmissionPanel;
						},
						getProvisionalAdmissionPanel:function(){
							var provisionalAdmissionPanel={
									xtype: 'fieldcontainer',                
									width: '100%',
									itemId: 'provisionalAdmissionPanel',
									hidden: true,
									layout: {
										type: 'vbox'
									},
									defaults: {
										labelAlign: 'top'
									},
									items: [{
									xtype: 'fieldcontainer',                                 
									itemId: 'trialAdmissionDateContainer',
									//hidden: true,
									layout: {
										type: 'hbox'
									},
									defaults: {
										labelAlign: 'top',
										width: 256                        
									},     
							        items : [{
										fieldLabel: getAdmissionTranslation('REASON_PROVISIONAL_ADMISSION'), //Reason for Provisional  Admission
										xtype: 'customcombobox',                        
										width: 256,
										store:'admission.admissionCommon.ProvisionalAdmissionReasonStore',
										itemId: 'provisionalAdmissionClosureReason',
										name: 'provisionalAdmissionClosureReason',
										valueField: 'value',
										displayField: 'value',
										allowBlank: false
									},{
										xtype: 'datefield',
										fieldLabel: getAdmissionTranslation('PROVISIONAL_LAST_DATE'), //Last Date for Provisional Confirmation 
										//Select Date
										name: 'provisionalLastDate',
										itemId: 'provisionalLastDate',
										//--submitFormat: CONSTANTS.DATE_FORMAT,
										allowBlank: false,
										minValue : new Date(),
										width: 256,
										labelWidth:'auto',
										//vtype: 'daterange',
										//endDateField: 'endDate',
										listeners: {
											render: function(field) {
												return dateFormatRender(field);
											}
										}
									}]}, {
										xtype: 'radiogroup',
										fieldLabel: getAdmissionTranslation('NO_CONCLUSION_LAST_DATE'), //If no conclusion by last date, assume following decision
										name: 'RADIO_Btn', 
										itemId:'provisionalRadio',
										width: 560,
										layout: 'hbox',
										items: [{
											boxLabel: getAdmissionTranslation('CONFIRMED'),  //Confirmed
											name: 'conclusion',
											inputValue: 'CONFIRMED',
											checked: true
										}, {
											boxLabel:getAdmissionTranslation('DENIED'),  //Denied
											name: 'conclusion',
											inputValue: 'DENIED'
										}]
									}]            
							};
							return provisionalAdmissionPanel;
						}
});