Ext.define('Academia.view.admission.applications.applicantProfileBase.ApplicationAcademicsTopicQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.applicationacademicstopicquicksearchform',
    frame: false,
    plugins: "formlabelrequired",
    cls:'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype:'hidden',
        	name:'iscurruntPeriod',
           itemId:'iscurruntPeriodId',
        },   
        {
            xtype: 'customcombobox',
            name: 'academicTopicId',
            itemId: 'academicTopicItemId',
            fieldLabel: getPersonModuleTranslation('ACADEMICS_TOPIC'),
            editable: false,
            allowBlank: true,
            valueField: 'id',
            displayField: 'value',
            store:Ext.create('Academia.store.student.studentprofile.AcademicTopicUserIdStore'),
            queryMode: 'local',
        },{
            xtype: 'customcombobox',
            name: 'academicSubTopicId',
            itemId: 'academicSubTopicItemId',
            fieldLabel: getPersonModuleTranslation('ACADEMICS_SUB_TOPIC'),
            editable: false,
            allowBlank: true,
            disabled:true,
            valueField: 'id',
            displayField: 'value',
            store:Ext.create('Academia.store.student.studentprofile.AcademicSubTopicStore'),
            queryMode: 'local',
        },{
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'programItemId',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            allowBlank: true,
            valueField: 'id',
            displayField: 'value',
            queryParam:'name',
            store : Ext.create('Academia.store.common.ApplicantProgramByApplicationIdStore'),
            allowBlank: true,
  			minChars:3,
  			typeAhead:false,
              emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
              forceSelection:true,
              listConfig: {
                  listeners: {
                  beforeshow: function(picker) {
                    picker.minWidth = picker.up('combobox').getSize().width;
                    }
                  },
                  loadingText: getCommonTranslation('SEARCHING'),
                  emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                  getInnerTpl: function() {
                    return '<div class="search-item">' +
                    '{code} / {value}'+
                    '</div>';
                    }
                  }
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'batch',
            itemId: 'batchCombo',
            displayField: 'value',
            valueField: 'id',
            disabled:true,
            editable: false,
            allowBlank: true,
            store : Ext.create('Academia.store.common.ApplicantBatchByProgramIdStore'),
            fieldLabel: getPersonModuleTranslation('BATCH'),
        },{
            xtype: 'customcombobox',
            name: 'period',
            itemId: 'periodId',
            fieldLabel: getPersonModuleTranslation('PERIOD'),
            editable: false,
            disabled:true,
            allowBlank: true,
            valueField: 'id',
            displayField: 'value',
            store:Ext.create('Academia.store.common.ApplicantPeriodByBatchIdStore'),
        }]

    },{
        xtype: 'fieldcontainer',
        width: '100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'applicationAcademicTopicSearchButtonId',
            ui: 'CustomBtnSubmit',
            formBind: true,
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCompletionModuleTranslation('CLEAR_SEARCH'),
            itemId: 'clearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            listeners: {
                click: function(button, eOpts) {
                	this.up('form').getForm().reset();
                }
            }
        }]
    }]
});
