/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.applications.applicantProfileBase.ApplicationListExportReporWidow', {
	extend: 'Ext.window.Window',
	alias: 'widget.applicationlistexportreporwidow',
	modal: true,
	frame: true,
	title:getAdmissionTranslation('APPLICATION_LIST_EXPORT_REPORT'),
	items: [{		
    xtype: 'form',
    defaults:{
    	labelAlign:'top',
    	width: 256
    },
    standardSubmit: false,
    plugins:"formlabelrequired",    
    items:[{
    	xtype:'hidden',
    	itemId:'exportType'
    },{
	   	 xtype : 'radiogroup',
		 itemId:'radioGroupApplicationList',
		 style:{
		    	marginLeft:'8px'
		    },
	    	defaults: {
	            flex: .1
	        },
	   	 items : [{
	   		 boxLabel : 'PDF',
	   		 name : 'printListData',
	   		 inputValue : 'pdf',
	   		 checked : true
	   		 
	   	 },{
	   		 boxLabel : 'Excel',
	   		 name : 'printListData',
	   		 inputValue : 'vnd.ms-excel'
	   	 }]
	   },{
    	xtype: 'customcombobox',
    	fieldLabel: getAdmissionTranslation('APPLICATION_LIST_EXPORT_LIMIT'),
    	itemId: 'applicationListExport',
    	name: 'applicationListExport',
    	store:'admission.applications.applicantProfileBase.ApplicationListExportReportStore',
    	valueField:'id',
    	displayField:'value',
    	allowBlank:false,
    },{
		xtype: 'fieldcontainer',
		width:'100%',
		items: [{
			xtype: 'button',
			itemId: 'btnAppListExport',
			text : getCommonTranslation('Export'),
			buttonAlign : 'left',
			ui : 'CustomBtnThird',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}]	
	}]
	}]
});
