Ext.define('Academia.view.admission.applications.applicantProfileBase.TransferCreditsQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.transfercreditsquicksearchform',
    frame: false,
    plugins: "formlabelrequired",
    cls:'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [   
        {
			xtype: 'customcombobox',
			width: 536,
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			name: 'programCodeNameATC',
			itemId: 'programCodeNameATCItemId',
			autoload: false,
			//store:Ext.create('Academia.store.admission.applications.applicantProfileBase.programCodeOrNameATCStore'),
			valueField: 'programId',
			displayField: 'value',
			queryMode: 'remote',
			queryParam:'qry',
		//	typeAhead : true,
            forceSelection:true,
            hideTrigger:false,
            triggerAction: 'all',
            minChars:3,
            allowBlank: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{programCode} / {value}'+ 
	                    '</div>';
	                }
				},
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.admission.applications.applicantProfileBase.programCodeOrNameATCStore');
						combo.bindStore(store);
					}
				},
		},{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('BATCH'),  
			name: 'batchATC',
			itemId: 'batchATCItemId',
			editable: true,
			autoload: false,
			typeAhead:false,
			disabled:true,
			valueField: 'id',
			displayField: 'value',
			queryMode : 'remote',
			minChars:3,
			allowBlank: false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    forceSelection:true,
		       listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
			},
			listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
    	}
        ]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'applicantTranferCreditsSearchButtonId',
            ui: 'CustomBtnSubmit',
            formBind: true,
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCompletionModuleTranslation('CLEAR_SEARCH'),
            itemId: 'clearSearchATCItemID',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            listeners: {
                click: function(button, eOpts) {
                	this.up('form').getForm().reset();
                }
            }
        }]
    }]
});
