Ext.define('Academia.view.admission.applications.applicantProfileBase.TransferCreditsStructure', {
    extend: 'Ext.form.Panel',
    alias: 'widget.transfercreditsstructure',

    frame: false,
    plugins: 'formlabelrequired',
    title: getCommonTranslation('APPLICANT_TRANSFER_CREDITS'),

    layout: {
        type: 'vbox',
        align: 'stretch'
    },

    width: '100%',
    bodyStyle: 'overflow-x:hidden;',

    listeners: {
        resize: function (panel) {
            var parent = panel.up();
            if (parent) {
                panel.setWidth(parent.getWidth());
            }
        }
    },

    items: [{
        xtype: 'panel',
        cls: 'transferCreditSearchValuesCls',
        layout: 'fit',
        items: [{
            xtype: 'transfercreditsquicksearchform',
            itemId: 'transfercreditsquicksearchform'
        }]
    }, {
        xtype: 'panel',
        cls: 'transferCreditGridCls',
        layout: 'fit',
        items: [{
            xtype: 'transfercreditsgrid',
            itemId: 'transfercreditsgrid'
        }]
    }, {
        xtype: 'panel',
        cls: 'transferCreditGridValuesCls',
        layout: 'fit',
        items: [{
            xtype: 'transfercreditsgridformvalues',
            itemId: 'transfercreditsgridformvalues'
        }]
    }],

    dockedItems: [{
        xtype: 'fieldcontainer',
        dock: 'bottom',
        layout: {
            type: 'hbox',
            pack: 'start'
        },
        style: {
            marginLeft: '22px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SAVE'),
            name: 'btnSave',
            itemId: 'btnSaveATCItemId',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            disabled: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            cls: 'btn-with-no-icon',
            name: 'btnReset',
            itemId: 'btnResetATCItemId',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            disabled: true
        }]
    }]

    /* initComponent not required */
});