/**
 * @author prathamesh.sheth
 * 
 * This component is used for to add admission Dialog box.
 */
Ext.define('Academia.view.admission.applications.applicationBase.AddAdmissionWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.addadmissionwindow',
    modal: true,
//    autoScroll: true,
    overflowX:'hidden',
    overflowY:'auto',
//    height: (Ext.isIE8) ? 600 : '60%',
    height:380,
    width:1300,
//    width: (Ext.isIE8) ? 600 : '70%',
//    style:{padding:'21px 4px 20px'},
    cls:'mainAddApplicantForm',
    title: getAdmissionTranslation('FORM_SUBMISSION'), //Form Submission
    items: [{
        xtype: 'idgeneratorformwin',
        layout: 'vbox',
        itemId: 'admissionTypeForm',
        style:{marginBottom:'0px'},
        items: [
        	{
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: 'vbox',
                defaults: {
                    labelAlign: 'top',
                },
                style: {
                    marginLeft: '6px'
                },
                items: [{
                    xtype: 'label',
                    itemId: 'actionRadioButtonLabel',
                    text: getAdmissionTranslation('SELECT_ACTION'),
                    style: {
                        marginLeft: '5px'
                    },
                    //width: 256
                }, {
                    xtype: 'radiogroup',
                    itemId: 'actionRadioButtonsPanel',
                    width: 650,
                    style: {
                        marginTop: '5px',
                        marginLeft: '0px'
                    },
                    defaults: {
                        flex: .1
                    },
                    items: [{
                		boxLabel: getAdmissionTranslation('CREATE_NEW_APPLICATION'), //Create New Application
                		name: 'admissionType',
                		inputValue: 'NEW_APPLICATION',
                		checked:true                
                	},{
                		boxLabel: getAdmissionTranslation('DIRECT_ADMISSION'), //Direct Admission
                		name: 'admissionType',
                		inputValue: 'DIRECT_ADMISSION',
                	}, {
                		boxLabel: getAdmissionTranslation('MID_TERM_ADMISSION'), //Mid-Term Admission
                		name: 'admissionType',
                		inputValue: 'MID_TERM_ADMISSION',
                	}]
                }]
            }
        	
        	
        	/*{
        	xtype: 'fieldcontainer',
        	labelAlign: 'top',
        	fieldLabel:getAdmissionTranslation('SELECT_ACTION'), //Select Action
        	//width: '100%',        
        	//autoWidth:true,
        	itemId: 'actionRadioButtonsPanel',        
        	layout: {
        		type: 'hbox'
        	},
        	style: {
        		marginLeft: '10px'
        	},
        	items: [{
        		xtype: 'radiofield',
        		boxLabel: getAdmissionTranslation('CREATE_NEW_APPLICATION'), //Create New Application
        		name: 'admissionType',
        		inputValue: 'NEW_APPLICATION',
        		itemId: 'newApplicationRadioField',
        		checked:true                
        	},{
        		xtype: 'radiofield',
        		boxLabel: getAdmissionTranslation('DIRECT_ADMISSION'), //Direct Admission
        		name: 'admissionType',
        		inputValue: 'DIRECT_ADMISSION',
        		itemId: 'directAdmissionRadioField'
        	}, {
        		xtype: 'radiofield',
        		boxLabel: getAdmissionTranslation('MID_TERM_ADMISSION'), //Mid-Term Admission
        		name: 'admissionType',
        		inputValue: 'MID_TERM_ADMISSION',
        		itemId: 'midtermAdmissionRadioField'
        	}]
        }*/]
   },{
    	xtype:'applicantsearchcomponent',
    	itemId:'applicantSearchComponent',
    	minWidth: 850,
    	cls:'addApplicantForm',
    },{
        xtype: 'grid',
        //layout: 'fit',
        hidden:true,
        itemId: 'searchGrid',
        title: getAdmissionTranslation('SEARCH_RESULT'), //Search Result
        isFixHeightGrid: true,
        //minHeight: 0,
        viewConfig: {
            stripeRows: CONSTANTS.STRIPEROWS
        },
        border: true,
        //autoScroll: true,
        columns: []
    }, {
    	width: 600,
		cls : 'windowBtnPos',
		style :{'margin-left': '16px'},
		items: [{
            xtype: 'button',
            text: getAdmissionTranslation('PROCEED'), //Proceed
            itemId: 'proceedBtn',
            ui: 'CustomBtnSubmit',
            cls:'btn-with-no-icon',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'), //Cancel
            action: 'cancel',
            ui: 'CustomBtnCancel',
            cls:'btn-with-no-icon',
            itemId: 'cancelBtn',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});
