/**
 *Harshit patidar
 */

Ext.define('Academia.view.admission.applications.applicationBase.ApplicationAndAdmissionCommentForm', {
	extend: 'Ext.window.Window',
	alias: 'widget.applicationandadmissioncommentform',
	autoScroll: true,
	title:getCommonTranslation('APPLICATION_AND_ADMISSION_COMMENTS'),
	modal:true,
	frame: true,
	items: [{
		xtype: 'idgeneratorformwin',

		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			//width: 256
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'

		},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{  
				xtype: 'hidden',
				name: 'id'
			},{
				xtype: 'customcombobox',
				name: 'applicationOwner',
				itemId:'applicationOwner',
				 store: Ext.create('Academia.store.enquiry.FollowUpUserWithDepartment'),
				 fieldLabel: getAdmissionTranslation('APPLICATION_REASSIGN_TO'),
				 valueField: 'id',
				 displayField: 'value',
				 queryParam:'name',
				 minChars:3,
				 editable:true,
				 typeAhead:true,
				 triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				 enableKeyEvents  : 'true',
				 hideTrigger:false,
				 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				 triggerAction: '',
				 forceSelection:true,
				 allowBlank:false,
				 listConfig: {
					 listeners: {
						 beforeshow: function(picker) {
							 picker.minWidth = picker.up('combobox').getSize().width;
						 }
					 },
					 loadingText: getCommonTranslation('SEARCHING'),
					 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					 getInnerTpl: function() {
						 return '<div class="search-item">' +
						 '{value}'+
						 '</div>';
					 }
				 }
			 },{
				xtype: 'datefield',
				name: 'reassignOwnerdate',
				maxValue: new Date(),
				fieldLabel: getAdmissionTranslation('APPLICATION_REASSIGNMENT_DATE'),
				listeners: {
					render: function(field) {
						dateFormatRender(field);
						field.setValue(new Date());
					}
				}
			},
			]
		},{
			    xtype: 'fieldcontainer',
			    layout: 'vbox',
			    defaults: {
			        labelAlign: 'top',
			        width: 536
			    },
			    items: [{
			        xtype: 'textarea',
			        name: 'reassignOwnerRemark',
			        itemId: 'remarkItemId',
			        allowBlank: false,
			        maxLength: 5000,
					height:150,
			        fieldLabel: getCommonTranslation('APPLICATION_AND_ADMISSION_COMMENTS_FILED'),
			        listeners: {
			            render: function(field) {
			                var maxLength = 5000;

			                var displayField = field.up('fieldcontainer').down('#reassignOwnerRemarkCounter');
			                displayField.setValue('<span class="required" style="color:red;">' + getMessagingModuleTranslation('MAX_LENGTH_MESSAGE') +': '+ ' 0/' + maxLength + '</span>');

			                // Update the character counter on input events
			                field.inputEl.on('input', function() {
			                    var length = field.getValue().length;
			                    displayField.setValue('<span class="required" style="color:red;">' + getMessagingModuleTranslation('MAX_LENGTH_MESSAGE') +': '+ ' ' + length + '/' + maxLength + '</span>');
			                });
			            }
			        }
			    }, {
			        xtype: 'displayfield',
			        name: 'reassignOwnerRemarkCounter',
			        itemId: 'reassignOwnerRemarkCounter',
			        height:35,
			        cls:'reassignOwnerRemarkCounterCls',
			        value: '<span class="required" style="color:red;">' + getMessagingModuleTranslation('MAX_LENGTH_MESSAGE') +': '+ ' 0/5000</span>',
			        style: 'color: red; text-align: right;',  // Align to the bottom right
			        listeners: {
			            render: function(field) {
			                var maxLength = 5000;  
			                field.setValue('<span class="required" style="color:red;">' + getMessagingModuleTranslation('MAX_LENGTH_MESSAGE') +': '+ ' 0/' + maxLength + '</span>');
			            }
			        }
			    }]
		},
		{
			xtype : 'fieldcontainer',
			cls : 'windowBtnPos',
			items: [{

				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'ard_submitbuttonId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			}, {	
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId:'ard_cancelbuttonId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});