/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.applications.applicationBase.ApplicationConditionsDocumentUpdateList', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.applicationconditionsdocumentupdatelist',
    title: getCommonTranslation('LIST_OF_APPLICABLE_DOCUMENTS'),
    border: true,
    autoScroll: false,
    columnLines : true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel:Ext.create('Ext.selection.CheckboxModel',{
		checkOnly: true,
	    mode: 'multi',
    	showHeaderCheckbox : false
    }),
    columns: [{
        header: getDocumentTranslation('DOCUMENT_NAME'),
        dataIndex: 'value',
        //align: 'center',
        sortable: true,
        flex: .2
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        this$.selModel=Ext.create('Ext.selection.CheckboxModel',{    		    	
			checkOnly: true,
		    mode: 'multi'
        });
        Ext.apply(this$, {
            store: store,
          /*  dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
                    displayInfo: true
                }]
            }]*/
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.document.DocumentConditionalOfferLetterPendingStore');
    }
});