/**
 * @author Harshit patidar
 * 
 */
Ext.define('Academia.view.admission.applications.applicationBase.BulkOfferStatusUpdateDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.bulkofferstatusupdatedownloadform',
	frame: false,
	method : 'POST',
	//cls:'customSearchPanel',
	standardSubmit : false,
		items:[{
			xtype: 'fieldcontainer',
			width: '100%',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items : [{
				xtype: 'multiselectcombofield',
				width: 700,
				name: 'multiselectAcademyLocation',
				itemId: 'academyLocationId',
				allowBlank : false,
				fieldLabel : getAdmissionTranslation('ACADEMY_LOCATION'),
				store:'common.AcademyLocationNameSeparated',
				displayField:'value',
				valueField:'id',
				matchFieldWidth:true,
				queryMode:'local',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}}]
			},
			{
				xtype: 'fieldcontainer',
				width: 'auto',
				layout: 'hbox',
				defaults: {
					width: 300,
					labelAlign: 'top'
				},
				items: [{			
					xtype : 'multiselectcombofield',
					//cls:'commonAutoHeightMultiselectField',
					fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
					autoloadStore: false,
					name : 'programId',
					itemId : 'program',      	   
					displayField : 'valueCode',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,
					allowBlank : false,
					maxLength:55000,
					minChars: 3,
					hidden : false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					queryMode:'remote',
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					matchFieldWidth:true,
					listeners: {
						render: function(combo) {
							var store = Ext.create('Academia.store.program.ConfiguredProgramListStore');
							combo.bindStore(store);
						},
					},
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							},
							afterRender: function(combo){
								combo.getStore().on("load", function(store, items){
									if(items.length==0)
										Ext.select('.x-boundlist-item').elements[0].hidden = true;
									else
										Ext.select('.x-boundlist-item').elements[0].hidden = false;
						        });
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}' +
							'</div>';
						}
					},
				},{
					xtype : 'multiselectcombofield',
					//cls:'commonAutoHeightMultiselectField',
					fieldLabel : getCourseTxCommonTranslation('BATCH'),
					autoloadStore: false,
					name : 'batch',
					itemId : 'batch',
					displayField : 'value',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,						
					queryMode:'remote',
					minChars:3,
					allowBlank : true,
					maxLength:55000,
					hidden : false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					matchFieldWidth:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listeners: {
						render: function(combo) {
							var store = Ext.create('Academia.store.program.ConfiguredBatchListStore');
							combo.bindStore(store);
						}
					},
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
							'{code} / {value}'+ 
							'</div>';
						}
					},
				},{
					xtype : 'multiselectcombofield',
					//cls:'commonAutoHeightMultiselectField',
					fieldLabel: getEnquiryTranslation('SEAT_TYPE'),
					autoloadStore: false,
					name: 'SEAT_TYPE',
					itemId:'seatType',
					displayField: 'value',
					valueField: 'id',
					typeAhead : true,
					forceSelection : true,
					queryMode: 'local',
					allowBlank : true,
					maxLength:55000,
					hidden : false,
					matchFieldWidth:true,
					listeners: {
						render: function(combo) {
							var store = Ext.create('Academia.store.program.ConfiguredSeatTypeListStore');
							combo.bindStore(store);
						}
							},
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code} / {value}'+ 
							'</div>';
						}
					},
				}]
			},			 
			
			{
				xtype: 'fieldcontainer',
				width: 'auto',
				layout: 'hbox',
				defaults: {
					width: 300,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'customcombobox',
					fieldLabel: getCommonTranslation('OFFER_STATUS'),
					name: 'offerstatus',
					itemId: 'offerstatus',
					store: 'admission.applications.applicationBase.ApplicationOfferStatusComboStore',                 
					valueField: 'name',
					displayField: 'value',
					queryMode : 'local'
				},
			
					{
					xtype: 'datefield',
					name: 'START_DATE',
					itemId: 'START_DATE',
					vtype: 'daterange',
					endDateField: 'END_DATE',
					fieldLabel: getAdmissionTranslation('START_DATE'),
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					}
				}, {
					xtype: 'datefield',
					name: 'END_DATE',
					itemId: 'END_DATE',
					vtype: 'daterange',
					startDateField: 'START_DATE',
					fieldLabel: getAdmissionTranslation('END_DATE'),
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					}
				}]
				}, {
					xtype:'fieldcontainer',
					layout : 'hbox',
					margin: '0 0 0 -24',
		    		cls: 'customSearchPanelBtnsFieldContainerCls',
					items:[{
			           	 xtype: 'button',
			        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
			             itemId: 'downoladBtnId',
			             hidden:false,
			             ui: 'CustomBtnSubmit',
			             formBind:true
			        },{
		                xtype: 'button',
		                text: getCourseTxCommonTranslation('RESET'),
		                itemId: 'resetBtn',
		                //buttonAlign: 'left',
		                ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
		            }]
				}]
            });
