/**
 * @author Vyabha Thakur
 * 
 */
Ext.define('Academia.view.admission.applications.applicationBase.BulkUpdateApplicationStatusDownloadForm', {
	extend: 'Ext.form.FormPanel',
	alias: 'widget.bulkupdateapplicationstatusdownloadform',
	frame: false,
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
		items: [{
			xtype: 'fieldcontainer',
			width: '100%',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
				name: 'ACAD_LOC_ID',
				itemId: 'academyLocationCombo',
				editable: false,
				store: 'user.UserAcademyLocationStore',
				displayField: 'value',
				valueField: 'id',
				width: 460,
				matchFieldWidth: true,
				allowBlank: false,
				forceSelection: true,
				queryParam: 'qry'
			}, {
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('INTAKE_YEAR'),
				name: 'intakeYear',
				itemId: 'intakeYear',
				displayField: 'value',
				valueField: 'id',
				store: 'common.IntakeYearStore',
				forceSelection: true,
				editable: false,
				allowBlank: false,
				matchFieldWidth: true,
				width: 226
			}, {
				xtype: 'multiselectcombofield',
				cls:'manageFeePlanMultiselect',
				fieldLabel: getAdmissionTranslation('PROGRAM_GROUP'),
				autoloadStore: false,
				store: 'program.ProgramGroupByAccessibleALStore',
				name: 'PROGRAM_GROUP',
				itemId: 'programGroup',
				typeAhead: true,
				forceSelection: true,
				hideTrigger:false,
			    triggerAction: 'all',
				valueField: 'id',
				displayField: 'value',
				queryMode: 'local',
				matchFieldWidth: true,
				width: 226,
				allowBlank: true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
							'{code} / {value}' +
							'</div>';
					}
				}
			}]
		}, {
			xtype: 'fieldcontainer',
			width: '100%',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items: [{
				xtype: 'multiselectcombofield',
				cls:'manageFeePlanMultiselect',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				store: 'program.ProgramByProgramGroupIdsStore',
				autoloadStore: false,
				name: 'PROGRAM_NAME',
				itemId: 'program',
				displayField: 'valueCode',
				valueField: 'id',
				typeAhead: true,
				forceSelection: true,
				hideTrigger:false,
				triggerAction: 'all',
				allowBlank: true,
				width: 226,
				queryMode: 'local',
				matchFieldWidth: true,
				//disabled: true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
							'{code} / {value}' +
							'</div>';
					}
				},
			}, {
				xtype: 'multiselectcombofield',
				cls:'manageFeePlanMultiselect',
				fieldLabel: getCourseTxCommonTranslation('BATCH'),
				autoloadStore: false,
				store: 'enquiry.AcademicBatchOnALIntakePeriodsStores',
				name: 'BATCH_NAME',
				itemId: 'batch',
				displayField: 'value',
				valueField: 'id',
				typeAhead: true,
				forceSelection: true,
				hideTrigger:false,
				triggerAction: 'all',
				allowBlank: true,
				width: 226,
				queryMode: 'local',
				disabled: true,
				matchFieldWidth: true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
							'{code} / {value}' +
							'</div>';
					}
				},
			}, {
				xtype: 'multiselectcombofield',
				cls:'manageFeePlanMultiselect',
				fieldLabel: getEnquiryTranslation('SEAT_TYPE'),
				autoloadStore: false,
				store: 'common.SeatTypeByBatchIds',
				name: 'SEAT_TYPE',
				itemId: 'seatType',
				displayField: 'value',
				valueField: 'id',
				typeAhead: true,
				forceSelection: true,
				hideTrigger:false,
				triggerAction: 'all',
				allowBlank: true,
				width: 226,
				queryMode: 'local',
				disabled: true,
				matchFieldWidth: true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
							'{code} / {value}' +
							'</div>';
					}
				},
			}, {
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('APPLICATION_STATUS'),
				name: 'applicationstatus',
				itemId: 'applicationstatus',
				store: 'admission.applications.applicationBase.ApplicationStatusLoaderComboStore',
				valueField: 'name',
				displayField: 'value',
				queryMode: 'local',
				matchFieldWidth: true,
				allowBlank: false,
				width: 226,
				editable: false
			}]
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
			items: [{
				xtype: 'button',
				text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
				itemId: 'downoladBtnId',
				hidden: false,
				ui: 'CustomBtnSubmit',
				formBind:true
			}, {
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			
		}]
	}]
});
