/**
 * @author Pravin.Surve
 *Final admission list search view
 */
Ext.define('Academia.view.admission.finalAdmissionList.FinalAdmissionQuickSeachForm', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.finaladmissionquickseachform',
    frame: false,
    cls:'customSearchPanel', 
    standardSubmit: false,
    items: [{
            xtype: 'fieldcontainer',
            itemId: 'admissionStatusConatiner',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getAdmissionTranslation('APPLICATION_NUMBER'),
                name: 'ADMISSION_NUMBER',
                itemId:'applicationID',
        		store:Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.ApplicantFieldPaginationStore'),
    			fieldLabel:getAdmissionTranslation('APPLICATION_NO'),
    			width: 536,
				//pageSize:25,
    			valueField: 'code',
    			displayField: 'code',
    			queryParam:'codeOrName',
    			minChars:3,
    			typeAhead:false,
    			hideTrigger:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerAction: '',
    			forceSelection:true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}'  +
    					'</div>';
    				}
    			}
            },{
                xtype: 'customcombobox',
                fieldLabel: getAdmissionTranslation('ADMISSION_STATUS'),   
                name: 'ADMISSION_STATUS',
                itemId: 'admissionStatus',
                editable: false,
                valueField: 'name',
                displayField: 'value',
                queryMode : 'local',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.admission.applications.applicationBase.AdmissionStatusComboStore');
                        combo.bindStore(store);
                    }
                }
            }]
        },{
            xtype: 'fieldcontainer',
            itemId: 'studentCodeFilter',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
               /* xtype: 'textfield',
                fieldLabel: getAdmissionTranslation('STUDENT_NAME'),
                name: 'STUDENT_NAME'*/
    				xtype: 'customcombobox',
    				itemId:'studentItemId',
    				name: 'STUDENT_NAME',
    				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
//    				store: 'feeandpayment.managebill.Student',
//    				store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
    				store: Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.StudentFieldPaginationStore'),
    				valueField: 'code',
    				displayField: 'valueCode',
    				queryParam:'name',
    				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    				enableKeyEvents  : 'true',
    				minChars:3,
    				width: 536,
    				pageSize:25,
    				typeAhead:false,
    				forceSelection:true,
    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    				triggerAction: '',
    				hideTrigger:false,
    				listConfig: {
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    					loadingText: getCommonTranslation('SEARCHING'),
    					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{code} / {value}' +
    						'</div>';
    					}
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            itemId: 'finalAdmissionListAcademyYearContainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('INTAKE_YEAR'),
				name : 'intakeYear',
				itemId : 'intakeYear',
				displayField:'value',
				valueField:'id',
				width: 256,
				typeAhead:false,
				forceSelection:true,
				minChars:3,
				queryMode:'remote',
				editable:false,
				store:Ext.create('Academia.store.common.IntakeYearStore'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				},
		/*		listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.IntakeYearStore');
						combo.bindStore(store)
					}
				}*/
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'academicTerm',
				itemId : 'academicTerm',
				displayField : 'value',
				valueField : 'id',
				typeAhead : false,
				forceSelection : true,
				minChars:3,
				queryMode:"remote",
				hidden : false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				store:Ext.create('Academia.store.common.AcademicTermStore'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
				}
	/*			listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.AcademicTermStore');
						combo.bindStore(store)
					}
				}*/
			},{
	        	xtype: 'customcombobox',
	            name: 'PROGRAMGROUP',
	            itemId:'programGroupItemId',
	            fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
	            displayField:'value',
	            valueField:'id',
	            store:Ext.create('Academia.store.program.ProgramGroupStore'),
	            forceSelection:true,
	   /*         listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.program.ProgramGroupStore');
						combo.bindStore(store)
					}
				}*/
	        }]}, {
            xtype: 'fieldcontainer',
            itemId: 'finalAdmissionProgBatSeatContainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype: 'customcombobox',
                name: 'PROGRAMCATEGORY',
                itemId:'programCategoryId',
                fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
                store:Ext.create('Academia.store.program.ProgramCategoryStore'),
                displayField:'value',
                valueField:'id',
                forceSelection:true,
     /*           listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.program.ProgramCategoryStore');
						combo.bindStore(store)
					}
				}*/
            },{
	       	 xtype: 'customcombobox',
	    	 fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
	    	 store:Ext.create('Academia.store.common.ProgramsByAcademyLocationsIds'),
	        // editable: false,
	         name: 'PROGRAM',
	         itemId: 'programId',
	         valueField: 'id',                
	         displayField: 'valueCode',
				forceSelection:true,
				queryParam:'programName',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{code} / {value}'+
		                    '</div>';
		                }
		            }
	    },{
	        xtype: 'customcombobox',
	        fieldLabel: getAdmissionTranslation('BATCH'),
	        editable: true,
	        disabled: true,
	        name: 'BATCH',
	        itemId: 'batchId',
	        valueField: 'id',                
	        displayField: 'value',
	        queryMode: 'local',
	        minChars:3,
	        forceSelection:true,
	        anyMatch:true,
	        typeAhead:false,
	        emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
	    }]
        }, {
            xtype: 'fieldcontainer',
            itemId: 'finalAdmissionListQuotaContainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
    	        xtype: 'customcombobox',
    	        fieldLabel: getAdmissionTranslation('SEAT_TYPE'),
    	        editable: false,
    	        disabled: true,
    	        name: 'SEAT_TYPE',
    	        itemId: 'seatTypeId',
    	        valueField: 'seatTypeId',                
    	        displayField: 'seatTypeName',
    	        queryMode: 'local',
    	        listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.common.SeatTypesByBatchId');
                        combo.bindStore(store);
                    }
                }
        },{
                xtype: 'customcombobox',
                fieldLabel: getAdmissionTranslation('QUOTA_TYPE'),
                editable: false,
                name: 'QUOTA_TYPE',
                itemId: 'quotaTypeId',
                displayField: 'code',
                valueField: 'id',
                queryMode: 'remote',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.admission.selectionProcess.QuotaTypes');
                        combo.bindStore(store);
                    }
                }
            },{
                xtype: 'customcombobox',
                fieldLabel: getAdmissionTranslation('QUOTA'),
                editable: false,
                disabled: true,
                name: 'QUOTA',
                itemId: 'quotaId',
                displayField: 'code',
                valueField: 'id',
                queryMode: 'remote',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.admission.quotas.QuotaLists');
                        combo.bindStore(store);
                    }
                }
            } ]
        },
            {
                xtype: 'fieldcontainer',
                itemId: 'finalAdmissionListDateContainer',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                items: [{
        			xtype: 'datefield',
        			name: 'START_DATE',
        			itemId: 'START_DATE',
        			vtype: 'daterange',
        			endDateField: 'END_DATE',
        			fieldLabel: getAdmissionTranslation('START_DATE'),
//        			allowBlank: false,
        			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
//        			format: CONSTANTS.DATE_FORMAT,
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					},
    			        change: function(field, newValue, oldValue) {
    			            var endDateField = field.up('form').down('#END_DATE');
    			            endDateField.setMinValue(newValue);
    			        }
    				}
        		}, {
        			xtype: 'datefield',
        			name: 'END_DATE',
        			itemId: 'END_DATE',
        			vtype: 'daterange',
        			startDateField: 'START_DATE',
        			fieldLabel: getAdmissionTranslation('END_DATE'),
//        			allowBlank: false,
        			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
//        			format: CONSTANTS.DATE_FORMAT,
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					},
    			        change: function(field, newValue, oldValue) {
    			            var startDateField = field.up('form').down('#START_DATE');
    			            startDateField.setMaxValue(newValue);
    			        }
    				}
        		},{
                    xtype: 'customcombobox',
                    fieldLabel: getAdmissionTranslation('CAMPAIGN'),
                    editable: false,
//                    autoload: true,
                    name: 'CAMPAIGN',
                    itemId: 'campainId',
                    valueField: 'id',                
                    displayField: 'value',
//                    queryMode: 'local',
                    listeners: {
                        render: function(combo) {
                            var store = Ext.create('Academia.store.campaign.AllActiveCampaignsStore');
                            combo.bindStore(store);
                        }
                    }
                }]
            },{
        	xtype : 'fieldcontainer',
			width : 'auto',
			layout: 'hbox',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SEARCH'),
				itemId : 'finalAdmissionListSearchButtonId',
				ui : 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			}, {
				xtype: 'button',
				text : getCommonTranslation('RESET'),
				itemId : 'finalAdmissionListResetButtonId',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
				listeners: {
	                click: function(button, eOpts) {
	                	this.up('form').getForm().reset();
	                	var form = this.up('form');
	                	
	                	var startDateField = form.down('#START_DATE');
	                    var endDateField = form.down('#END_DATE');
	                    startDateField.setMaxValue(null);
	                    endDateField.setMinValue(null); 
	                    
	                	form.down('#batchId').setDisabled(true);
	                	form.down('#seatTypeId').setDisabled(true);
	                	form.down('#quotaId').setDisabled(true);
	                }
	            }
			} ]
		}]
});
