/**
 * This Grid is used for Quotas Type List grid in Quota setting
 * 
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.quotas.QuotaTypeGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.quotatypegrid',
	title : getAdmissionTranslation('QUOTA_TYPE_LIST'),
	border : true,
	
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns : [/*{
		xtype: 'rownumberer'
	},*/ {
		text : getAdmissionTranslation('DISPLAY_ORDER'),
		dataIndex: 'displayOrder',
		hidden: true
	}, {
		text : getAdmissionTranslation('QUOTA_TYPE'),
		dataIndex : 'code',
		sortable : true,
		flex: 1,
		renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return val;
			}
		}
	},{
        xtype:'actioncolumn',
        text : getAdmissionTranslation('REORDER'),
        width:'auto',
        sortable : true,
        items: [{
        	xtype: 'button',
        	itemId: 'upButton',
        	iconCls: Ext.baseCSSPrefix + 'form-itemselector-up',  // Use a URL in the icon config
            tooltip: 'UP',
            handler: function(grid, rowIndex, colIndex) {
            	if(rowIndex != 0) {
	            	var record = grid.getStore().getAt(rowIndex);
	            	var previousRecord = grid.getStore().getAt(rowIndex-1); 
	            	previousRecord.set('displayOrder', (previousRecord.get('displayOrder'))+1);
	            	//previousRecord.index = (previousRecord.index)+1;
	            	record.set('displayOrder', (record.get('displayOrder'))-1);
	            	//record.index = (record.index)-1;
	            	grid.getStore().sort();
	            	
	            	grid.getStore().remove(record, true);
                    grid.getStore().insert(rowIndex-1, record);
                    grid.getStore().remove(previousRecord, true);
                    grid.getStore().insert(rowIndex, previousRecord);
            	} else {
            		showErrorMessage(getCommonTranslation('REORDER'), getErrorTranslation('UPERRORMESSAGE'));
            	}
            }
        },{
        	xtype: 'button',
        	itemId: 'downButton',
        	iconCls: Ext.baseCSSPrefix + 'form-itemselector-down',
            tooltip: 'DOWN',
            handler: function(grid, rowIndex, colIndex) {
            	/*console.log(grid.getStore())
            	console.log(rowIndex)*/
            	lastRowIndex = grid.getStore().getCount()-1;
            	if(rowIndex != lastRowIndex) {
	            	var record = grid.getStore().getAt(rowIndex);
	            	var nextRecord = grid.getStore().getAt(rowIndex+1); 
	            	nextRecord.set('displayOrder', (nextRecord.get('displayOrder'))-1);
	            	//nextRecord.index = (nextRecord.index)-1;
	            	record.set('displayOrder', (record.get('displayOrder'))+1);
	            	//record.index = (record.index)+1;
	            	
	            	grid.getStore().remove(record, true);
                    grid.getStore().insert(rowIndex+1, record);
                    grid.getStore().remove(nextRecord, true);
                    grid.getStore().insert(rowIndex, nextRecord);
            	} else {
            		showErrorMessage(getCommonTranslation('REORDER'), getErrorTranslation('DOWNERRORMESSAGE'));
            	}
            }
        }]
	}],
    tbar : [{
		xtype : 'button',				
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}, {
        xtype: 'button',
        text: getAdmissionTranslation('SAVE_REORDERING'),
        itemId: 'saveReordering',
        tooltip:getAdmissionTranslation('SAVE_REORDERING')
    }],
	
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
                    displayInfo: true
                }]
            }]
        });
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.admission.quotas.QuotaTypeLists');
    },

});
