/**
 * this window is used to show the quota type popup on the quotas grid.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.quotas.QuotaTypeWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.quotatypewindow',
    modal: true,
    resizable: false,
    title: getAdmissionTranslation('QUOTA_TYPE'), // quota Details
    items: [{
        xtype: 'idgeneratorform',
        itemId: 'quotaTypeForm',
        formCode:'quota_type_form',
        standardSubmit: false,
        plugins: "formlabelrequired",
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype : 'hidden',
        	name: 'id'
        },{
        	xtype : 'hidden',
        	name: 'version'
        },{
        	xtype : 'hidden',
        	name: 'displayOrder'
        },{
            xtype: 'textfield',
            name: 'code',
            fieldLabel: getAdmissionTranslation('QUOTA_TYPE'), //quota type
            allowBlank: false
        }, {
            xtype: 'textarea',
            name: 'description',
            itemId: 'quotaDescription',
            fieldLabel: getAdmissionTranslation('QUOTA_DESCRIPTION')  //decription
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                itemId: 'btnSaveAddQuotaWindow',
                text: getCommonTranslation('SAVE'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelAddQuotaWindow',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]

});