/**
 * this window is used to show the quota validity grid in a window for editing and deleting a record.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.quotas.QuotaValidityGridWindow', {
	extend : 'Ext.window.Window',
	alias : 'widget.quotavaliditygridwindow',
	autoScroll: true,
	modal : true,
	resizable : false,
	margin : 0,
	height: '50%',
	width: '50%',
	title : getAdmissionTranslation('QUOTA_VALIDITY'),// quota Details
	items : [ {
		xtype : 'grid',
		store: 'Academia.store.admission.quotas.QuotaValidity',
		    title: getAdmissionTranslation('QUOTA_VALIDITY'),
		    border: true,
		    viewConfig: {
		        stripeRows: CONSTANTS.STRIPEROWS
		    },

		    columns: [/*{
		        text: 'id',
		        dataIndex: 'id',
		        hidden:true
		    },*/{
		    	text: getAdmissionTranslation('VALID_FROM'),
		        dataIndex: 'validFrom',
		        sortable: true,
		        flex: 1,
				renderer:function(val){		
					return dateRender(val);
				}
		    }, {
		        text: getAdmissionTranslation('VALID_TILL'),
		        dataIndex: 'validTill',
		        sortable: true,
		        flex: 1,
				renderer:function(val){		
					return dateRender(val);
				}
		    }, {
		        text: getAdmissionTranslation('STATUS'),
		        dataIndex: 'status',
		        renderer: activeInactiveRenderer,
		        sortable: true,
		        flex: 1
		    }],
		    /*
		     * Commenting this, Uncomment if paging toolbar has to be added to the grid.
		     * also reload the values from the controller where values are being set into the store of this grid.
		     */
		   /* dockedItems: [{
		        xtype: 'toolbar',
		        dock: 'bottom',
		        items: [{
		        	xtype: 'custompagingtoolbar',
			        plugins:['pagesize'],
		        	displayInfo : true,		 
		        	emptyMsg :getAdmissionTranslation('EMPTY_QUOTA_MESSAGE'),
					store : 'Academia.store.admission.quotas.QuotaValidity'
		        }]
		    }],*/
		    dockedItems: [{
		        xtype: 'toolbar',
		        dock: 'top',
		        items: [{
					xtype : 'button',				
					itemId : 'btnEditQuotaValidity',
					text : getCommonTranslation('EDIT')
				}, {
			        xtype: 'button',
			        itemId: 'btnDeleteQuotaValidity',
			        cls: 'CustomToolbarBtnReject',
			        text: getCommonTranslation('DELETE') //Delete
			    }]
		    }]

	} ]
	
	

});
