Ext.define('Academia.view.admission.quotas.QuotaWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.quotawindow',
    modal: true,
    resizable: false,
    title: getAdmissionTranslation('QUOTA_DETAILS'),
    items: [{
        xtype: 'idgeneratorform',
        formCode : 'quota_form',
        itemId: 'quotaForm',
        standardSubmit: false,
        plugins: "formlabelrequired",
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype : 'hidden',
        	name: 'displayOrder'
        },{
        	xtype : 'hidden',
        	name: 'id'
        },{
        	xtype : 'hidden',
        	name: 'version'
        },{
        	xtype : 'hidden',
        	name: 'quotaTypeId'
        },{
            xtype: 'textfield',
            name: 'code',
            fieldLabel: getAdmissionTranslation('QUOTA'),
            allowBlank: false
        }, {
            xtype: 'textarea',
            name: 'quotaDescription',
            fieldLabel: getAdmissionTranslation('QUOTA_DESCRIPTION')
        }, {
            xtype: 'textfield',
            name: 'applicabilityRule',
            fieldLabel: getAdmissionTranslation('APPLICABLE_RULE'),
            allowBlank: false
        }, {
            xtype: 'textarea',
            name: 'ruleDescription',
            fieldLabel: getAdmissionTranslation('RULE_DESCRIPTION')
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                itemId: 'btnSaveQuotaDetails',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            },{
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
                    click: function() {
                        this.up('window').close(); 
                    }
                }
            }]
        }]
    }]

});