/**
 * This window is used in the Add/Edit/View of the Resource Requirement window
 * of the Resource Requirement Grid
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.selectionProcess.ResourceRequirementWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.resourcerequirementwindow',
    modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    title: getAdmissionTranslation('RESOURCE_REQUIREMENT'),
    items: [{
        xtype: 'form',
        itemId: 'resourceRequirementForm',
        standardSubmit: false,
        plugins: "formlabelrequired",
        defaults: {
            labelAlign: 'top',
            width: '452px'
        },
        items: [{
        	xtype : 'hidden',
        	name: 'id'
        },{
        	xtype: 'radiogroup',
        	fieldLabel: getAdmissionTranslation('RESOURCE_GROUP'),
        	itemId:'resourceGroupId',
            columns: 4,
            width: 'auto',
            vertical: true,
            allowBlank: false,
            items: [{
                boxLabel: getAdmissionTranslation('FACILITY'),
                itemId:'facilityId',
                name: 'resourceGroup',
                inputValue: 'FACILITY'
            }, {
                boxLabel: getAdmissionTranslation('EQUIPMENT'),
                itemId:'equipmentId',
                name: 'resourceGroup',
                inputValue: 'EQUIPMENT'
            }, {
                boxLabel: getAdmissionTranslation('STAFF'),
                itemId:'staffId',
                name: 'resourceGroup',
                inputValue: 'STAFF'
            }, {
                boxLabel: getAdmissionTranslation('FACULTY'),
                itemId:'facultyId',
                name: 'resourceGroup',
                inputValue: 'FACULTY'
            }]
        },{
        	xtype: 'radiogroup',
        	fieldLabel: getAdmissionTranslation('RESOURCE_CATEGORY'),
        	itemId:'resourceCategoryId',
        	hidden :true,
        	allowBlank: false,
        	items: [{
                boxLabel: getAdmissionTranslation('INTERNAL'),
                name: 'resourceCategory',
                inputValue: 'INTERNAL',
                checked: true
            }, {
                boxLabel: getAdmissionTranslation('EXTERNAL'),
                name: 'resourceCategory',
                inputValue: 'EXTERNAL'
            }]
        },{
        	xtype: 'fieldcontainer',
        	width: 'auto',
        	layout: {
        		type: 'hbox'
        	},
	    	 defaults: {
	             labelAlign: 'top',
	             width: 256
	         },
        	items: [{
        		xtype: 'nestedJsonCombo',
        		itemId: 'resourceTypeCombo',
                name: 'resourceTypes',
                fieldLabel: getAdmissionTranslation('RESOURCE_TYPE'),
                store:Ext.create('Academia.store.facilitiesresources.resourcebooking.ResourceTypeStore'),
                displayField: 'value',
                valueField: 'id',
    	        allowBlank: false,
    	        editable: false,
    			queryMode:'local',
    			hidden :true
        	}, {
        		xtype: 'numberfield',
    			name : 'resourceQuantity',
    			allowBlank: false,
    			fieldLabel : getAdmissionTranslation('QUANTITY'),// quota type
    			allowBlank: false,
    			minValue: 0,
    			maxValue: 100
        	}]
        },{
        	xtype: 'textarea',
        	width: 256,
            name: 'remark',
            fieldLabel: getAdmissionTranslation('REMARKS')
        }, {
            xtype: 'fieldcontainer',
            
            items: [{
                xtype: 'button',
                itemId: 'btnSaveResourseRequirements',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            },{
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
                    click: function() {
                        this.up('window').close(); 
                    }
                }
            }]
        }]
    }]

});