/**
 * This form is used for Add/Edit/View of the selection process record from the selection
 * process grid, from selection process of admissions module.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.selectionProcess.SelectionProcessForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.selectionprocessform',
    title: getAdmissionTranslation('SELECTION_PROCESS_DETAILS'),
    cls:'selection-process-form-cls',
    standardSubmit: false,
    autoScroll: true,
    plugins: "formlabelrequired",
    defaults: {
        labelAlign: 'top'
    },
    items: [{
    	xtype:'form',
    	itemId:'selectionProcessFormId',
    	items:[{
    	    	xtype : 'hidden',
    	    	name: 'id'
    	    },{
    	    	xtype : 'hidden',
    	    	name: 'numberOfStages'
    	    },{
    	    	xtype : 'hidden',
    	    	name: 'version'
    		}, {
    			xtype : 'fieldcontainer',
    			layout: {
    				type:'table',
    				columns :3
    			},
    			defaults: {
    		        labelAlign: 'top',
    		        width: 256
    		    },
    			items : [ {
    				xtype : 'textfield',
    				name : 'name',
    				vtype:'NoSpaceAndSpecialCharactersAsInput',
    				fieldLabel : getAdmissionTranslation('SELECTION_PROCESS_NAME'),
    				allowBlank : false
    	        },{
    	            xtype: 'statusCombo',
    	            allowBlank: false,
    	            editable: false,
    	            width: 256,
    	            name: 'status',
    	            value:true 
    			},{
    	            xtype: 'customcombobox',
    	            allowBlank: false,
    	            editable: false,
    	            width: 256,
    	            name: 'selectionProcessType',
    	            itemId:'selectionProcessType',
    	            store: 'admission.admissionCycle.SelectionProcessTypeStore',
    	            fieldLabel : getAdmissionTranslation('SELECTION_PROCESS_TYPE'),
    	            valueField: 'id',
    				displayField: 'value',
    				typeAhead:true,
    				forceSelection:true
    			}, {
    				xtype : 'textarea',
    				name : 'remark',
    				itemId:'remark',
    				fieldLabel : getAdmissionTranslation('SELECTION_PROCESS_REMARKS')
    			}, {
    				xtype : 'textarea',
    				name : 'quotaTypeRemark',
    				itemId : 'quotaTypeRemark',
    				fieldLabel : getAdmissionTranslation('QUOTA_TYPE_REMARKS')
    			} ]
    		},{
    			xtype : 'fieldcontainer',
    			width: '100%',
    			defaults: {
    		        labelAlign: 'top',
    		        width: 650
    		    },
    			items: [ {
    				xtype: 'itemselector',
    		        cls: 'itemSelectorCls',
    				itemId: 'quotaTypeSelector',
    				fieldLabel: getAdmissionTranslation('APPLICABLE_QUOTA_TYPE'),
    				name: 'quotaTypeIds',
    				labelCls:'itemSelectorLabelCls',
    				store : 'admission.selectionProcess.QuotaTypes',
    		        displayField: 'code',
    		        valueField: 'id',           
//    		        allowBlank: false,
    		        msgTarget: 'side',
    		        maxHeight :400,
    		        fromTitle: getAdmissionTranslation('QUOTA_TYPES'),
    		        toTitle: getAdmissionTranslation('APPLICABLE_QUOTA_TYPES'),
    		        getSubmitData: function() {
    		        	  var me = this,
    		              data = null,
    		              val;
    		          if (!me.disabled && me.submitValue && !me.isFileUpload()) {
    		              val = me.getSubmitValue();
    		              val = '['+val+']';
    		              val = Ext.decode(val);
    		              if (val !== null) {
    		                  data = {};
    		                  data[me.getName()] = val;
    		              }
    		          }
    		          return data;
    		        }
    			}]
    		}, {
    			xtype:'fieldcontainer',
    			cls: 'form-fixed-footer',
    			width:'auto',
    	        items: [{
    	            xtype: 'button',
    	            itemId: 'btnSaveSelectionProcess',
    	            text: getCommonTranslation('SAVE'), 
    	            ui: 'CustomBtnSubmit',
    	            scale: CONSTANTS.BUTTONSIZE,
    	            formBind: true
    	        },{
    	            xtype: 'button',
    	            text: getExaminationTranslation('RESET'),
    	            itemId: 'gradeMasterResetButtonId',
    	            ui: 'CustomBtnCancel',
    	            scale: CONSTANTS.BUTTONSIZE,
    	            handler: function() {
    	                this.up('form').getForm().reset();
    	            }
    	        }]
    	    
    	}]
    }]

});