/**
 * @author Harshit Satya
 * 
 */
Ext.define('Academia.view.admission.selectionStage.DownloadSelectionStatusForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.downloadselectionstatusform',
	//plugins : "formlabelrequired",
	frame: false,
	method : 'POST',
	//cls:'customSearchPanel',
	standardSubmit : false,

	items : [{
		xtype : 'fieldcontainer',
		items : [{
			xtype: 'fieldcontainer',
			width: '100%',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'ACADEMY_LOCATION_ID',
				itemId: 'academyComboDSSF',
				labelAlign: 'top',
				width: 536,
				displayField: 'value',
				valueField: 'id',
				queryMode: 'remote',
				fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
				allowBlank:false,
				queryParam:'qry',
				editable: false,
				listeners: {
					render: function(combo) {
						var storeUrl='Academia.store.user.UserAcademyLocationStore';
						if(this.up('form').checkUserAccess==true){
							storeUrl='Academia.store.user.UserAcademyLocationStore';
						}
						var store = Ext.create(storeUrl);
						combo.bindStore(store);
					}
				}
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('INTAKE_YEAR'),
				name : 'intakeYear',
				itemId : 'intakeYearDSSF',
				displayField:'value',
				valueField:'id',
				forceSelection: true,
	            editable: true,
	            typeAhead:false,
	            cls:'commonAutoHeightMultiselectField',
	            editable: false,
	            anyMatch:true,
	            allowBlank:false,
	            width: 256,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				},
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.IntakeYearStore');
						combo.bindStore(store)
					}
				}
			},{
				xtype: 'multiselectcombofield',
			    name: 'programId',
			    itemId: 'programIdDSSF',
			    fieldLabel: getEnquiryTranslation('PROGRAM'),
			    displayField: 'valueCode',
			    valueField: 'id',
			    width: 256,
			    allowBlank: false,
			    editable: false,
			    maxLength: undefined,
			    forceSelection: true,
			    queryMode: 'local',
			    queryParam: 'qry',
			    hidden: false,
			    disabled: true, 
			    cls: 'commonAutoHeightMultiselectField',
			    store: Ext.create('Academia.store.program.ProgramByALAndIntakeYearIdStore'),
			    listConfig: {
			        listeners: {
			            beforeshow: function(picker) {
			                picker.minWidth = picker.up('combobox').getSize().width;
			            }
			        },
			        loadingText: getCommonTranslation('SEARCHING'),
			        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			        getInnerTpl: function () {
			            return '<div class="search-item">{valueCode}</div>';
			        }
			    },
			    listeners: {
			        afterrender: function(field) {
			            field.getEl().on('keydown', function(e) {
			                e.stopEvent();
			            });
			        },
			    }
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				labelAlign: 'top'
			},
			items :[{
				xtype : 'multiselectcombofield',
				cls:'commonAutoHeightMultiselectField',
				fieldLabel : getEnquiryTranslation('BATCH'),
				autoloadStore: false,
				name : 'batchId',
				itemId : 'batchDSSF',
				displayField : 'valueSecondValue',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				hidden : false,
				maxLength: undefined,
				width: 256,
				queryMode:'local',
				allowBlank: false,
				disabled:true,
				editable: false,
				matchFieldWidth:true,
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.enquiry.AcademicBatchOnALIntakePeriodsStores');
						combo.bindStore(store);
					},
					afterrender: function(field) {
			            field.getEl().on('keydown', function(e) {
			                e.stopEvent();
			            });
			        },
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function () {
			            return '<div class="search-item">{valueSecondValue}</div>';
			        }
				},
			},{
				xtype : 'multiselectcombofield',
				cls:'commonAutoHeightMultiselectField',
				fieldLabel: getEnquiryTranslation('SEAT_TYPE'),
				autoloadStore: false,
				name: 'seatTypeId',
				itemId:'seatTypeDSSF',
				displayField: 'value',
				valueField: 'id',
				typeAhead : true,
				forceSelection : true,
				hidden : false,
				allowBlank: false,
				maxLength: undefined,
				width: 256,
				maxChar: false,
//				queryMode: 'local',
				disabled:true,
				editable: false,
				matchFieldWidth:true,
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.common.SeatTypeByBatchIds');
						combo.bindStore(store);
					},
					afterrender: function(field) {
			            field.getEl().on('keydown', function(e) {
			                e.stopEvent();
			            });
			        },
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
				},
			},{
        		xtype: 'multiselectcombofield',
        		itemId: 'selectionStageComboDSSF',
        		name:'PROGRAM_SELECTION_PROCESS_STAGE_ID',
                store: 'admission.selectionStage.AllSelectionStageStore',
        		fieldLabel: getAdmissionTranslation('SELECT_STAGE'),
                displayField: 'value',
                valueField: 'id',
                queryMode: 'local',
                width: 256,
                disabled: true,
                labelAlign: 'top',
                maxLength: undefined,
                autoload: false,
                listeners: {
			        afterrender: function(field) {
			            field.getEl().on('keydown', function(e) {
			                e.stopEvent();
			            });
			        },
			    }
			},{
    			xtype: 'multiselectcombofield',
    			fieldLabel: getAdmissionTranslation('STAGE_STATUS'), //Stage Status
    			name: 'STAGE_STATUS',
    			itemId: 'stageStatusDSSF',
    			editable: true,
    			store: 'admission.applications.applicationBase.ApplicationSelectionStageStatusStore',                 
    			valueField: 'name',
    			displayField: 'value',
    			//value : 'All',
    			queryMode : 'local',
    			forceSelection:true,
	            editable: false,
	            typeAhead:false,
	            maxLength: undefined,
	            width: 256,
	        	listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
				},
				listeners: {
			        afterrender: function(field) {
			            field.getEl().on('keydown', function(e) {
			                e.stopEvent();
			            });
			        },
			    }
			}]},{
				xtype: 'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				margin: '0 0 0 -46',
				defaults : {
					labelAlign : 'top'
				},
	    		cls: 'customSearchPanelBtnsFieldContainerCls',
				items: [{
					xtype: 'button',
					text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
					itemId: 'programBatchDownoladBtnIdDSSF',
					formBind : true,
					ui: 'CustomBtnSubmit'
				},{
					xtype: 'button',
					text: getCourseTxCommonTranslation('RESET'),
					itemId: 'downloadResetBtnDSSF',
					buttonAlign: 'left',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]
	}]
});
